/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.PartialStateHolderHelper;
import org.richfaces.component.AbstractAjaxFunction;

/**
 *  @author asmirnov@exadel.com (latest modification by $Author: alexsmirnov $)
 @version $Revision: 1.1.2.2 $ $Date: 2007/01/23 20:01:04 $


 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class UIFunction extends AbstractAjaxFunction
    implements ClientBehaviorHolder
    {

    public static final String COMPONENT_TYPE="org.richfaces.Function";

    public static final String COMPONENT_FAMILY="javax.faces.Command";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIFunction() {
        super();
        setRendererType("org.richfaces.FunctionRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "beforedomupdate",
        "complete",
        "begin"

        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return null;
    }

    protected static enum Properties {
        bypassUpdates,
        execute,
        limitRender,
        name,
        onbeforedomupdate,
        onbegin,
        oncomplete,
        render,
        status

    }


 
    public boolean isBypassUpdates() {
        return Boolean.valueOf(getStateHelper().eval(Properties.bypassUpdates, false).toString());
    }
    
    public void setBypassUpdates(boolean bypassUpdates) {
        getStateHelper().put(Properties.bypassUpdates, bypassUpdates);
    }

 
    public Object getExecute() {
        return (Object) getStateHelper().eval(Properties.execute);
    }
    
    public void setExecute(Object execute) {
        getStateHelper().put(Properties.execute, execute);
    }

 
    public boolean isLimitRender() {
        return Boolean.valueOf(getStateHelper().eval(Properties.limitRender, false).toString());
    }
    
    public void setLimitRender(boolean limitRender) {
        getStateHelper().put(Properties.limitRender, limitRender);
    }

 
    public String getName() {
        return (String) getStateHelper().eval(Properties.name);
    }
    
    public void setName(String name) {
        getStateHelper().put(Properties.name, name);
    }

 
    public String getOnbeforedomupdate() {
        return (String) getStateHelper().eval(Properties.onbeforedomupdate);
    }
    
    public void setOnbeforedomupdate(String onbeforedomupdate) {
        getStateHelper().put(Properties.onbeforedomupdate, onbeforedomupdate);
    }

 
    public String getOnbegin() {
        return (String) getStateHelper().eval(Properties.onbegin);
    }
    
    public void setOnbegin(String onbegin) {
        getStateHelper().put(Properties.onbegin, onbegin);
    }

 
    public String getOncomplete() {
        return (String) getStateHelper().eval(Properties.oncomplete);
    }
    
    public void setOncomplete(String oncomplete) {
        getStateHelper().put(Properties.oncomplete, oncomplete);
    }

 
    public Object getRender() {
        return (Object) getStateHelper().eval(Properties.render);
    }
    
    public void setRender(Object render) {
        getStateHelper().put(Properties.render, render);
    }

 
    public String getStatus() {
        return (String) getStateHelper().eval(Properties.status);
    }
    
    public void setStatus(String status) {
        getStateHelper().put(Properties.status, status);
    }

}