/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.PartialStateHolderHelper;
import org.richfaces.component.AbstractMediaOutput;
import java.util.Date;
import javax.el.MethodExpression;
import javax.faces.el.MethodBinding;

/**
 *  @author shura


 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class UIMediaOutput extends AbstractMediaOutput
    implements ClientBehaviorHolder
    {

    public static final String COMPONENT_TYPE="org.richfaces.MediaOutput";

    public static final String COMPONENT_FAMILY="org.richfaces.MediaOutput";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIMediaOutput() {
        super();
        setRendererType("org.richfaces.MediaOutputRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "keypress",
        "mousedown",
        "keyup",
        "dblclick",
        "click",
        "blur",
        "mouseover",
        "focus",
        "mousemove",
        "mouseout",
        "keydown",
        "mouseup"

        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return null;
    }

    protected static enum Properties {
        accesskey,
        align,
        archive,
        border,
        cacheable,
        charset,
        classid,
        codebase,
        codetype,
        coords,
        createContent,
        createContentExpression,
        declare,
        dir,
        element,
        expires,
        hreflang,
        hspace,
        ismap,
        lang,
        lastModified,
        mimeType,
        onblur,
        onclick,
        ondblclick,
        onfocus,
        onkeydown,
        onkeypress,
        onkeyup,
        onmousedown,
        onmousemove,
        onmouseout,
        onmouseover,
        onmouseup,
        rel,
        rev,
        shape,
        standby,
        style,
        styleClass,
        tabindex,
        target,
        title,
        type,
        uriAttribute,
        usemap,
        vspace

    }


 
    public String getAccesskey() {
        return (String) getStateHelper().eval(Properties.accesskey);
    }
    
    public void setAccesskey(String accesskey) {
        getStateHelper().put(Properties.accesskey, accesskey);
    }

 
    public String getAlign() {
        return (String) getStateHelper().eval(Properties.align);
    }
    
    public void setAlign(String align) {
        getStateHelper().put(Properties.align, align);
    }

 
    public String getArchive() {
        return (String) getStateHelper().eval(Properties.archive);
    }
    
    public void setArchive(String archive) {
        getStateHelper().put(Properties.archive, archive);
    }

 
    public String getBorder() {
        return (String) getStateHelper().eval(Properties.border);
    }
    
    public void setBorder(String border) {
        getStateHelper().put(Properties.border, border);
    }

 
    public boolean isCacheable() {
        return Boolean.valueOf(getStateHelper().eval(Properties.cacheable, false).toString());
    }
    
    public void setCacheable(boolean cacheable) {
        getStateHelper().put(Properties.cacheable, cacheable);
    }

 
    public String getCharset() {
        return (String) getStateHelper().eval(Properties.charset);
    }
    
    public void setCharset(String charset) {
        getStateHelper().put(Properties.charset, charset);
    }

 
    public String getClassid() {
        return (String) getStateHelper().eval(Properties.classid);
    }
    
    public void setClassid(String classid) {
        getStateHelper().put(Properties.classid, classid);
    }

 
    public String getCodebase() {
        return (String) getStateHelper().eval(Properties.codebase);
    }
    
    public void setCodebase(String codebase) {
        getStateHelper().put(Properties.codebase, codebase);
    }

 
    public String getCodetype() {
        return (String) getStateHelper().eval(Properties.codetype);
    }
    
    public void setCodetype(String codetype) {
        getStateHelper().put(Properties.codetype, codetype);
    }

 
    public String getCoords() {
        return (String) getStateHelper().eval(Properties.coords);
    }
    
    public void setCoords(String coords) {
        getStateHelper().put(Properties.coords, coords);
    }

 
    public javax.faces.el.MethodBinding getCreateContent() {
        return (MethodBinding) getStateHelper().get(Properties.createContent);
    }
    
    public void setCreateContent(javax.faces.el.MethodBinding createContent) {
        getStateHelper().put(Properties.createContent, createContent);
    }

 
    public javax.el.MethodExpression getCreateContentExpression() {
        return (MethodExpression) getStateHelper().get(Properties.createContentExpression);
    }
    
    public void setCreateContentExpression(javax.el.MethodExpression createContentExpression) {
        getStateHelper().put(Properties.createContentExpression, createContentExpression);
    }

 
    public String getDeclare() {
        return (String) getStateHelper().eval(Properties.declare);
    }
    
    public void setDeclare(String declare) {
        getStateHelper().put(Properties.declare, declare);
    }

 
    public String getDir() {
        return (String) getStateHelper().eval(Properties.dir);
    }
    
    public void setDir(String dir) {
        getStateHelper().put(Properties.dir, dir);
    }

 
    public String getElement() {
        return (String) getStateHelper().eval(Properties.element);
    }
    
    public void setElement(String element) {
        getStateHelper().put(Properties.element, element);
    }

 
    public java.util.Date getExpires() {
        return (Date) getStateHelper().eval(Properties.expires);
    }
    
    public void setExpires(java.util.Date expires) {
        getStateHelper().put(Properties.expires, expires);
    }

 
    public String getHreflang() {
        return (String) getStateHelper().eval(Properties.hreflang);
    }
    
    public void setHreflang(String hreflang) {
        getStateHelper().put(Properties.hreflang, hreflang);
    }

 
    public String getHspace() {
        return (String) getStateHelper().eval(Properties.hspace);
    }
    
    public void setHspace(String hspace) {
        getStateHelper().put(Properties.hspace, hspace);
    }

 
    public boolean isIsmap() {
        return Boolean.valueOf(getStateHelper().eval(Properties.ismap, false).toString());
    }
    
    public void setIsmap(boolean ismap) {
        getStateHelper().put(Properties.ismap, ismap);
    }

 
    public String getLang() {
        return (String) getStateHelper().eval(Properties.lang);
    }
    
    public void setLang(String lang) {
        getStateHelper().put(Properties.lang, lang);
    }

 
    public java.util.Date getLastModified() {
        return (Date) getStateHelper().eval(Properties.lastModified);
    }
    
    public void setLastModified(java.util.Date lastModified) {
        getStateHelper().put(Properties.lastModified, lastModified);
    }

 
    public String getMimeType() {
        return (String) getStateHelper().eval(Properties.mimeType);
    }
    
    public void setMimeType(String mimeType) {
        getStateHelper().put(Properties.mimeType, mimeType);
    }

 
    public String getOnblur() {
        return (String) getStateHelper().eval(Properties.onblur);
    }
    
    public void setOnblur(String onblur) {
        getStateHelper().put(Properties.onblur, onblur);
    }

 
    public String getOnclick() {
        return (String) getStateHelper().eval(Properties.onclick);
    }
    
    public void setOnclick(String onclick) {
        getStateHelper().put(Properties.onclick, onclick);
    }

 
    public String getOndblclick() {
        return (String) getStateHelper().eval(Properties.ondblclick);
    }
    
    public void setOndblclick(String ondblclick) {
        getStateHelper().put(Properties.ondblclick, ondblclick);
    }

 
    public String getOnfocus() {
        return (String) getStateHelper().eval(Properties.onfocus);
    }
    
    public void setOnfocus(String onfocus) {
        getStateHelper().put(Properties.onfocus, onfocus);
    }

 
    public String getOnkeydown() {
        return (String) getStateHelper().eval(Properties.onkeydown);
    }
    
    public void setOnkeydown(String onkeydown) {
        getStateHelper().put(Properties.onkeydown, onkeydown);
    }

 
    public String getOnkeypress() {
        return (String) getStateHelper().eval(Properties.onkeypress);
    }
    
    public void setOnkeypress(String onkeypress) {
        getStateHelper().put(Properties.onkeypress, onkeypress);
    }

 
    public String getOnkeyup() {
        return (String) getStateHelper().eval(Properties.onkeyup);
    }
    
    public void setOnkeyup(String onkeyup) {
        getStateHelper().put(Properties.onkeyup, onkeyup);
    }

 
    public String getOnmousedown() {
        return (String) getStateHelper().eval(Properties.onmousedown);
    }
    
    public void setOnmousedown(String onmousedown) {
        getStateHelper().put(Properties.onmousedown, onmousedown);
    }

 
    public String getOnmousemove() {
        return (String) getStateHelper().eval(Properties.onmousemove);
    }
    
    public void setOnmousemove(String onmousemove) {
        getStateHelper().put(Properties.onmousemove, onmousemove);
    }

 
    public String getOnmouseout() {
        return (String) getStateHelper().eval(Properties.onmouseout);
    }
    
    public void setOnmouseout(String onmouseout) {
        getStateHelper().put(Properties.onmouseout, onmouseout);
    }

 
    public String getOnmouseover() {
        return (String) getStateHelper().eval(Properties.onmouseover);
    }
    
    public void setOnmouseover(String onmouseover) {
        getStateHelper().put(Properties.onmouseover, onmouseover);
    }

 
    public String getOnmouseup() {
        return (String) getStateHelper().eval(Properties.onmouseup);
    }
    
    public void setOnmouseup(String onmouseup) {
        getStateHelper().put(Properties.onmouseup, onmouseup);
    }

 
    public String getRel() {
        return (String) getStateHelper().eval(Properties.rel);
    }
    
    public void setRel(String rel) {
        getStateHelper().put(Properties.rel, rel);
    }

 
    public String getRev() {
        return (String) getStateHelper().eval(Properties.rev);
    }
    
    public void setRev(String rev) {
        getStateHelper().put(Properties.rev, rev);
    }

 
    public String getShape() {
        return (String) getStateHelper().eval(Properties.shape);
    }
    
    public void setShape(String shape) {
        getStateHelper().put(Properties.shape, shape);
    }

 
    public String getStandby() {
        return (String) getStateHelper().eval(Properties.standby);
    }
    
    public void setStandby(String standby) {
        getStateHelper().put(Properties.standby, standby);
    }

 
    public String getStyle() {
        return (String) getStateHelper().eval(Properties.style);
    }
    
    public void setStyle(String style) {
        getStateHelper().put(Properties.style, style);
    }

 
    public String getStyleClass() {
        return (String) getStateHelper().eval(Properties.styleClass);
    }
    
    public void setStyleClass(String styleClass) {
        getStateHelper().put(Properties.styleClass, styleClass);
    }

 
    public String getTabindex() {
        return (String) getStateHelper().eval(Properties.tabindex);
    }
    
    public void setTabindex(String tabindex) {
        getStateHelper().put(Properties.tabindex, tabindex);
    }

 
    public String getTarget() {
        return (String) getStateHelper().eval(Properties.target);
    }
    
    public void setTarget(String target) {
        getStateHelper().put(Properties.target, target);
    }

 
    public String getTitle() {
        return (String) getStateHelper().eval(Properties.title);
    }
    
    public void setTitle(String title) {
        getStateHelper().put(Properties.title, title);
    }

 
    public String getType() {
        return (String) getStateHelper().eval(Properties.type);
    }
    
    public void setType(String type) {
        getStateHelper().put(Properties.type, type);
    }

 
    public String getUriAttribute() {
        return (String) getStateHelper().eval(Properties.uriAttribute);
    }
    
    public void setUriAttribute(String uriAttribute) {
        getStateHelper().put(Properties.uriAttribute, uriAttribute);
    }

 
    public String getUsemap() {
        return (String) getStateHelper().eval(Properties.usemap);
    }
    
    public void setUsemap(String usemap) {
        getStateHelper().put(Properties.usemap, usemap);
    }

 
    public String getVspace() {
        return (String) getStateHelper().eval(Properties.vspace);
    }
    
    public void setVspace(String vspace) {
        getStateHelper().put(Properties.vspace, vspace);
    }

}