package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.AjaxCommandRendererBase;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import static org.richfaces.renderkit.RenderKitUtils.*;


public class CommandLinkRenderer extends AjaxCommandRendererBase {
	
private static final Attributes PASS_THROUGH_ATTRIBUTES10 = attributes()
     .generic("accesskey","accesskey")
     

     .generic("charset","charset")
     

     .generic("class","styleClass")
     

     .generic("coords","coords")
     

     .generic("dir","dir")
     

     .generic("hreflang","hreflang")
     

     .generic("lang","lang")
     

     .generic("onblur","onblur")
     

     .generic("ondblclick","ondblclick")
     

     .generic("onfocus","onfocus")
     

     .generic("onkeydown","onkeydown")
     

     .generic("onkeypress","onkeypress")
     

     .generic("onkeyup","onkeyup")
     

     .generic("onmousedown","onmousedown")
     

     .generic("onmousemove","onmousemove")
     

     .generic("onmouseout","onmouseout")
     

     .generic("onmouseover","onmouseover")
     

     .generic("onmouseup","onmouseup")
     

     .generic("rel","rel")
     

     .generic("rev","rev")
     

     .generic("shape","shape")
     

     .generic("style","style")
     

     .generic("tabindex","tabindex")
     

     .generic("target","target")
     

     .generic("title","title")
     

     .generic("type","type")
     
;
	
private static final Attributes PASS_THROUGH_ATTRIBUTES11 = attributes()
     .generic("class","styleClass")
     

     .generic("dir","dir")
     

     .generic("lang","lang")
     

     .generic("onclick","onclick")
     

     .generic("ondblclick","ondblclick")
     

     .generic("onkeydown","onkeydown")
     

     .generic("onkeypress","onkeypress")
     

     .generic("onkeyup","onkeyup")
     

     .generic("onmousedown","onmousedown")
     

     .generic("onmousemove","onmousemove")
     

     .generic("onmouseout","onmouseout")
     

     .generic("onmouseover","onmouseover")
     

     .generic("onmouseup","onmouseup")
     

     .generic("style","style")
     

     .generic("title","title")
     
;
	
	
private static boolean convertToBoolean(Object object) 
 {
		if (object == null) {
    return false;
}

if (object instanceof Boolean) {
    return Boolean.TRUE.equals(object);
}

return Boolean.valueOf(object.toString());

	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
	if ((!convertToBoolean(component.getAttributes().get("disabled")))) {
	responseWriter.startElement("a", component); 
	  responseWriter.writeURIAttribute("href","#",null);

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("name",value,null);
      }
      
   }

   {
      Object value = this.getOnClick(facesContext,component);
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onclick",value,null);
      }
      
   }

renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES10);

	{
	Object text = component.getAttributes().get("value");
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

	renderChildren(facesContext, component);
	responseWriter.endElement("a"); 
	} else  { 
	responseWriter.startElement("span", component); 
	   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES11);

	{
	Object text = component.getAttributes().get("value");
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

	renderChildren(facesContext, component);
	responseWriter.endElement("span"); 
}

	}
	
@Override
public boolean getRendersChildren() 
 {
		return true;
	}
}

