package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.html.PanelBaseRenderer;
import static org.richfaces.renderkit.RenderKitUtils.*;


public class PanelRenderer extends PanelBaseRenderer {
	
private static final Attributes PASS_THROUGH_ATTRIBUTES30 = attributes()
     .generic("align","align")
     

     .generic("dir","dir")
     

     .generic("lang","lang")
     

     .generic("onclick","onclick")
     

     .generic("ondblclick","ondblclick")
     

     .generic("onkeydown","onkeydown")
     

     .generic("onkeypress","onkeypress")
     

     .generic("onkeyup","onkeyup")
     

     .generic("onmousedown","onmousedown")
     

     .generic("onmousemove","onmousemove")
     

     .generic("onmouseout","onmouseout")
     

     .generic("onmouseover","onmouseover")
     

     .generic("onmouseup","onmouseup")
     

     .generic("style","style")
     

     .generic("title","title")
     
;
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
responseWriter.startElement("div", component); 
   {
      String value = "rf-panel " + convertToString(component.getAttributes().get("styleClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES30);

	if (((component.getFacet("header") != null) && component.getFacet("header").isRendered())) {
	responseWriter.startElement("div", component); 
	   {
      String value = "rf-panel-header " + convertToString(component.getAttributes().get("headerClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + "_header";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	renderHeaderFacet(facesContext, component);
	responseWriter.endElement("div"); 
	} else if (((component.getAttributes().get("header") != null) && (!component.getAttributes().get("header").equals(""))))  { 
	responseWriter.startElement("div", component); 
	   {
      String value = "rf-panel-header " + convertToString(component.getAttributes().get("headerClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + "_header";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	{
	Object text = component.getAttributes().get("header");
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

	responseWriter.endElement("div"); 
	} else  { 
}
responseWriter.startElement("div", component); 
   {
      String value = "rf-panel-body " + convertToString(component.getAttributes().get("bodyClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + "_body";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


renderChildren(facesContext, component);
responseWriter.endElement("div"); 
responseWriter.endElement("div"); 

	}
}

