package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RenderKitUtils.Attributes;
import org.richfaces.renderkit.html.PopupPanelBaseRenderer;
import static org.richfaces.renderkit.RenderKitUtils.*;


public class PopupPanelRenderer extends PopupPanelBaseRenderer {
	
private static final Attributes PASS_THROUGH_ATTRIBUTES31 = attributes()
     .generic("align","align")
     

     .generic("dir","dir")
     

     .generic("lang","lang")
     

     .generic("onclick","onclick")
     

     .generic("ondblclick","ondblclick")
     

     .generic("onkeydown","onkeydown")
     

     .generic("onkeypress","onkeypress")
     

     .generic("onkeyup","onkeyup")
     

     .generic("onmousedown","onmousedown")
     

     .generic("onmousemove","onmousemove")
     

     .generic("onmouseout","onmouseout")
     

     .generic("onmouseover","onmouseover")
     

     .generic("onmouseup","onmouseup")
     

     .generic("title","title")
     
;
	
	
private static String convertToString(Object object) 
 {
		return object != null ? object.toString() : "";
	}
	
private static boolean convertToBoolean(Object object) 
 {
		if (object == null) {
    return false;
}

if (object instanceof Boolean) {
    return Boolean.TRUE.equals(object);
}

return Boolean.valueOf(object.toString());

	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
		ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
checkOptions(facesContext, component);
responseWriter.startElement("div", component); 
   {
      String value = clientId;
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

  responseWriter.writeAttribute("style","visibility: hidden;",null);


	if (convertToBoolean(component.getAttributes().get("modal"))) {
	responseWriter.startElement("div", component); 
	  responseWriter.writeAttribute("class","mp_shade",null);

   {
      String value = convertToString(clientId) + "_shade";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onmaskclick");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onclick",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onmaskcontextmenu");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("oncontextmenu",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onmaskdblclick");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("ondblclick",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onmaskmousedown");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onmousedown",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onmaskmousemove");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onmousemove",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onmaskmouseout");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onmouseout",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onmaskmouseover");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onmouseover",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("onmaskmouseup");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("onmouseup",value,null);
      }
      
   }


	responseWriter.endElement("div"); 
}
responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","mp_shadow",null);

   {
      String value = convertToString(clientId) + "_shadow";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


responseWriter.endElement("div"); 
responseWriter.startElement("div", component); 
   {
      String value = "mp_container " + convertToString(component.getAttributes().get("styleClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + "_container";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES31);

	if (((component.getFacet("header") != null) && component.getFacet("header").isRendered())) {
	responseWriter.startElement("div", component); 
	   {
      String value = "mp_header " + convertToString(component.getAttributes().get("headerClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + "_header";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	responseWriter.startElement("div", component); 
	  responseWriter.writeAttribute("class","mp_header_content",null);

   {
      String value = convertToString(clientId) + "_header_content";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	renderHeaderFacet(facesContext, component);
	responseWriter.endElement("div"); 
	responseWriter.endElement("div"); 
}
	if (((component.getFacet("controls") != null) && component.getFacet("controls").isRendered())) {
	responseWriter.startElement("div", component); 
	   {
      String value = "mp_header_controls " + convertToString(component.getAttributes().get("controlsClass"));
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("class",value,null);
      }
      
   }

   {
      String value = convertToString(clientId) + "_header_controls";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	renderControlsFacet(facesContext, component);
	responseWriter.endElement("div"); 
}
responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","mp_content_scroller",null);

   {
      String value = convertToString(clientId) + "_content_scroller";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      Object value = this.getStyleIfTrimmed(component);
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


responseWriter.startElement("div", component); 
  responseWriter.writeAttribute("class","mp_content",null);

   {
      String value = convertToString(clientId) + "_content";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }

   {
      Object value = component.getAttributes().get("style");
      if(null != value &&
      shouldRenderAttribute(value)
      ) {
        responseWriter.writeAttribute("style",value,null);
      }
      
   }


renderChildren(facesContext, component);
responseWriter.endElement("div"); 
responseWriter.endElement("div"); 
	if (convertToBoolean(component.getAttributes().get("resizeable"))) {
	responseWriter.startElement("div", component); 
	  responseWriter.writeAttribute("class","mp_handler  mp_handler_left",null);

   {
      String value = convertToString(clientId) + "ResizerW";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	responseWriter.endElement("div"); 
	responseWriter.startElement("div", component); 
	  responseWriter.writeAttribute("class","mp_handler mp_handler_right",null);

   {
      String value = convertToString(clientId) + "ResizerE";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	responseWriter.endElement("div"); 
	responseWriter.startElement("div", component); 
	  responseWriter.writeAttribute("class","mp_handler mp_handler_top",null);

   {
      String value = convertToString(clientId) + "ResizerN";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	responseWriter.endElement("div"); 
	responseWriter.startElement("div", component); 
	  responseWriter.writeAttribute("class","mp_handler mp_handler_bottom",null);

   {
      String value = convertToString(clientId) + "ResizerS";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	responseWriter.endElement("div"); 
	responseWriter.startElement("div", component); 
	  responseWriter.writeAttribute("class","mp_handler mp_handler_top_left",null);

   {
      String value = convertToString(clientId) + "ResizerNW";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	responseWriter.endElement("div"); 
	responseWriter.startElement("div", component); 
	  responseWriter.writeAttribute("class","mp_handler mp_handler_top_right",null);

   {
      String value = convertToString(clientId) + "ResizerNE";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	responseWriter.endElement("div"); 
	responseWriter.startElement("div", component); 
	  responseWriter.writeAttribute("class","mp_handler mp_handler_bottom_left",null);

   {
      String value = convertToString(clientId) + "ResizerSW";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	responseWriter.endElement("div"); 
	responseWriter.startElement("div", component); 
	  responseWriter.writeAttribute("class","mp_handler mp_handler_bottom_right",null);

   {
      String value = convertToString(clientId) + "ResizerSE";
      if(null != value &&
         value.length()>0
      ) {
        responseWriter.writeAttribute("id",value,null);
      }
      
   }


	responseWriter.endElement("div"); 
}
responseWriter.endElement("div"); 
responseWriter.endElement("div"); 
String script  = this.buildScript(facesContext,component); 
String showScript  = this.buildShowScript(facesContext,component); 
responseWriter.startElement("script", component); 
  responseWriter.writeAttribute("type","text/javascript",null);


{
	Object text = script;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

responseWriter.endElement("script"); 
	if ((showScript != null)) {
	responseWriter.startElement("script", component); 
	  responseWriter.writeAttribute("type","text/javascript",null);


	{
	Object text = showScript;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}

	responseWriter.endElement("script"); 
}

	}
}

