/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.application;

import java.util.Iterator;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.ajax4jsf.application.DebugLifecycle;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public class DebugLifecycleFactory
extends LifecycleFactory {
    private static final Logger LOG = RichfacesLogger.APPLICATION.getLogger();
    private DebugLifecycle debugLifecycle;
    private LifecycleFactory defaultFactory;

    public DebugLifecycleFactory(LifecycleFactory defaultFactory) {
        this.defaultFactory = defaultFactory;
        if (LOG.isDebugEnabled()) {
            LOG.debug((CharSequence)"Created Lifecycle instance");
        }
    }

    private DebugLifecycle getDebugLifecycle() {
        if (this.debugLifecycle == null) {
            this.debugLifecycle = new DebugLifecycle(this.defaultFactory.getLifecycle("DEFAULT"));
        }
        return this.debugLifecycle;
    }

    public void addLifecycle(String lifecycleId, Lifecycle lifecycle) {
        this.defaultFactory.addLifecycle(lifecycleId, lifecycle);
        if (LOG.isDebugEnabled()) {
            LOG.debug((CharSequence)("Added lifecycle with ID " + lifecycleId));
        }
    }

    public Lifecycle getLifecycle(String lifecycleId) {
        DebugLifecycle life = "DEBUG".equals(lifecycleId) ? this.getDebugLifecycle() : this.defaultFactory.getLifecycle(lifecycleId);
        return life;
    }

    public Iterator getLifecycleIds() {
        return this.defaultFactory.getLifecycleIds();
    }
}

