/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.context;

import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public final class ContextInitParameters {
    private static final String INIT_PARAM_PREFIX = ContextInitParameters.class.getSimpleName() + ":";
    private static final Object NULL = new Object(){

        public String toString() {
            return ContextInitParameters.class.getSimpleName() + ": null Object";
        }
    };

    private ContextInitParameters() {
    }

    static int getInteger(FacesContext context, String[] paramNames, int defaultValue) {
        String initParameter = ContextInitParameters.getInitParameter(context, paramNames);
        if (null == initParameter) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(initParameter);
        }
        catch (NumberFormatException e) {
            throw new FacesException("Context parameter " + paramNames + " must have integer value");
        }
    }

    static String getString(FacesContext context, String[] paramNames, String defaultValue) {
        String initParameter = ContextInitParameters.getInitParameter(context, paramNames);
        if (null == initParameter) {
            return defaultValue;
        }
        return initParameter;
    }

    static boolean getBoolean(FacesContext context, String[] paramNames, boolean defaultValue) {
        String initParameter = ContextInitParameters.getInitParameter(context, paramNames);
        if (null == initParameter) {
            return defaultValue;
        }
        if ("true".equalsIgnoreCase(initParameter) || "yes".equalsIgnoreCase(initParameter)) {
            return true;
        }
        if ("false".equalsIgnoreCase(initParameter) || "no".equalsIgnoreCase(initParameter)) {
            return false;
        }
        throw new FacesException("Illegal value [" + initParameter + "] for a init parameter +" + paramNames + ", only logical values 'true' or 'false' is allowed");
    }

    static String getInitParameter(FacesContext context, String[] paramNames) {
        ExternalContext externalContext = context.getExternalContext();
        String value = null;
        for (int i = 0; i < paramNames.length && null == value; ++i) {
            value = externalContext.getInitParameter(paramNames[i]);
        }
        return value;
    }

    private static boolean getBooleanValue(Object value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String stringValue = (String)value;
        return "true".equalsIgnoreCase(stringValue) || "yes".equalsIgnoreCase(stringValue);
    }

    private static Object evaluateInitParameterExpression(FacesContext context, Object parameterValue) {
        if (parameterValue == NULL || parameterValue == null) {
            return null;
        }
        if (parameterValue instanceof ValueExpression) {
            ValueExpression expression = (ValueExpression)parameterValue;
            return (String)expression.getValue(context.getELContext());
        }
        return parameterValue.toString();
    }
}

