/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.resource.image.animatedgif.AnimatedGifEncoder;
import org.richfaces.resource.ImageType;

public abstract class AnimationResource
extends Java2Dresource {
    private int[] delays;
    private int currFrameIndex = 0;

    public AnimationResource() {
        super(ImageType.GIF);
    }

    protected abstract Dimension getFrameSize();

    protected abstract int getNumberOfFrames();

    protected int getRepeat() {
        return -1;
    }

    protected int[] getFrameDelays() {
        if (this.delays == null) {
            this.delays = new int[this.getNumberOfFrames()];
            Arrays.fill(this.delays, 0);
        }
        return this.delays;
    }

    public InputStream getInputStream() throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(baos);
            Dimension frameSize = this.getFrameSize();
            int numberOfFrames = this.getNumberOfFrames();
            BufferedImage frame = null;
            this.currFrameIndex = 0;
            if (frameSize.getHeight() > 0.0 && frameSize.getWidth() > 0.0 && numberOfFrames > 0) {
                AnimatedGifEncoder encoder = new AnimatedGifEncoder();
                encoder.start(output);
                encoder.setRepeat(this.getRepeat());
                int[] delays = this.getFrameDelays();
                while (this.currFrameIndex < numberOfFrames) {
                    frame = this.getImageType().createImage(frameSize.width, frameSize.height);
                    Graphics2D graphics = frame.createGraphics();
                    this.paint(graphics, this.currFrameIndex++);
                    graphics.dispose();
                    encoder.addFrame(frame);
                    if (delays == null || delays.length <= this.currFrameIndex) continue;
                    encoder.setDelay(delays[this.currFrameIndex]);
                }
                encoder.finish();
            }
            output.flush();
            output.close();
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract void paint(Graphics2D var1, int var2);
}

