/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource.image.animatedgif;

import java.io.IOException;
import java.io.OutputStream;

class LZWEncoder {
    static final int BITS = 12;
    static final int HSIZE = 5003;
    private static final int EOF = -1;
    private int imgW;
    private int imgH;
    private byte[] pixAry;
    private int initCodeSize;
    private int remaining;
    private int curPixel;
    private int nBits;
    private int maxbits = 12;
    private int maxcode;
    private int maxmaxcode = 4096;
    private int[] htab = new int[5003];
    private int[] codetab = new int[5003];
    private int hsize = 5003;
    private int freeEnt = 0;
    private boolean clearFlg = false;
    private int gInitBits;
    private int clearCode;
    private int eOFCode;
    private int curAccum = 0;
    private int curBits = 0;
    private int aCount;
    private byte[] accum = new byte[256];
    private int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};

    LZWEncoder(int width, int height, byte[] pixels, int colorDepth) {
        this.imgW = width;
        this.imgH = height;
        this.pixAry = pixels;
        this.initCodeSize = Math.max(2, colorDepth);
    }

    void charOut(byte c, OutputStream outs) throws IOException {
        this.accum[this.aCount++] = c;
        if (this.aCount >= 254) {
            this.flushChar(outs);
        }
    }

    void clBlock(OutputStream outs) throws IOException {
        this.clHash(this.hsize);
        this.freeEnt = this.clearCode + 2;
        this.clearFlg = true;
        this.output(this.clearCode, outs);
    }

    void clHash(int hsize) {
        for (int i = 0; i < hsize; ++i) {
            this.htab[i] = -1;
        }
    }

    void compress(int initBits, OutputStream outs) throws IOException {
        int c;
        int fcode;
        this.gInitBits = initBits;
        this.clearFlg = false;
        this.nBits = this.gInitBits;
        this.maxcode = this.maxcode(this.nBits);
        this.clearCode = 1 << initBits - 1;
        this.eOFCode = this.clearCode + 1;
        this.freeEnt = this.clearCode + 2;
        this.aCount = 0;
        int ent = this.nextPixel();
        int hshift = 0;
        for (fcode = this.hsize; fcode < 65536; fcode *= 2) {
            ++hshift;
        }
        hshift = 8 - hshift;
        int hsizeReg = this.hsize;
        this.clHash(hsizeReg);
        this.output(this.clearCode, outs);
        block1: while ((c = this.nextPixel()) != -1) {
            int i = c << hshift ^ ent;
            fcode = (c << this.maxbits) + ent;
            if (this.htab[i] == fcode) {
                ent = this.codetab[i];
                continue;
            }
            if (this.htab[i] >= 0) {
                int disp = hsizeReg - i;
                if (i == 0) {
                    disp = 1;
                }
                do {
                    if ((i -= disp) < 0) {
                        i += hsizeReg;
                    }
                    if (this.htab[i] != fcode) continue;
                    ent = this.codetab[i];
                    continue block1;
                } while (this.htab[i] >= 0);
            }
            this.output(ent, outs);
            ent = c;
            if (this.freeEnt < this.maxmaxcode) {
                ++this.freeEnt;
                this.htab[i] = fcode;
                continue;
            }
            this.clBlock(outs);
        }
        this.output(ent, outs);
        this.output(this.eOFCode, outs);
    }

    void encode(OutputStream os) throws IOException {
        os.write(this.initCodeSize);
        this.remaining = this.imgW * this.imgH;
        this.curPixel = 0;
        this.compress(this.initCodeSize + 1, os);
        os.write(0);
    }

    void flushChar(OutputStream outs) throws IOException {
        if (this.aCount > 0) {
            outs.write(this.aCount);
            outs.write(this.accum, 0, this.aCount);
            this.aCount = 0;
        }
    }

    final int maxcode(int nBits) {
        return (1 << nBits) - 1;
    }

    private int nextPixel() {
        if (this.remaining == 0) {
            return -1;
        }
        --this.remaining;
        byte pix = this.pixAry[this.curPixel++];
        return pix & 0xFF;
    }

    void output(int code, OutputStream outs) throws IOException {
        this.curAccum &= this.masks[this.curBits];
        this.curAccum = this.curBits > 0 ? (this.curAccum |= code << this.curBits) : code;
        this.curBits += this.nBits;
        while (this.curBits >= 8) {
            this.charOut((byte)(this.curAccum & 0xFF), outs);
            this.curAccum >>= 8;
            this.curBits -= 8;
        }
        if (this.freeEnt > this.maxcode || this.clearFlg) {
            if (this.clearFlg) {
                this.nBits = this.gInitBits;
                this.maxcode = this.maxcode(this.nBits);
                this.clearFlg = false;
            } else {
                ++this.nBits;
                this.maxcode = this.nBits == this.maxbits ? this.maxmaxcode : this.maxcode(this.nBits);
            }
        }
        if (code == this.eOFCode) {
            while (this.curBits > 0) {
                this.charOut((byte)(this.curAccum & 0xFF), outs);
                this.curAccum >>= 8;
                this.curBits -= 8;
            }
            this.flushChar(outs);
        }
    }
}

