/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.configuration;

import com.google.common.base.Strings;
import com.google.common.primitives.Primitives;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.richfaces.application.configuration.ConfigurationItem;
import org.richfaces.application.configuration.ConfigurationItemSource;
import org.richfaces.application.configuration.ConfigurationService;
import org.richfaces.application.configuration.ConstantValueExpression;
import org.richfaces.application.configuration.ValueExpressionHolder;
import org.richfaces.el.util.ELUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationServiceImpl
implements ConfigurationService {
    private Map<Enum<?>, ValueExpressionHolder> itemsMap = new ConcurrentHashMap();

    private final ConfigurationItem getConfigurationItemAnnotation(Enum<?> enumKey) {
        try {
            return enumKey.getClass().getField(enumKey.name()).getAnnotation(ConfigurationItem.class);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    private <T> T coerce(FacesContext context, Object value, Class<T> targetType) {
        if (value == null) {
            return null;
        }
        if (targetType.isInstance(value)) {
            return targetType.cast(value);
        }
        if (value instanceof String) {
            PropertyEditor editor = PropertyEditorManager.findEditor(targetType);
            if (editor == null && Primitives.isWrapperType(targetType)) {
                editor = PropertyEditorManager.findEditor(Primitives.unwrap(targetType));
            }
            if (editor != null) {
                editor.setAsText((String)value);
                return targetType.cast(editor.getValue());
            }
            if (targetType.isEnum()) {
                return targetType.cast(Enum.valueOf(targetType, (String)value));
            }
        }
        throw new IllegalArgumentException();
    }

    protected ValueExpressionHolder createValueExpressionHolder(FacesContext context, Enum<?> key, Class<?> targetType) {
        String defaultValueString;
        ConfigurationItem annotation = this.getConfigurationItemAnnotation(key);
        if (annotation == null) {
            // empty if block
        }
        ValueExpression expression = this.createValueExpression(context, annotation, targetType);
        Object defaultValue = null;
        if (!(expression != null && expression.isLiteralText() || Strings.isNullOrEmpty((String)(defaultValueString = annotation.defaultValue())))) {
            defaultValue = this.coerce(context, defaultValueString, targetType);
        }
        return new ValueExpressionHolder(expression, defaultValue);
    }

    private final ValueExpression createValueExpression(FacesContext context, ConfigurationItem annotation, Class<?> targetType) {
        ConfigurationItemSource source = annotation.source();
        if (source == ConfigurationItemSource.contextInitParameter) {
            Map initMap = context.getExternalContext().getInitParameterMap();
            for (String name : annotation.names()) {
                String value = (String)initMap.get(name);
                if (Strings.isNullOrEmpty((String)value)) continue;
                if (ELUtils.isValueReference((String)value)) {
                    ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
                    if (expressionFactory == null) {
                        throw new IllegalStateException();
                    }
                    if (annotation.literal()) {
                        throw new IllegalArgumentException();
                    }
                    return expressionFactory.createValueExpression(context.getELContext(), value, targetType);
                }
                Object coercedValue = this.coerce(context, value, targetType);
                if (coercedValue == null) continue;
                return new ConstantValueExpression(coercedValue);
            }
            return null;
        }
        throw new IllegalArgumentException(source.toString());
    }

    protected <T> T getValue(FacesContext facesContext, Enum<?> key, Class<T> returnType) {
        ValueExpressionHolder holder = this.itemsMap.get(key);
        if (holder == null) {
            holder = this.createValueExpressionHolder(facesContext, key, returnType);
            this.itemsMap.put(key, holder);
        }
        return returnType.cast(holder.getValue(facesContext));
    }

    public Boolean getBooleanValue(FacesContext facesContext, Enum<?> key) {
        return this.getValue(facesContext, key, Boolean.class);
    }

    public Integer getIntValue(FacesContext facesContext, Enum<?> key) {
        return this.getValue(facesContext, key, Integer.class);
    }

    public Long getLongValue(FacesContext facesContext, Enum<?> key) {
        return this.getValue(facesContext, key, Long.class);
    }

    public String getStringValue(FacesContext facesContext, Enum<?> key) {
        return this.getValue(facesContext, key, String.class);
    }

    public <T extends Enum<T>> T getEnumValue(FacesContext facesContext, Enum<?> key, Class<T> enumClass) {
        return (T)((Enum)this.getValue(facesContext, key, enumClass));
    }

    public Object getValue(FacesContext facesContext, Enum<?> key) {
        return this.getValue(facesContext, key, Object.class);
    }
}

