/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cache;

import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.cache.Cache;
import org.richfaces.cache.CacheFactory;
import org.richfaces.cache.OSCacheCache;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSCacheCacheFactory
implements CacheFactory {
    private static final Logger LOG = RichfacesLogger.CACHE.getLogger();
    private List<GeneralCacheAdministrator> cacheAdministrators = new ArrayList<GeneralCacheAdministrator>(1);

    public OSCacheCacheFactory() throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = OSCacheCacheFactory.class.getClassLoader();
        }
        Class.forName(GeneralCacheAdministrator.class.getName(), false, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        URL resource = OSCacheCache.class.getResource("oscache.properties");
        if (resource != null) {
            InputStream stream = URLToStreamHelper.urlToStream((URL)resource);
            try {
                properties.load(stream);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    public Cache createCache(FacesContext facesContext, String cacheName, Map<?, ?> env) {
        Properties cacheProperties = new Properties();
        try {
            cacheProperties.putAll((Map<?, ?>)OSCacheCacheFactory.loadProperties());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            cacheProperties.putAll((Map<?, ?>)OSCacheCacheFactory.loadProperties());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        cacheProperties.putAll(env);
        LOG.info((CharSequence)("Creating OSCache cache instance using parameters: " + cacheProperties));
        String property = cacheProperties.getProperty("cache.capacity");
        if (property == null) {
            int maxCacheSize = ConfigurationServiceHelper.getIntConfigurationValue((FacesContext)facesContext, (Enum)CoreConfiguration.Items.resourcesCacheSize);
            LOG.info((CharSequence)MessageFormat.format("Maximum cache size hasn''t been set, resetting to {0} max items", maxCacheSize));
            cacheProperties.put("cache.capacity", Integer.toString(maxCacheSize));
        }
        GeneralCacheAdministrator cacheAdministrator = new GeneralCacheAdministrator(cacheProperties);
        this.cacheAdministrators.add(cacheAdministrator);
        return new OSCacheCache(cacheAdministrator.getCache());
    }

    public void destroy() {
        for (GeneralCacheAdministrator cacheAdministrator : this.cacheAdministrators) {
            cacheAdministrator.destroy();
        }
        this.cacheAdministrators = null;
    }
}

