/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import org.richfaces.component.MetaComponentResolver;
import org.richfaces.context.ComponentIdResolverNode;
import org.richfaces.context.IdParser;
import org.richfaces.renderkit.util.CoreRendererUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentIdResolver {
    private static Map<String, String> metaComponentSubstitutions = new HashMap<String, String>();
    private Set<String> resolvedIds;
    private Set<String> unresolvedIds;
    private Set<String> absoluteIds = null;
    private UIComponent containerTopMatchComponent;
    private LinkedList<UIComponent> componentsStack = null;
    private IdParser idParser;
    private char namingContainerSeparator;
    private FacesContext facesContext;
    private ComponentIdResolverNode rootNode;

    public ComponentIdResolver(FacesContext facesContext) {
        this.facesContext = facesContext;
        this.resolvedIds = new HashSet<String>();
        this.unresolvedIds = new HashSet<String>();
        this.rootNode = new ComponentIdResolverNode(null, null);
        this.namingContainerSeparator = UINamingContainer.getSeparatorChar((FacesContext)facesContext);
        this.idParser = new IdParser(this.namingContainerSeparator, '@');
    }

    private static boolean isNotEmpty(Collection<?> c) {
        return c != null && !c.isEmpty();
    }

    private static boolean isRoot(UIComponent component) {
        return component.getParent() == null;
    }

    private static UIComponent findRoot(UIComponent component) {
        UIComponent c = component;
        while (!ComponentIdResolver.isRoot(c)) {
            c = c.getParent();
        }
        return c;
    }

    private static UIComponent findContainer(UIComponent component) {
        UIComponent c;
        for (c = component; c != null && !(c instanceof NamingContainer); c = c.getParent()) {
        }
        return c;
    }

    private static String resolveMetaComponentId(FacesContext context, UIComponent component, String metaComponentId) {
        for (UIComponent c = component; c != null; c = c.getParent()) {
            MetaComponentResolver metaComponentResolver;
            String resolvedId;
            if (!(c instanceof MetaComponentResolver) || (resolvedId = (metaComponentResolver = (MetaComponentResolver)c).resolveClientId(context, component, metaComponentId)) == null) continue;
            return resolvedId;
        }
        return metaComponentSubstitutions.get(metaComponentId);
    }

    static void setMetaComponentSubstitutions(Map<String, String> substitutionsMap) {
        metaComponentSubstitutions = substitutionsMap;
    }

    private String computeClientId(FacesContext context, UIComponent topMatchComponent, String id) {
        UIComponent container = ComponentIdResolver.findContainer(topMatchComponent.getParent());
        String containerClientId = null;
        if (container instanceof NamingContainer) {
            containerClientId = container.getContainerClientId(context);
        }
        if (containerClientId != null && containerClientId.length() != 0) {
            StringBuilder builder = new StringBuilder(containerClientId.length() + 1 + id.length());
            builder.append(containerClientId);
            builder.append(this.namingContainerSeparator);
            builder.append(id);
            return builder.toString();
        }
        return id;
    }

    protected void addIdImmediately(String id) {
        this.idParser.setId(id);
        ComponentIdResolverNode node = this.rootNode;
        while (this.idParser.findNext()) {
            String componentId = this.idParser.getComponentId();
            if (componentId.length() == 0 || "*".equals(componentId) || componentId.length() > 2 && componentId.charAt(0) == '[' && componentId.charAt(componentId.length() - 1) == ']') continue;
            node = node.getOrCreateChild(componentId);
        }
        this.unresolvedIds.add(id);
        node.addFullId(id);
    }

    public void addId(String id) {
        if (this.isAbsolute(id)) {
            if (this.absoluteIds == null) {
                this.absoluteIds = new HashSet<String>();
            }
            this.absoluteIds.add(id.substring(1));
        } else {
            this.addIdImmediately(id);
        }
    }

    public Set<String> getResolvedIds() {
        return this.resolvedIds;
    }

    private ComponentIdResolverNode buildInversedTreeForNode(ComponentIdResolverNode directNode) {
        ComponentIdResolverNode localNode = directNode;
        ComponentIdResolverNode localInversedNode = this.rootNode;
        while (localNode != null) {
            ComponentIdResolverNode parent = localNode.getParent();
            if (parent != null) {
                localInversedNode = localInversedNode.getOrCreateChild(localNode.getId());
            }
            localNode = parent;
        }
        return localInversedNode;
    }

    private boolean isAbsolute(String id) {
        return id.charAt(0) == this.namingContainerSeparator;
    }

    private void buildInversedFilteredTreeRecursively(ComponentIdResolverNode directNode) {
        Set<String> fullIds = directNode.getFullIds();
        if (ComponentIdResolver.isNotEmpty(fullIds)) {
            ComponentIdResolverNode inversedNode = null;
            for (String fullId : fullIds) {
                if (this.isAbsolute(fullId)) continue;
                if (inversedNode == null) {
                    inversedNode = this.buildInversedTreeForNode(directNode);
                }
                inversedNode.addFullId(fullId);
            }
        }
        Collection<ComponentIdResolverNode> children = directNode.getChildren().values();
        for (ComponentIdResolverNode node : children) {
            this.buildInversedFilteredTreeRecursively(node);
        }
    }

    protected void clearAllUnresolvedIds() {
        this.rootNode.clearChildren();
        this.absoluteIds = null;
    }

    protected boolean hasUnresolvedIds() {
        return this.rootNode.hasChildren();
    }

    protected boolean findComponentsInContainerRecursively(UIComponent component, ComponentIdResolverNode node) {
        if (!this.hasUnresolvedIds()) {
            return true;
        }
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                if (!this.findComponentsInContainer(child, node, false)) continue;
                return true;
            }
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent child : component.getFacets().values()) {
                if (!this.findComponentsInContainer(child, node, false)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean resolveId(ComponentIdResolverNode node, UIComponent topMatch, UIComponent bottomMatch) {
        boolean shouldStop = false;
        Set<String> fullIds = node.getFullIds();
        if (ComponentIdResolver.isNotEmpty(fullIds)) {
            for (String fullId : fullIds) {
                this.unresolvedIds.remove(fullId);
                int idx = fullId.indexOf(64);
                String metaComponentId = idx >= 0 ? fullId.substring(idx + 1) : null;
                String resolvedId = null;
                if (metaComponentId != null && metaComponentId.length() != 0) {
                    resolvedId = ComponentIdResolver.resolveMetaComponentId(this.facesContext, bottomMatch, metaComponentId);
                }
                if (CoreRendererUtils.GLOBAL_META_COMPONENTS.contains(resolvedId)) {
                    this.resolvedIds.clear();
                    this.resolvedIds.add(resolvedId);
                    shouldStop = true;
                    break;
                }
                if (resolvedId != null) {
                    String predefinedMetaComponentId = CoreRendererUtils.INSTANCE.getPredefinedMetaComponentId(this.facesContext, bottomMatch, resolvedId);
                    if (predefinedMetaComponentId != null) {
                        resolvedId = predefinedMetaComponentId;
                    }
                    this.resolvedIds.add(resolvedId);
                    continue;
                }
                String computedId = this.computeClientId(this.facesContext, topMatch, fullId);
                this.resolvedIds.add(computedId);
            }
            node.resetFullIds();
        }
        if (shouldStop) {
            this.clearAllUnresolvedIds();
        }
        return shouldStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean findComponentsInContainer(UIComponent component, ComponentIdResolverNode node, boolean resolveNCChildren) {
        ComponentIdResolverNode matchedChild = node.getChild(component.getId());
        if (matchedChild != null) {
            try {
                if (this.rootNode.equals(node)) {
                    this.containerTopMatchComponent = component;
                }
                if (this.resolveId(matchedChild, this.containerTopMatchComponent, component)) {
                    boolean bl = true;
                    return bl;
                }
                if (matchedChild.hasChildren()) {
                    if (component instanceof NamingContainer && this.findComponentsInContainerRecursively(component, matchedChild)) {
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    matchedChild.remove();
                    if (!this.hasUnresolvedIds()) {
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            finally {
                if (this.rootNode.equals(node)) {
                    this.containerTopMatchComponent = null;
                }
            }
        }
        if (!(component instanceof NamingContainer) || resolveNCChildren) {
            return this.findComponentsInContainerRecursively(component, node);
        }
        return false;
    }

    protected void matchStackedComponents() {
        UIComponent bottomMatchComponent = this.componentsStack.getFirst();
        if (this.rootNode.getChild(bottomMatchComponent.getId()) != null) {
            Iterator iterator = this.componentsStack.iterator();
            ComponentIdResolverNode node = this.rootNode;
            while (iterator.hasNext() && node != null) {
                UIComponent component = (UIComponent)iterator.next();
                if ((node = node.getChild(component.getId())) == null) continue;
                if (this.resolveId(node, component, bottomMatchComponent)) break;
                if (node.hasChildren()) continue;
                node.remove();
            }
        }
    }

    protected boolean findComponentsBelowRecursively(UIComponent component) {
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                if (!this.findComponentsBelow(child)) continue;
                return true;
            }
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                if (!this.findComponentsBelow(facet)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean findComponentsBelow(UIComponent component) {
        boolean result;
        if (this.componentsStack == null) {
            this.componentsStack = new LinkedList();
        }
        this.componentsStack.addFirst(component);
        this.matchStackedComponents();
        boolean componentRemoved = false;
        if (this.hasUnresolvedIds()) {
            if (!(component instanceof NamingContainer)) {
                componentRemoved = true;
                this.componentsStack.removeFirst();
            }
            result = this.findComponentsBelowRecursively(component);
        } else {
            result = true;
        }
        if (!componentRemoved) {
            this.componentsStack.removeFirst();
        }
        return result;
    }

    public void resolve(UIComponent component) {
        assert (component != null);
        UIComponent c = component;
        this.resolveId(this.rootNode, c, c);
        if (this.hasUnresolvedIds()) {
            boolean resolutionResult;
            UIComponent container = ComponentIdResolver.findContainer(c);
            while (container != null && !ComponentIdResolver.isRoot(container) && !(resolutionResult = this.findComponentsInContainer(container, this.rootNode, true))) {
                container = ComponentIdResolver.findContainer(container.getParent());
            }
        }
        UIComponent root = ComponentIdResolver.findRoot(c);
        if (ComponentIdResolver.isNotEmpty(this.absoluteIds)) {
            for (String absoluteId : this.absoluteIds) {
                this.addIdImmediately(absoluteId);
            }
            this.absoluteIds.clear();
        }
        if (this.hasUnresolvedIds()) {
            this.findComponentsInContainer(root, this.rootNode, true);
        }
        if (this.hasUnresolvedIds()) {
            ComponentIdResolverNode directTreeRootNode = this.rootNode;
            this.rootNode = new ComponentIdResolverNode(null, null);
            this.buildInversedFilteredTreeRecursively(directTreeRootNode);
            this.findComponentsBelow(root);
        }
        this.resolvedIds.addAll(this.unresolvedIds);
    }

    static {
        metaComponentSubstitutions.put("region", "@this");
    }
}

