/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ComponentIdResolverNode {
    private Set<String> fullIds;
    private String id;
    private ComponentIdResolverNode parent;
    private Map<String, ComponentIdResolverNode> children = new HashMap<String, ComponentIdResolverNode>(2);

    public ComponentIdResolverNode(ComponentIdResolverNode parent, String id) {
        this.parent = parent;
        this.id = id;
    }

    public ComponentIdResolverNode getChild(String name) {
        return this.children.get(name);
    }

    public ComponentIdResolverNode getOrCreateChild(String name) {
        ComponentIdResolverNode child = this.children.get(name);
        if (child == null) {
            child = new ComponentIdResolverNode(this, name);
            this.children.put(name, child);
        }
        return child;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Map<String, ComponentIdResolverNode> getChildren() {
        return this.children;
    }

    protected void removeNode(String id) {
        this.children.remove(id);
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.removeNode(this.id);
            if (!this.parent.hasChildren()) {
                this.parent.remove();
            }
        }
    }

    public Set<String> getFullIds() {
        return this.fullIds;
    }

    public void addFullId(String fullId) {
        if (this.fullIds == null) {
            this.fullIds = new HashSet<String>();
        }
        this.fullIds.add(fullId);
    }

    public void resetFullIds() {
        this.fullIds = null;
    }

    public String getId() {
        return this.id;
    }

    public ComponentIdResolverNode getParent() {
        return this.parent;
    }

    public void clearChildren() {
        this.children.clear();
    }
}

