/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.AjaxOutput;
import org.richfaces.context.ComponentMatcherNode;
import org.richfaces.context.ExtendedVisitContext;
import org.richfaces.context.ExtendedVisitContextMode;
import org.richfaces.context.IdParser;
import org.richfaces.context.IdTreeNode;
import org.richfaces.context.NamingContainerVisitContext;
import org.richfaces.context.PartialViewContextAjaxOutputTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedPartialVisitContext
extends ExtendedVisitContext {
    static final String ANY_WILDCARD = "*";
    private static final int SHORT_ID_IN_CLIENTID_SEGMENTS_NUMBER = 2;
    private NodeOperationCommand addNodeOperation = new NodeOperationCommand(){

        public boolean processLastNode(ComponentMatcherNode lastNode, String fullId) {
            if (!ExtendedPartialVisitContext.this.directNodesMap.containsKey(fullId)) {
                ExtendedPartialVisitContext.this.directNodesMap.put(fullId, lastNode);
                lastNode.markAdded();
                int addedSegmentsCount = 0;
                for (ComponentMatcherNode n = lastNode; n != null && addedSegmentsCount < 2; n = n.getParentNode()) {
                    String shortId;
                    if (n.isPatternNode() || (shortId = n.getSource()) == null) continue;
                    ++addedSegmentsCount;
                    ExtendedPartialVisitContext.this.shortIds.add(shortId);
                }
                if (!lastNode.hasPatternNodeInChain()) {
                    lastNode.addSubtreeId(fullId);
                }
                return true;
            }
            return false;
        }

        public ComponentMatcherNode getNextNode(ComponentMatcherNode currentNode, String nodeId, boolean isPattern) {
            return currentNode.getOrCreateChild(nodeId, isPattern);
        }
    };
    private NodeOperationCommand removeNodeOperation = new NodeOperationCommand(){

        public boolean processLastNode(ComponentMatcherNode lastNode, String fullId) {
            ComponentMatcherNode node = (ComponentMatcherNode)ExtendedPartialVisitContext.this.directNodesMap.remove(fullId);
            if (node != null) {
                if (!node.hasPatternNodeInChain()) {
                    node.removeSubtreeId(fullId);
                }
                ExtendedPartialVisitContext.this.removeNode(node);
                return true;
            }
            return false;
        }

        public ComponentMatcherNode getNextNode(ComponentMatcherNode currentNode, String nodeId, boolean isPattern) {
            return currentNode.getChild(nodeId, isPattern);
        }
    };
    private IdParser idParser;
    private boolean limitRender;
    private Collection<String> clientIds;
    private Collection<String> shortIds;
    private Set<VisitHint> hints;
    private ComponentMatcherNode rootNode;
    private Map<String, ComponentMatcherNode> directNodesMap;

    public ExtendedPartialVisitContext(FacesContext facesContext, Collection<String> clientIds, boolean limitRender) {
        this(facesContext, clientIds, null, limitRender);
    }

    public ExtendedPartialVisitContext(FacesContext facesContext, Collection<String> clientIds, Set<VisitHint> hints, boolean limitRender) {
        super(facesContext, ExtendedVisitContextMode.RENDER);
        this.initializeCollections(clientIds);
        EnumSet<VisitHint> hintsEnumSet = hints == null || hints.isEmpty() ? EnumSet.noneOf(VisitHint.class) : EnumSet.copyOf(hints);
        this.hints = Collections.unmodifiableSet(hintsEnumSet);
        this.limitRender = limitRender;
    }

    private IdParser setupIdParser(String id) {
        if (this.idParser == null) {
            this.idParser = new IdParser(UINamingContainer.getSeparatorChar((FacesContext)this.getFacesContext()), '@');
        }
        this.idParser.setId(id);
        return this.idParser;
    }

    private ComponentMatcherNode findMatchingNode(String clientId) {
        ComponentMatcherNode node = this.rootNode;
        IdParser idParser = this.setupIdParser(clientId);
        while (node != null && idParser.findNext()) {
            String componentId = idParser.getComponentId();
            String metadataComponentId = idParser.getMetadataComponentId();
            if (metadataComponentId != null) {
                if ((node = node.getChild(componentId, false)) == null) continue;
                node = node.getChild(metadataComponentId, false);
                continue;
            }
            node = node.getMatchedChild(componentId);
        }
        return node;
    }

    private ComponentMatcherNode findAddedNode(String clientId) {
        ComponentMatcherNode node = this.findMatchingNode(clientId);
        if (node != null && !node.isAdded()) {
            node = null;
        }
        return node;
    }

    private void removeNode(ComponentMatcherNode nodeToRemove) {
        ComponentMatcherNode parentNode;
        nodeToRemove.markRemoved();
        ComponentMatcherNode node = nodeToRemove;
        while (node != null && !node.hasDirectChildren() && (parentNode = node.getParentNode()) != null) {
            parentNode.removeChild(node);
            node = parentNode;
        }
    }

    private boolean invokeNodeOperation(NodeOperationCommand command, ComponentMatcherNode currentNode, IdTreeNode idTreeNode, StringBuilder sb) {
        ComponentMatcherNode nextNode;
        String componentId = idTreeNode.getComponentId();
        String metadataComponentId = idTreeNode.getMetadataComponentId();
        if (metadataComponentId != null) {
            nextNode = command.getNextNode(currentNode, componentId, false);
            if (nextNode != null) {
                nextNode = command.getNextNode(nextNode, metadataComponentId, false);
            }
        } else {
            boolean isPattern = ANY_WILDCARD.equals(componentId);
            nextNode = command.getNextNode(currentNode, componentId, isPattern);
        }
        boolean result = false;
        if (nextNode != null) {
            List<IdTreeNode> idTreeChildNodes;
            int bufferLength = sb.length();
            if (bufferLength != 0) {
                sb.append(':');
            }
            sb.append(componentId);
            if (metadataComponentId != null) {
                sb.append(metadataComponentId);
            }
            if ((idTreeChildNodes = idTreeNode.getChildNodes()) != null) {
                int newBufferLength = sb.length();
                for (IdTreeNode idTreeChildNode : idTreeChildNodes) {
                    result |= this.invokeNodeOperation(command, nextNode, idTreeChildNode, sb);
                    sb.setLength(newBufferLength);
                }
            } else {
                result |= command.processLastNode(nextNode, sb.toString());
            }
            sb.setLength(bufferLength);
        }
        return result;
    }

    private boolean invokeRootNodeOperation(NodeOperationCommand command, IdTreeNode idTreeNode) {
        boolean result = false;
        List<IdTreeNode> idTreeChildNodes = idTreeNode.getChildNodes();
        if (idTreeChildNodes != null) {
            StringBuilder sb = new StringBuilder();
            for (IdTreeNode idTreeChildNode : idTreeChildNodes) {
                result |= this.invokeNodeOperation(command, this.rootNode, idTreeChildNode, sb);
            }
        }
        return result;
    }

    private boolean addNode(String patternId) {
        IdTreeNode idTreeNode = new IdTreeNode();
        idTreeNode.appendNodesFromParser(this.setupIdParser(patternId));
        return this.invokeRootNodeOperation(this.addNodeOperation, idTreeNode);
    }

    private boolean removeNode(String patternId) {
        IdTreeNode idTreeNode = new IdTreeNode();
        idTreeNode.appendNodesFromParser(this.setupIdParser(patternId));
        return this.invokeRootNodeOperation(this.removeNodeOperation, idTreeNode);
    }

    public Set<VisitHint> getHints() {
        return this.hints;
    }

    public Collection<String> getIdsToVisit() {
        return this.clientIds;
    }

    public Collection<String> getSubtreeIdsToVisit(UIComponent component) {
        Collection<String> subtreeIds;
        if (!(component instanceof NamingContainer)) {
            throw new IllegalArgumentException("Component is not a NamingContainer: " + component);
        }
        if (!this.limitRender && PartialViewContextAjaxOutputTracker.hasNestedAjaxOutputs(component)) {
            return VisitContext.ALL_IDS;
        }
        String clientId = this.buildExtendedClientId(component);
        ComponentMatcherNode node = this.findMatchingNode(clientId);
        Collection<Object> result = null;
        result = node != null ? (node.hasKidPatternNodes() ? VisitContext.ALL_IDS : ((subtreeIds = node.getSubtreeIds()) != null ? Collections.unmodifiableCollection(subtreeIds) : (node.hasDirectIdChildren() ? VisitContext.ALL_IDS : Collections.emptySet()))) : Collections.emptySet();
        return result;
    }

    public Collection<String> getDirectSubtreeIdsToVisit(UIComponent component) {
        Collection<String> directChildrenIds;
        if (!(component instanceof NamingContainer)) {
            throw new IllegalArgumentException("Component is not a NamingContainer: " + component);
        }
        String clientId = component.getClientId(this.getFacesContext());
        ComponentMatcherNode node = this.findMatchingNode(clientId);
        if (node != null && node.hasDirectPatternChildren()) {
            return VisitContext.ALL_IDS;
        }
        HashSet<String> result = null;
        if (node != null && node.hasDirectIdChildren()) {
            result = new HashSet<String>();
            result.addAll(node.getIdChildren().keySet());
        }
        if (!this.limitRender && (directChildrenIds = PartialViewContextAjaxOutputTracker.getDirectChildrenIds(component)) != null && !directChildrenIds.isEmpty()) {
            if (result == null) {
                result = new HashSet();
            }
            result.addAll(directChildrenIds);
        }
        if (result != null && !result.isEmpty()) {
            return Collections.unmodifiableCollection(result);
        }
        return Collections.emptySet();
    }

    public VisitResult invokeVisitCallback(UIComponent component, VisitCallback callback) {
        AjaxOutput ajaxOutput;
        String clientId;
        ComponentMatcherNode node;
        if (this.shortIds.contains(component.getId()) && (node = this.findAddedNode(clientId = this.buildExtendedClientId(component))) != null) {
            VisitResult visitResult = callback.visit((VisitContext)this, component);
            this.removeNode(clientId);
            if (this.clientIds.isEmpty() && this.limitRender) {
                return VisitResult.COMPLETE;
            }
            return visitResult;
        }
        if (!this.limitRender && component instanceof AjaxOutput && (ajaxOutput = (AjaxOutput)component).isAjaxRendered()) {
            return callback.visit((VisitContext)this, component);
        }
        return VisitResult.ACCEPT;
    }

    private void initializeCollections(Collection<String> clientIds) {
        this.rootNode = new ComponentMatcherNode();
        this.directNodesMap = new HashMap<String, ComponentMatcherNode>();
        this.shortIds = new HashSet<String>();
        this.clientIds = new CollectionProxy();
        this.clientIds.addAll(clientIds);
    }

    public VisitContext createNamingContainerVisitContext(UIComponent component, Collection<String> directIds) {
        return new NamingContainerVisitContext(this.getFacesContext(), this.getVisitMode(), component, directIds);
    }

    private static interface NodeOperationCommand {
        public ComponentMatcherNode getNextNode(ComponentMatcherNode var1, String var2, boolean var3);

        public boolean processLastNode(ComponentMatcherNode var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IteratorProxy
    implements Iterator<String> {
        private Iterator<String> wrapped;
        private String current = null;

        private IteratorProxy(Iterator<String> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public String next() {
            this.current = this.wrapped.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current != null) {
                ComponentMatcherNode node = (ComponentMatcherNode)ExtendedPartialVisitContext.this.directNodesMap.get(this.current);
                ExtendedPartialVisitContext.this.removeNode(node);
                this.current = null;
            }
            this.wrapped.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CollectionProxy
    extends AbstractCollection<String> {
        private CollectionProxy() {
        }

        @Override
        public boolean isEmpty() {
            return ExtendedPartialVisitContext.this.directNodesMap.isEmpty();
        }

        @Override
        public int size() {
            return ExtendedPartialVisitContext.this.directNodesMap.size();
        }

        @Override
        public Iterator<String> iterator() {
            return new IteratorProxy(ExtendedPartialVisitContext.this.directNodesMap.keySet().iterator());
        }

        @Override
        public boolean add(String o) {
            return ExtendedPartialVisitContext.this.addNode(o);
        }
    }
}

