/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.richfaces.context.IdParser;
import org.richfaces.renderkit.util.CoreAjaxRendererUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IdTreeNode {
    private static final char LIST_OPENING_CHAR = '[';
    private static final char LIST_CLOSING_CHAR = ']';
    private String componentId;
    private String metadataComponentId;
    private List<IdTreeNode> childNodes;

    private IdTreeNode(String componentId, String metadataComponentId) {
        this.componentId = componentId;
        this.metadataComponentId = metadataComponentId;
    }

    public IdTreeNode() {
        this(null, null);
    }

    private void setChildNodes(String[] componentIds) {
        this.childNodes = new ArrayList<IdTreeNode>(componentIds.length);
        for (String componentId : componentIds) {
            this.childNodes.add(new IdTreeNode(componentId, null));
        }
    }

    private void setChildNode(String componentId, String metadataComponentId) {
        this.childNodes = Collections.singletonList(new IdTreeNode(componentId, metadataComponentId));
    }

    private void appendToStringBuilder(StringBuilder sb, int indentLevel) {
        for (int i = 0; i < indentLevel; ++i) {
            sb.append(' ');
        }
        sb.append('+');
        if (this.componentId != null) {
            sb.append(this.componentId);
            if (this.metadataComponentId != null) {
                sb.append('(');
                sb.append(this.metadataComponentId);
                sb.append(')');
            }
        } else {
            sb.append("<empty>");
        }
        sb.append('\n');
        if (this.childNodes != null) {
            for (IdTreeNode childNode : this.childNodes) {
                childNode.appendToStringBuilder(sb, indentLevel + 2);
            }
        }
    }

    public void appendNodesFromParser(IdParser idParser) {
        List<IdTreeNode> nodes = Collections.singletonList(this);
        while (idParser.findNext()) {
            List<Object> newNodesList;
            String componentId = idParser.getComponentId();
            String metadataComponentId = idParser.getMetadataComponentId();
            int childNodesCount = 0;
            if (metadataComponentId != null) {
                for (IdTreeNode node : nodes) {
                    node.setChildNode(componentId, metadataComponentId);
                    ++childNodesCount;
                }
            } else if (componentId.length() > 2 && componentId.charAt(0) == '[' && componentId.charAt(componentId.length() - 1) == ']') {
                String[] split = CoreAjaxRendererUtils.asIdsArray((String)componentId.substring(1, componentId.length() - 1));
                for (IdTreeNode node : nodes) {
                    node.setChildNodes(split);
                    childNodesCount += split.length;
                }
            } else {
                for (IdTreeNode node : nodes) {
                    node.setChildNode(componentId, null);
                    ++childNodesCount;
                }
            }
            if (nodes.size() == 1) {
                newNodesList = nodes.get(0).getChildNodes();
            } else {
                newNodesList = new ArrayList(childNodesCount);
                for (IdTreeNode node : nodes) {
                    newNodesList.addAll(node.getChildNodes());
                }
            }
            nodes = newNodesList;
        }
    }

    public List<IdTreeNode> getChildNodes() {
        return this.childNodes;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getMetadataComponentId() {
        return this.metadataComponentId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendToStringBuilder(sb, 0);
        return sb.toString();
    }
}

