/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.AjaxClientBehavior;
import org.richfaces.context.ComponentCallback;
import org.richfaces.renderkit.util.CoreAjaxRendererUtils;

class RenderComponentCallback
extends ComponentCallback {
    private boolean limitRender = false;
    private String oncomplete;
    private String onbeforedomupdate;
    private Object data;

    RenderComponentCallback(String behaviorEvent) {
        super(behaviorEvent, null);
    }

    public boolean isLimitRender() {
        return this.limitRender;
    }

    public String getOnbeforedomupdate() {
        return this.onbeforedomupdate;
    }

    public String getOncomplete() {
        return this.oncomplete;
    }

    public Object getData() {
        return this.data;
    }

    protected void doVisit(FacesContext context, UIComponent target, AjaxClientBehavior behavior) {
        super.doVisit(context, target, behavior);
        this.limitRender = CoreAjaxRendererUtils.isAjaxLimitRender((UIComponent)target);
        this.onbeforedomupdate = CoreAjaxRendererUtils.getAjaxOnBeforeDomUpdate((UIComponent)target);
        this.oncomplete = CoreAjaxRendererUtils.getAjaxOncomplete((UIComponent)target);
        this.data = CoreAjaxRendererUtils.getAjaxData((UIComponent)target);
        if (behavior != null) {
            this.limitRender = behavior.isLimitRender();
            this.onbeforedomupdate = behavior.getOnbeforedomupdate();
            this.oncomplete = behavior.getOncomplete();
            this.data = behavior.getData();
        }
    }

    public Object getAttributeValue(UIComponent component) {
        return component.getAttributes().get("render");
    }

    protected Object getBehaviorAttributeValue(AjaxClientBehavior behavior) {
        return behavior.getRender();
    }
}

