/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.richfaces.application.ServiceTracker;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.ResourceLibrary;
import org.richfaces.resource.ResourceLibraryFactory;

public class ResourceLibraryRenderer
extends Renderer {
    public static final String RENDERER_TYPE = "org.richfaces.renderkit.ResourceLibraryRenderer";
    public static final String RESOURCE_LIBRARY_EXTENSION = ".reslib";
    private static final Logger LOGGER = RichfacesLogger.RENDERKIT.getLogger();
    private static final Joiner COLON_JOINER = Joiner.on((char)':').skipNulls();

    private void setupResourceAttributes(UIComponent component, ResourceKey resourceKey) {
        Map attributes = component.getAttributes();
        attributes.put("name", resourceKey.getResourceName());
        String libraryName = resourceKey.getLibraryName();
        if (libraryName != null) {
            attributes.put("library", libraryName);
        } else {
            attributes.remove("library");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Map attributes = component.getAttributes();
        String name = (String)attributes.get("name");
        if (!name.endsWith(RESOURCE_LIBRARY_EXTENSION)) {
            throw new IllegalArgumentException("Resource library name: " + name + " is incorrect");
        }
        name = name.substring(0, name.length() - RESOURCE_LIBRARY_EXTENSION.length());
        String library = (String)attributes.get("library");
        ResourceLibraryFactory factory = (ResourceLibraryFactory)ServiceTracker.getService(ResourceLibraryFactory.class);
        ResourceLibrary resourceLibrary = factory.getResourceLibrary(name, library);
        if (resourceLibrary == null) {
            LOGGER.error((CharSequence)("Resource library is null: " + COLON_JOINER.join((Object)library, (Object)name, new Object[0])));
            return;
        }
        Application application = context.getApplication();
        UIComponent resourceComponent = null;
        for (ResourceKey resourceKey : resourceLibrary.getResources(context)) {
            String rendererType = application.getResourceHandler().getRendererTypeForResourceName(resourceKey.getResourceName());
            if (resourceComponent == null) {
                resourceComponent = application.createComponent("javax.faces.Output");
                resourceComponent.setTransient(true);
                component.getChildren().add(resourceComponent);
            }
            resourceComponent.setRendererType(rendererType);
            this.setupResourceAttributes(resourceComponent, resourceKey);
            resourceComponent.encodeAll(context);
        }
    }
}

