/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.richfaces.application.DependencyInjector;
import org.richfaces.application.ServiceTracker;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.BaseResourceWrapper;
import org.richfaces.resource.CompiledCSSResource;
import org.richfaces.resource.DynamicResource;
import org.richfaces.resource.ExternalStaticResource;
import org.richfaces.resource.Java2DAnimatedUserResource;
import org.richfaces.resource.Java2DAnimatedUserResourceWrapperImpl;
import org.richfaces.resource.Java2DUserResource;
import org.richfaces.resource.Java2DUserResourceWrapperImpl;
import org.richfaces.resource.ResourceFactory;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.ResourceRequestData;
import org.richfaces.resource.UserResource;
import org.richfaces.resource.UserResourceWrapperImpl;
import org.richfaces.resource.VersionedResource;
import org.richfaces.util.PropertiesUtil;
import org.richfaces.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFactoryImpl
implements ResourceFactory {
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    private static final Function<Map.Entry<String, String>, ExternalStaticResourceFactory> EXTERNAL_MAPPINGS_FACTORY_PRODUCER = new Function<Map.Entry<String, String>, ExternalStaticResourceFactory>(){

        public ExternalStaticResourceFactory apply(Map.Entry<String, String> entry) {
            String resourceQualifier = entry.getKey();
            String resourceLocation = entry.getValue();
            boolean skinDependent = false;
            if (resourceLocation.startsWith("%skin%/")) {
                resourceLocation = resourceLocation.substring("%skin%/".length());
                skinDependent = true;
            }
            return new ExternalStaticResourceFactory(new ResourceKey(resourceQualifier), resourceLocation, skinDependent);
        }
    };
    private static final Function<Map.Entry<String, String>, MappedResourceData> DYNAMIC_MAPPINGS_DATA_PRODUCER = new Function<Map.Entry<String, String>, MappedResourceData>(){

        public MappedResourceData apply(Map.Entry<String, String> from) {
            String resourceLocation = from.getValue();
            Map<String, String> params = Util.parseResourceParameters(resourceLocation);
            String resourceQualifier = ResourceFactoryImpl.extractParametersFromResourceName(resourceLocation);
            return new MappedResourceData(new ResourceKey(resourceQualifier), params);
        }
    };
    private ResourceHandler defaultHandler;
    private Map<ResourceKey, ExternalStaticResourceFactory> externalStaticResourceFactories;
    private Map<ResourceKey, MappedResourceData> mappedResourceDataMap;

    public ResourceFactoryImpl(ResourceHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
        this.externalStaticResourceFactories = this.readMappings(EXTERNAL_MAPPINGS_FACTORY_PRODUCER, "META-INF/richfaces/static-resource-mappings.properties");
        this.mappedResourceDataMap = this.readMappings(DYNAMIC_MAPPINGS_DATA_PRODUCER, "META-INF/richfaces/resource-mappings.properties");
    }

    private static String extractParametersFromResourceName(String resourceName) {
        if (resourceName.lastIndexOf("{") == -1) {
            return resourceName;
        }
        return resourceName.substring(0, resourceName.lastIndexOf("{"));
    }

    private void logResourceProblem(FacesContext context, Throwable throwable, String messagePattern, Object ... arguments) {
        boolean isProductionStage = context.isProjectStage(ProjectStage.Production);
        if (LOGGER.isWarnEnabled() || !isProductionStage && LOGGER.isInfoEnabled()) {
            String formattedMessage = MessageFormat.format(messagePattern, arguments);
            if (throwable != null) {
                LOGGER.warn((CharSequence)formattedMessage, throwable);
            } else if (isProductionStage) {
                LOGGER.info((CharSequence)formattedMessage);
            } else {
                LOGGER.warn((CharSequence)formattedMessage);
            }
        }
    }

    private void logMissingResource(FacesContext context, String resourceData) {
        this.logResourceProblem(context, null, "Resource {0} was not found", resourceData);
    }

    private <V> Map<ResourceKey, V> readMappings(Function<Map.Entry<String, String>, V> producer, String mappingFileName) {
        Map<ResourceKey, Object> result = Maps.newHashMap();
        for (Map.Entry<String, String> entry : PropertiesUtil.loadProperties(mappingFileName).entrySet()) {
            result.put(new ResourceKey(entry.getKey()), producer.apply(entry));
        }
        result = Collections.unmodifiableMap(result);
        return result;
    }

    private Resource createCompiledCSSResource(ResourceKey resourceKey) {
        Resource sourceResource = this.defaultHandler.createResource(resourceKey.getResourceName(), resourceKey.getLibraryName(), "text/plain");
        if (sourceResource != null) {
            return new CompiledCSSResource(sourceResource);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void injectProperties(Object resource, Map<String, String> parameters) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map attributes = facesContext.getAttributes();
        try {
            attributes.put("rfResourceParam", parameters);
            ((DependencyInjector)ServiceTracker.getService(DependencyInjector.class)).inject(facesContext, resource);
        }
        finally {
            attributes.remove("rfResourceParam");
        }
    }

    protected Resource createHandlerDependentResource(ResourceKey resourceKey, Map<String, String> parameters) {
        if (!Strings.isNullOrEmpty((String)resourceKey.getLibraryName())) {
            return null;
        }
        String resourceName = resourceKey.getResourceName();
        BaseResourceWrapper resource = null;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                Class<?> loadedClass = Class.forName(resourceName, false, contextClassLoader);
                boolean legitimateResource = false;
                DynamicResource annotation = loadedClass.getAnnotation(DynamicResource.class);
                boolean bl = legitimateResource = annotation != null;
                if (legitimateResource) {
                    LOGGER.debug((CharSequence)MessageFormat.format("Dynamic resource annotation is present on resource class {0}", resourceName));
                } else {
                    LOGGER.debug((CharSequence)MessageFormat.format("Dynamic resource annotation is not present on resource class {0}", resourceName));
                }
                if (!legitimateResource) {
                    URL resourceMarkerUrl = contextClassLoader.getResource("META-INF/" + resourceName + ".resource.properties");
                    boolean bl2 = legitimateResource = resourceMarkerUrl != null;
                    if (LOGGER.isDebugEnabled()) {
                        if (legitimateResource) {
                            LOGGER.debug((CharSequence)MessageFormat.format("Marker file for {0} resource found in classpath", resourceName));
                        } else {
                            LOGGER.debug((CharSequence)MessageFormat.format("Marker file for {0} resource does not exist", resourceName));
                        }
                    }
                }
                if (legitimateResource) {
                    Object wrappedResource;
                    if (Java2DAnimatedUserResource.class.isAssignableFrom(loadedClass)) {
                        Java2DAnimatedUserResource java2DAnimatedUserResource;
                        wrappedResource = java2DAnimatedUserResource = (Java2DAnimatedUserResource)loadedClass.newInstance();
                        resource = new Java2DAnimatedUserResourceWrapperImpl(java2DAnimatedUserResource);
                    } else if (Java2DUserResource.class.isAssignableFrom(loadedClass)) {
                        Java2DUserResource java2DUserResource = (Java2DUserResource)loadedClass.newInstance();
                        wrappedResource = java2DUserResource;
                        resource = new Java2DUserResourceWrapperImpl(java2DUserResource);
                    } else if (UserResource.class.isAssignableFrom(loadedClass)) {
                        UserResource userResource = (UserResource)loadedClass.newInstance();
                        wrappedResource = userResource;
                        resource = new UserResourceWrapperImpl(userResource);
                    } else {
                        Class<Resource> resourceClass = loadedClass.asSubclass(Resource.class);
                        resource = resourceClass.newInstance();
                        wrappedResource = resource;
                    }
                    if (parameters != null) {
                        this.injectProperties(wrappedResource, parameters);
                    }
                    resource.setResourceName(resourceName);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((CharSequence)MessageFormat.format("Successfully created instance of {0} resource", resourceName));
                    }
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                this.logResourceProblem(FacesContext.getCurrentInstance(), e, "Error creating resource {0}", resourceName);
            }
            catch (LinkageError e) {
                this.logResourceProblem(FacesContext.getCurrentInstance(), e, "Error creating resource {0}", resourceName);
            }
        }
        return resource;
    }

    public Resource createResource(FacesContext context, ResourceRequestData resourceData) {
        String resourceName = resourceData.getResourceName();
        if (resourceName == null || resourceName.length() == 0) {
            return null;
        }
        String libraryName = resourceData.getLibraryName();
        Resource resource = this.createDynamicResource(new ResourceKey(resourceName, libraryName), false);
        if (resource == null) {
            this.logMissingResource(context, resourceData.getResourceKey());
            return null;
        }
        if (resource instanceof VersionedResource) {
            VersionedResource versionedResource = (VersionedResource)resource;
            String existingVersion = versionedResource.getVersion();
            String requestedVersion = resourceData.getVersion();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((CharSequence)MessageFormat.format("Client requested {0} version of resource, server has {1} version", String.valueOf(requestedVersion), String.valueOf(existingVersion)));
            }
            if (existingVersion != null && requestedVersion != null && !existingVersion.equals(requestedVersion)) {
                this.logResourceProblem(context, null, "Resource {0} of version {1} was not found", resourceName, requestedVersion);
                return null;
            }
        }
        Object decodedData = resourceData.getData();
        if (LOGGER.isDebugEnabled()) {
            if (decodedData != null) {
                LOGGER.debug((CharSequence)"Resource state data succesfully decoded");
            } else {
                LOGGER.debug((CharSequence)"Resource state data decoded as null");
            }
        }
        Util.restoreResourceState(context, resource, decodedData);
        return resource;
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        ResourceKey resourceKey = new ResourceKey(resourceName, libraryName);
        ExternalStaticResourceFactory externalStaticResourceFactory = this.externalStaticResourceFactories.get(resourceKey);
        if (externalStaticResourceFactory != null) {
            return externalStaticResourceFactory.createResource();
        }
        return this.createDynamicResource(resourceKey, true);
    }

    protected Resource createDynamicResource(ResourceKey resourceKey, boolean useDependencyInjection) {
        ResourceKey actualKey;
        Resource result = null;
        Map<String, String> params = null;
        MappedResourceData mappedResourceData = this.mappedResourceDataMap.get(resourceKey);
        if (mappedResourceData != null) {
            actualKey = mappedResourceData.getResourceKey();
            if (useDependencyInjection) {
                params = mappedResourceData.getParams();
            }
        } else {
            actualKey = resourceKey;
            if (useDependencyInjection) {
                params = Collections.emptyMap();
            }
        }
        if (Strings.isNullOrEmpty((String)resourceKey.getResourceName())) {
            return null;
        }
        result = actualKey.getResourceName().endsWith(".ecss") ? this.createCompiledCSSResource(actualKey) : this.createHandlerDependentResource(actualKey, params);
        if (result != null) {
            result.setLibraryName(resourceKey.getLibraryName());
            result.setResourceName(resourceKey.getResourceName());
        }
        return result;
    }

    public Collection<ResourceKey> getMappedDynamicResourceKeys() {
        return Collections.unmodifiableSet(this.mappedResourceDataMap.keySet());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MappedResourceData {
        private ResourceKey resourceKey;
        private Map<String, String> params;

        public MappedResourceData(ResourceKey resourceKey, Map<String, String> params) {
            this.resourceKey = resourceKey;
            this.params = params;
        }

        public ResourceKey getResourceKey() {
            return this.resourceKey;
        }

        public Map<String, String> getParams() {
            return this.params;
        }
    }

    private static class ExternalStaticResourceFactory {
        private ResourceKey resourceKey;
        private String resourceLocation;
        private boolean skinDependent;

        public ExternalStaticResourceFactory(ResourceKey resourceKey, String resourceLocation, boolean skinDependent) {
            this.resourceKey = resourceKey;
            this.resourceLocation = resourceLocation;
            this.skinDependent = skinDependent;
        }

        public Resource createResource() {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalStaticResource resource = new ExternalStaticResource(this.resourceLocation, this.skinDependent);
            resource.setResourceName(this.resourceKey.getResourceName());
            resource.setLibraryName(this.resourceKey.getLibraryName());
            resource.setContentType(facesContext.getExternalContext().getMimeType(this.resourceLocation));
            return resource;
        }
    }
}

