/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.css;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.richfaces.el.util.ELUtils;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.css.AbstractCSSVisitor;
import org.w3c.dom.css.CSSCharsetRule;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSUnknownRule;
import org.w3c.dom.stylesheets.MediaList;

public final class CSSVisitorImpl
extends AbstractCSSVisitor {
    private static final String RESOURCE_START_PREFIX = "resource[";
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    private static final String NEW_LINE = "\r\n";
    private FacesContext facesContext;
    private String encoding;
    private StringBuilder buffer = new StringBuilder();
    private List<String> prefixes = new ArrayList<String>(2);

    public CSSVisitorImpl(FacesContext facesContext) {
        this.facesContext = facesContext;
    }

    private void appendCSSText(CSSRule rule) {
        String cssText = rule.getCssText().trim();
        if (cssText.length() != 0) {
            this.buffer.append(cssText);
            this.buffer.append(NEW_LINE);
        }
    }

    private void flushPrefixes() {
        if (!this.prefixes.isEmpty()) {
            for (String prefix : this.prefixes) {
                this.buffer.append(prefix);
                this.buffer.append(" {");
                this.buffer.append(NEW_LINE);
            }
            this.prefixes.clear();
        }
    }

    private void flushSuffix() {
        if (this.prefixes.isEmpty()) {
            this.buffer.append('}');
            this.buffer.append(NEW_LINE);
        } else {
            this.prefixes.remove(this.prefixes.size() - 1);
        }
    }

    public void visitUnknownRule(CSSUnknownRule rule) {
        this.appendCSSText(rule);
    }

    public void visitCharsetRule(CSSCharsetRule rule) {
        this.encoding = rule.getEncoding();
        this.appendCSSText(rule);
    }

    public void visitImportRule(CSSImportRule rule) {
        Resource imported;
        String resourceName = rule.getHref();
        if (ELUtils.isValueReference((String)resourceName)) {
            if (resourceName.indexOf(RESOURCE_START_PREFIX) == -1) {
                resourceName = (String)this.facesContext.getApplication().evaluateExpressionGet(this.facesContext, resourceName, String.class);
            } else {
                int start = resourceName.indexOf(RESOURCE_START_PREFIX) + RESOURCE_START_PREFIX.length();
                int end = resourceName.lastIndexOf("]");
                resourceName = resourceName.substring(start, end);
                resourceName = resourceName.replaceAll("\"", "").replaceAll("'", "").trim();
            }
        }
        if ((imported = this.facesContext.getApplication().getResourceHandler().createResource(resourceName)) == null) {
            LOGGER.error((CharSequence)("Resource with name " + resourceName + "can't be found."));
            return;
        }
        String toAdd = null;
        try {
            toAdd = this.convertStreamToString(imported.getInputStream(), this.getEncoding());
        }
        catch (IOException e) {
            LOGGER.error((CharSequence)("Error while importing nested resource with name " + resourceName));
        }
        if (toAdd != null && toAdd.length() > 0) {
            this.buffer.append(toAdd);
            this.buffer.append(NEW_LINE);
        } else {
            this.appendCSSText(rule);
        }
    }

    protected void startFontRule(CSSFontFaceRule rule) {
        this.prefixes.add("@font-face");
    }

    protected void endFontRule(CSSFontFaceRule rule) {
        this.flushSuffix();
    }

    protected void startMediaRule(CSSMediaRule rule) {
        MediaList mediaList = rule.getMedia();
        String mediaText = mediaList.getMediaText();
        this.prefixes.add("@media " + mediaText);
    }

    protected void endMediaRule(CSSMediaRule rule) {
        this.flushSuffix();
    }

    protected void startPageRule(CSSPageRule rule) {
        String selectorText = rule.getSelectorText();
        this.prefixes.add("@page " + selectorText);
    }

    protected void endPageRule(CSSPageRule rule) {
        this.flushSuffix();
    }

    protected void startStyleRule(CSSStyleRule rule) {
        String selectorText = rule.getSelectorText();
        this.prefixes.add(selectorText);
    }

    protected void endStyleRule(CSSStyleRule rule) {
        this.flushSuffix();
    }

    protected void startStyleSheet(CSSStyleSheet styleSheet) {
    }

    protected void endStyleSheet(CSSStyleSheet styleSheet) {
    }

    public void visitStyleDeclaration(CSSStyleDeclaration styleDeclaration) {
        for (int j = 0; j < styleDeclaration.getLength(); ++j) {
            String propertyName = styleDeclaration.item(j);
            String value = styleDeclaration.getPropertyValue(propertyName).trim();
            String priority = styleDeclaration.getPropertyPriority(propertyName);
            if (ELUtils.isValueReference((String)value)) {
                value = (String)this.facesContext.getApplication().evaluateExpressionGet(this.facesContext, value, String.class);
            }
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            if (value.startsWith("'") && value.endsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
            if (value.length() == 0 || value.equals("\"\"") || value.equals("''")) continue;
            this.flushPrefixes();
            this.buffer.append('\t');
            this.buffer.append(propertyName);
            this.buffer.append(": ");
            this.buffer.append(value);
            if (priority != null && priority.length() != 0) {
                this.buffer.append(" !");
                this.buffer.append(priority);
            }
            this.buffer.append(";");
            this.buffer.append(NEW_LINE);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getCSSText() {
        return this.buffer.toString();
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertStreamToString(InputStream is, String encoding) throws IOException {
        if (is != null) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, encoding));
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append(NEW_LINE);
                }
            }
            finally {
                is.close();
            }
            return sb.toString();
        }
        return "";
    }
}

