/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.el.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceMap<K, V>
implements Map<K, V> {
    private ReferenceQueue<V> queue = new ReferenceQueue();
    private Map<K, Reference<V>> map;

    public ReferenceMap() {
        this(Collections.synchronizedMap(new HashMap()));
    }

    public ReferenceMap(Map<K, Reference<V>> map) {
        this.map = map;
    }

    private void purge() {
        Reference<V> reference = null;
        while ((reference = this.queue.poll()) != null) {
            ReferenceMapSoftReference entry = (ReferenceMapSoftReference)reference;
            entry.clear();
            this.map.remove(entry.getKey());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        Reference<V> reference = null;
        while ((reference = this.queue.poll()) != null) {
            reference.clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.purge();
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(Object key) {
        this.purge();
        Reference<V> reference = this.map.get(key);
        if (reference != null) {
            return reference.get();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        this.purge();
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        this.purge();
        return this.map.keySet();
    }

    private V doPut(K key, V value) {
        Reference reference = this.map.put(key, new ReferenceMapSoftReference<K, V>(key, value, this.queue));
        if (reference != null) {
            return (V)reference.get();
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        this.purge();
        V v = this.doPut(key, value);
        this.purge();
        return v;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.purge();
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.doPut(entry.getKey(), entry.getValue());
        }
        this.purge();
    }

    @Override
    public V remove(Object key) {
        this.purge();
        Reference<V> reference = this.map.remove(key);
        if (reference != null) {
            return reference.get();
        }
        return null;
    }

    @Override
    public int size() {
        this.purge();
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ReferenceMapSoftReference<K, V>
    extends SoftReference<V> {
        private K key;

        public ReferenceMapSoftReference(K key, V value, ReferenceQueue<? super V> queue) {
            super(value, queue);
            this.key = key;
        }

        public K getKey() {
            return this.key;
        }
    }
}

