/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.log;

import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import org.richfaces.log.LogFactory;
import org.richfaces.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RichfacesLogger {
    RESOURCE("Resource"),
    RENDERKIT("Renderkit"),
    CONFIG("Config"),
    CONNECTION("Connection"),
    APPLICATION("Application"),
    CACHE("Cache"),
    CONTEXT("Context"),
    COMPONENTS("Components"),
    WEBAPP("Webapp"),
    UTIL("Util");

    private static final String LOGGER_NAME_PREFIX = "org.richfaces.log.";
    private String loggerName;

    private RichfacesLogger(String loggerName) {
        this.loggerName = LOGGER_NAME_PREFIX + loggerName;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public Logger getLogger() {
        return LogFactory.getLogger(this.loggerName);
    }

    public static String getComponentPath(UIComponent component) {
        StringBuilder builder = new StringBuilder("Component path: ");
        if (component == null) {
            builder.append("null");
        } else {
            RichfacesLogger.getComponentPath(component, builder);
        }
        return builder.toString();
    }

    private static void getComponentPath(UIComponent component, StringBuilder builder) {
        if (component != null) {
            RichfacesLogger.getComponentPath(component.getParent(), builder);
            builder.append("/").append(component.getClass().getName());
            if (component instanceof UIViewRoot) {
                builder.append("[viewId=");
                builder.append(((UIViewRoot)component).getViewId());
            } else {
                builder.append("[id=");
                builder.append(component.getId());
            }
            builder.append("]");
        }
    }
}

