/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.util;

import java.util.ArrayList;
import java.util.List;

final class IdSplitBuilder {
    private static final int INITIAL_SPLIT_LIST_SIZE = 3;
    private int startIdx = -1;
    private String sourceString;
    private List<String> result = new ArrayList<String>(3);
    private State state = State.OUTSIDE_ID;

    private IdSplitBuilder(String sourceString) {
        this.sourceString = sourceString;
    }

    private void setStartIndex(int idx) {
        this.startIdx = idx;
    }

    private void flushBuilder(int endIdx) {
        if (this.startIdx >= 0 && endIdx > this.startIdx) {
            String id = this.sourceString.substring(this.startIdx, endIdx);
            this.result.add(id);
        }
    }

    private void build() {
        int length = this.sourceString.length();
        for (int i = 0; i < length; ++i) {
            char c = this.sourceString.charAt(i);
            this.state.processChar(this, c, i);
        }
        this.flushBuilder(length);
    }

    private String[] getSplit() {
        return this.result.toArray(new String[this.result.size()]);
    }

    public static String[] split(String s) {
        IdSplitBuilder splitBuilder = new IdSplitBuilder(s);
        splitBuilder.build();
        return splitBuilder.getSplit();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        IN_ID(true){

            public State getNextState(char c) {
                if (c == '[') {
                    return IN_ID_INSIDE_BRACKETS;
                }
                if (State.isSeparator(c)) {
                    return OUTSIDE_ID;
                }
                return this;
            }
        }
        ,
        IN_ID_INSIDE_BRACKETS(true){

            public State getNextState(char c) {
                if (c == ']') {
                    return IN_ID;
                }
                return this;
            }
        }
        ,
        OUTSIDE_ID(false){

            public State getNextState(char c) {
                if (!State.isSeparator(c)) {
                    if (c == '[') {
                        return IN_ID_INSIDE_BRACKETS;
                    }
                    return IN_ID;
                }
                return this;
            }
        };

        private final boolean idSegment;

        private State(boolean idSegment) {
            this.idSegment = idSegment;
        }

        private static boolean isSeparator(char c) {
            return c == ',' || Character.isWhitespace(c);
        }

        public abstract State getNextState(char var1);

        public boolean isIdSegment() {
            return this.idSegment;
        }

        public void processChar(IdSplitBuilder builder, char c, int charIdx) {
            State nextState = this.getNextState(c);
            if (nextState.isIdSegment() ^ this.isIdSegment()) {
                if (nextState.isIdSegment()) {
                    builder.setStartIndex(charIdx);
                } else {
                    builder.flushBuilder(charIdx);
                    builder.setStartIndex(-1);
                }
            }
            builder.state = nextState;
        }
    }
}

