/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import javax.faces.application.ResourceDependency;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.FacesBehaviorRenderer;
import org.ajax4jsf.component.AjaxClientBehavior;
import org.ajax4jsf.component.behavior.AjaxBehavior;
import org.ajax4jsf.javascript.JSFunction;
import org.richfaces.renderkit.AjaxEventOptions;
import org.richfaces.renderkit.util.AjaxRendererUtils;
import org.richfaces.renderkit.util.RendererUtils;

@FacesBehaviorRenderer(rendererType="org.ajax4jsf.behavior.Ajax", renderKitId="HTML_BASIC")
@ResourceDependency(library="org.richfaces", name="ajax.reslib")
public class AjaxBehaviorRenderer
extends ClientBehaviorRenderer {
    private final RendererUtils utils = RendererUtils.getInstance();

    public void decode(FacesContext context, UIComponent component, ClientBehavior behavior) {
        if (null == context || null == component || null == behavior) {
            throw new NullPointerException();
        }
        if (!(behavior instanceof AjaxBehavior)) {
            throw new IllegalArgumentException("org.ajax4jsf.component.behavior.AjaxBehavior required: " + behavior);
        }
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (ajaxBehavior.isDisabled()) {
            return;
        }
        component.queueEvent((FacesEvent)this.createEvent(component, ajaxBehavior));
    }

    private AjaxBehaviorEvent createEvent(UIComponent component, AjaxBehavior ajaxBehavior) {
        AjaxBehaviorEvent event = new AjaxBehaviorEvent(component, (Behavior)ajaxBehavior);
        PhaseId phaseId = this.isImmediate(component, ajaxBehavior) ? PhaseId.APPLY_REQUEST_VALUES : (this.isBypassUpdates(component, ajaxBehavior) ? PhaseId.PROCESS_VALIDATIONS : PhaseId.INVOKE_APPLICATION);
        event.setPhaseId(phaseId);
        return event;
    }

    private boolean isImmediate(UIComponent component, AjaxBehavior ajaxBehavior) {
        boolean immediate = ajaxBehavior.isImmediate();
        if (!immediate) {
            if (component instanceof EditableValueHolder) {
                immediate = ((EditableValueHolder)component).isImmediate();
            } else if (component instanceof ActionSource) {
                immediate = ((ActionSource)component).isImmediate();
            }
        }
        return immediate;
    }

    private boolean isBypassUpdates(UIComponent component, AjaxBehavior ajaxBehavior) {
        boolean bypassUpdates = ajaxBehavior.isBypassUpdates();
        if (!bypassUpdates) {
            bypassUpdates = this.utils.isBooleanAttribute(component, "bypassUpdates");
        }
        return bypassUpdates;
    }

    public String getScript(ClientBehaviorContext behaviorContext, ClientBehavior behavior) {
        String script = null;
        if (behavior instanceof AjaxBehavior) {
            script = this.buildAjaxCommand(behaviorContext, (AjaxBehavior)behavior);
        }
        return script;
    }

    public String buildAjaxCommand(ClientBehaviorContext bContext, AjaxBehavior behavior) {
        UIComponent parent = bContext.getComponent();
        FacesContext context = bContext.getFacesContext();
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction(context, parent, "RichFaces.ajax");
        AjaxEventOptions options = this.buildOptions(context, bContext, behavior);
        ajaxFunction.addParameter((Object)options);
        return ajaxFunction.toString();
    }

    public AjaxEventOptions buildOptions(FacesContext context, ClientBehaviorContext bContext, AjaxClientBehavior behavior) {
        UIComponent parent = bContext.getComponent();
        String eventName = bContext.getEventName();
        AjaxEventOptions options = AjaxRendererUtils.buildEventOptions(context, parent, behavior);
        options.setParameter("javax.faces.behavior.event", eventName);
        return options;
    }
}

