/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import org.richfaces.component.AbstractDataScroller;
import org.richfaces.component.UIDataAdaptor;
import org.richfaces.renderkit.util.RendererUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataScrollerUtils {
    private static final RendererUtils RENDERER_UTILS = RendererUtils.getInstance();

    private DataScrollerUtils() {
    }

    public static int getPageCount(UIComponent data, int rowCount, int rows) {
        int pageCount;
        if (rows > 0) {
            int n = pageCount = rows <= 0 ? 1 : rowCount / rows;
            if (rowCount % rows > 0) {
                ++pageCount;
            }
            if (pageCount == 0) {
                pageCount = 1;
            }
        } else {
            rows = 1;
            pageCount = 1;
        }
        return pageCount;
    }

    public static int getRows(UIComponent component) {
        int row = (Integer)component.getAttributes().get("rows");
        if (row == 0) {
            row = DataScrollerUtils.getRowCount(component);
        }
        return row;
    }

    public static int getRowCount(UIComponent component) {
        return (Integer)DataScrollerUtils.eval((Serializable)((Object)PropertyKeys.rowCount), component, 0);
    }

    protected static Object eval(Serializable key, UIComponent component, Object defaultValue) {
        String name = key.toString();
        Object retObject = component.getAttributes().get(name);
        return retObject != null ? retObject : defaultValue;
    }

    public static UIComponent findParentContainer(UIComponent component) {
        UIComponent parent = component.getParent();
        if (!(component instanceof NamingContainer)) {
            DataScrollerUtils.findParentContainer(parent);
        }
        return parent;
    }

    public static UIComponent findDataTable(AbstractDataScroller dataScroller) {
        String forAttribute = dataScroller.getForComponent();
        if (forAttribute == null) {
            AbstractDataScroller forComp = dataScroller;
            while ((forComp = forComp.getParent()) != null) {
                if (!(forComp instanceof UIData) && !(forComp instanceof UIDataAdaptor)) continue;
                return forComp;
            }
            throw new FacesException("could not find dataTable for  datascroller " + dataScroller.getId());
        }
        UIComponent forComp = RENDERER_UTILS.findComponentFor((UIComponent)dataScroller, forAttribute);
        if (forComp == null) {
            throw new IllegalArgumentException("could not find dataTable with id '" + forAttribute + "'");
        }
        if (!(forComp instanceof UIData) && !(forComp instanceof UIDataAdaptor)) {
            throw new IllegalArgumentException("component with id '" + forAttribute + "' must be of type " + UIData.class.getName() + " or " + UIDataAdaptor.class + ", not type " + forComp.getClass().getName());
        }
        return forComp;
    }

    public static List<AbstractDataScroller> findDataScrollers(UIComponent dataTable) {
        ArrayList<AbstractDataScroller> datascrollers = new ArrayList<AbstractDataScroller>();
        Map facets = dataTable.getFacets();
        Set entries = facets.entrySet();
        for (Map.Entry entry : entries) {
            DataScrollerUtils.findBelow((UIComponent)entry.getValue(), datascrollers);
        }
        UIComponent parent = DataScrollerUtils.findParentContainer(dataTable);
        if (parent != null) {
            DataScrollerUtils.findBelow(parent, datascrollers);
        }
        return datascrollers;
    }

    protected static void findBelow(UIComponent component, List<AbstractDataScroller> result) {
        if (component instanceof AbstractDataScroller && component.isRendered()) {
            result.add((AbstractDataScroller)component);
        } else {
            for (UIComponent child : component.getChildren()) {
                if (child instanceof NamingContainer) continue;
                DataScrollerUtils.findBelow(child, result);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        rowCount,
        rows;

    }
}

