/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import org.ajax4jsf.component.IterationStateHolder;
import org.richfaces.DataScrollerUtils;
import org.richfaces.application.MessageFactory;
import org.richfaces.application.ServiceTracker;
import org.richfaces.appplication.FacesMessages;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.component.MetaComponentResolver;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.event.DataScrollerEvent;
import org.richfaces.event.DataScrollerListener;
import org.richfaces.event.DataScrollerSource;

public abstract class AbstractDataScroller
extends UIComponentBase
implements DataScrollerSource,
IterationStateHolder {
    public static final String COMPONENT_TYPE = "org.richfaces.DataScroller";
    public static final String COMPONENT_FAMILY = "org.richfaces.DataScroller";
    public static final String SCROLLER_STATE_ATTRIBUTE = "org.richfaces.DataScroller:page";
    public static final String FIRST_FACET_NAME = "first";
    public static final String LAST_FACET_NAME = "last";
    public static final String NEXT_FACET_NAME = "next";
    public static final String PREVIOUS_FACET_NAME = "previous";
    public static final String FAST_FORWARD_FACET_NAME = "fastforward";
    public static final String FAST_REWIND_FACET_NAME = "fastrewind";
    public static final String FIRST_DISABLED_FACET_NAME = "first_disabled";
    public static final String LAST_DISABLED_FACET_NAME = "last_disabled";
    public static final String PAGEMODE_FULL = "full";
    public static final String PAGEMODE_SHORT = "short";
    private Integer page;

    @Attribute
    public abstract String getLastPageMode();

    @Attribute
    public abstract String getForComponent();

    @Attribute(defaultValue="10")
    public abstract int getMaxPages();

    @Attribute(defaultValue="show")
    public abstract String getBoundaryControls();

    @Attribute(defaultValue="show")
    public abstract String getFastControls();

    @Attribute(defaultValue="show")
    public abstract String getStepControls();

    @Attribute(defaultValue="1")
    public abstract int getFastStep();

    public void addScrollerListener(DataScrollerListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public DataScrollerListener[] getScrollerListeners() {
        return (DataScrollerListener[])this.getFacesListeners(DataScrollerListener.class);
    }

    public void removeScrollerListener(DataScrollerListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof DataScrollerEvent) {
            DataScrollerEvent dataScrollerEvent = (DataScrollerEvent)event;
            this.updateModel(dataScrollerEvent.getPage());
            FacesContext facesContext = this.getFacesContext();
            UIComponent dataTable = this.getDataTable();
            List<AbstractDataScroller> dataScrollers = DataScrollerUtils.findDataScrollers(dataTable);
            for (AbstractDataScroller dataScroller : dataScrollers) {
                facesContext.getPartialViewContext().getRenderIds().add(dataScroller.getClientId(facesContext));
            }
            String dataTableId = null;
            if (dataTable instanceof MetaComponentResolver) {
                dataTableId = ((MetaComponentResolver)dataTable).resolveClientId(facesContext, dataTable, "body");
            }
            if (dataTableId == null) {
                dataTableId = dataTable.getClientId(facesContext);
            }
            facesContext.getPartialViewContext().getRenderIds().add(dataTableId);
            String dataScrollerId = this.getClientId(facesContext);
            if (!facesContext.getPartialViewContext().getRenderIds().contains(dataScrollerId)) {
                facesContext.getPartialViewContext().getRenderIds().add(dataScrollerId);
            }
        }
        super.broadcast(event);
    }

    public UIComponent getDataTable() {
        return DataScrollerUtils.findDataTable(this);
    }

    public int getPageForFacet(String facetName) {
        if (facetName == null) {
            throw new NullPointerException();
        }
        int newPage = 1;
        int pageCount = this.getPageCount();
        if (FIRST_FACET_NAME.equals(facetName)) {
            newPage = 1;
        } else if (LAST_FACET_NAME.equals(facetName)) {
            newPage = pageCount > 0 ? pageCount : 1;
        } else if (PREVIOUS_FACET_NAME.equals(facetName)) {
            newPage = this.getPage() - 1;
        } else if (NEXT_FACET_NAME.equals(facetName)) {
            newPage = this.getPage() + 1;
        } else if (FAST_FORWARD_FACET_NAME.equals(facetName)) {
            newPage = this.getPage() + this.getFastStep();
        } else if (FAST_REWIND_FACET_NAME.equals(facetName)) {
            newPage = this.getPage() - this.getFastStep();
        } else {
            try {
                newPage = Integer.parseInt(facetName.toString());
            }
            catch (NumberFormatException e) {
                throw new FacesException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (newPage >= 1 && newPage <= pageCount) {
            return newPage;
        }
        return 0;
    }

    public int getPageCount(UIComponent data) {
        int rowCount = this.getRowCount(data);
        int rows = this.getRows(data);
        return this.getPageCount(data, rowCount, rows);
    }

    public int getPageCount(UIComponent data, int rowCount, int rows) {
        return DataScrollerUtils.getPageCount(data, rowCount, rows);
    }

    public int getPageCount() {
        return this.getPageCount(this.getDataTable());
    }

    public int getRowCount(UIComponent data) {
        return (Integer)data.getAttributes().get("rowCount");
    }

    public int getRowCount() {
        return this.getRowCount(this.getDataTable());
    }

    public int getRows(UIComponent data) {
        return DataScrollerUtils.getRows(data);
    }

    public UIComponent getFirst() {
        return this.getFacet(FIRST_FACET_NAME);
    }

    public UIComponent getLast() {
        return this.getFacetByKey(LAST_FACET_NAME);
    }

    public UIComponent getNext() {
        return this.getFacetByKey(NEXT_FACET_NAME);
    }

    public UIComponent getPrevious() {
        return this.getFacetByKey(PREVIOUS_FACET_NAME);
    }

    public UIComponent getFastForward() {
        return this.getFacetByKey(FAST_FORWARD_FACET_NAME);
    }

    public UIComponent getFastRewind() {
        return this.getFacetByKey(FAST_REWIND_FACET_NAME);
    }

    private UIComponent getFacetByKey(String key) {
        return this.getFacet(key.toString());
    }

    private static boolean isRendered(UIComponent component) {
        for (UIComponent c = component; c != null; c = c.getParent()) {
            if (c.isRendered()) continue;
            return false;
        }
        return true;
    }

    public void setPage(int newPage) {
        this.page = newPage;
    }

    public int getPage() {
        FacesContext facesContext;
        UIComponent dataTable = this.getDataTable();
        Map attributes = dataTable.getAttributes();
        Integer state = (Integer)attributes.get(dataTable.getClientId(facesContext = this.getFacesContext()) + SCROLLER_STATE_ATTRIBUTE);
        if (state != null) {
            return state;
        }
        if (this.page != null) {
            return this.page;
        }
        ValueExpression ve = this.getValueExpression("page");
        if (ve != null) {
            try {
                Integer pageObject = (Integer)ve.getValue(this.getFacesContext().getELContext());
                if (pageObject != null) {
                    return pageObject;
                }
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return 1;
    }

    private MessageFactory getMessageFactory(FacesContext context) {
        return (MessageFactory)ServiceTracker.getService(MessageFactory.class);
    }

    private void updateModel(int newPage) {
        FacesContext facesContext = this.getFacesContext();
        UIComponent dataTable = this.getDataTable();
        if (AbstractDataScroller.isRendered(dataTable)) {
            dataTable.getAttributes().put(FIRST_FACET_NAME, (newPage - 1) * this.getRows(dataTable));
        }
        Map attributes = dataTable.getAttributes();
        attributes.put(dataTable.getClientId(facesContext) + SCROLLER_STATE_ATTRIBUTE, newPage);
        ValueExpression ve = this.getValueExpression("page");
        if (ve != null) {
            try {
                ve.setValue(facesContext.getELContext(), (Object)newPage);
                attributes.remove(dataTable.getClientId(facesContext) + SCROLLER_STATE_ATTRIBUTE);
            }
            catch (ELException e) {
                Throwable result;
                String messageStr = e.getMessage();
                for (result = e.getCause(); null != result && result.getClass().isAssignableFrom(ELException.class); result = result.getCause()) {
                    messageStr = result.getMessage();
                }
                FacesMessage message = null == messageStr ? ((MessageFactory)ServiceTracker.getService(MessageFactory.class)).createMessage(facesContext, (Enum)FacesMessages.UIINPUT_UPDATE, new Object[]{MessageUtil.getLabel(facesContext, (UIComponent)this)}) : new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
                facesContext.getExternalContext().log(message.getSummary(), result);
                facesContext.addMessage(this.getClientId(facesContext), message);
                facesContext.renderResponse();
            }
            catch (IllegalArgumentException e) {
                FacesMessage message = ((MessageFactory)ServiceTracker.getService(MessageFactory.class)).createMessage(facesContext, (Enum)FacesMessages.UIINPUT_UPDATE, new Object[]{MessageUtil.getLabel(facesContext, (UIComponent)this)});
                facesContext.getExternalContext().log(message.getSummary(), (Throwable)e);
                facesContext.addMessage(this.getClientId(facesContext), message);
                facesContext.renderResponse();
            }
            catch (Exception e) {
                FacesMessage message = ((MessageFactory)ServiceTracker.getService(MessageFactory.class)).createMessage(facesContext, (Enum)FacesMessages.UIINPUT_UPDATE, new Object[]{MessageUtil.getLabel(facesContext, (UIComponent)this)});
                facesContext.getExternalContext().log(message.getSummary(), (Throwable)e);
                facesContext.addMessage(this.getClientId(facesContext), message);
                facesContext.renderResponse();
            }
        }
    }

    public boolean isLocalPageSet() {
        return this.page != null;
    }

    public void resetLocalPage() {
        this.page = null;
    }

    public Object getIterationState() {
        return this.page;
    }

    public void setIterationState(Object state) {
        this.page = (Integer)state;
    }
}

