/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.ajax4jsf.javascript.JSLiteral;
import org.ajax4jsf.javascript.ScriptUtils;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.component.NumberUtils;
import org.richfaces.renderkit.html.ProgressBarBaseRenderer;
import org.richfaces.renderkit.util.CoreAjaxRendererUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProgressBar
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.richfaces.ProgressBar";
    public static final String COMPONENT_FAMILY = "org.richfaces.ProgressBar";
    public static final String FORCE_PERCENT_PARAM = "forcePercent";
    private static final String PERCENT_PARAM = "percent";
    private static final String MAXVALUE = "maxValue";
    private static final String MINVALUE = "minValue";
    private static final String ENABLED = "enabled";
    private static final String INTERVAL = "interval";
    private static final String MARKUP = "markup";
    private static final String COMPLETECLASS = "completeClass";
    private static final String REMAINCLASS = "remainClass";
    private static final String STYLECLASS = "styleClass";
    private static final String CONTEXT = "context";

    @Attribute(events={@EventName(value="click")})
    public abstract String getOnclick();

    @Attribute(events={@EventName(value="dblclick")})
    public abstract String getOndblclick();

    @Attribute(events={@EventName(value="mousedown")})
    public abstract String getOnmousedown();

    @Attribute(events={@EventName(value="mouseup")})
    public abstract String getOnmouseup();

    @Attribute(events={@EventName(value="mouseover")})
    public abstract String getOnmouseover();

    @Attribute(events={@EventName(value="mousemove")})
    public abstract String getOnmousemove();

    @Attribute(events={@EventName(value="mouseout")})
    public abstract String getOnmouseout();

    @Attribute(events={@EventName(value="submit")})
    public abstract String getOnsubmit();

    @Attribute
    public abstract String getLabel();

    @Attribute
    public abstract Object getData();

    public abstract void setData(Object var1);

    @Attribute(defaultValue="1000")
    public abstract int getInterval();

    @Attribute(defaultValue="false")
    public abstract boolean isEnabled();

    @Attribute(events={@EventName(value="beforedomupdate")})
    public abstract String getOnbeforedomupdate();

    @Attribute(events={@EventName(value="complete")})
    public abstract String getOncomplete();

    @Attribute
    public abstract String getCompleteClass();

    @Attribute
    public abstract String getFinishClass();

    @Attribute
    public abstract String getInitialClass();

    @Attribute
    public abstract String getRemainClass();

    @Attribute
    public abstract String getFocus();

    @Attribute
    public abstract String getReRenderAfterComplete();

    @Attribute
    public abstract String getMode();

    @Attribute
    public abstract int getMaxValue();

    @Attribute
    public abstract int getMinValue();

    @Attribute
    public abstract Object getValue();

    @Attribute
    public abstract Object getParameters();

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        String clientId;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (!params.containsKey(clientId = this.getClientId(facesContext))) {
            return;
        }
        if (!params.containsKey(FORCE_PERCENT_PARAM) && params.containsKey(PERCENT_PARAM)) {
            Number value = NumberUtils.getNumber(this.getAttributes().get("value"));
            PartialViewContext pvc = FacesContext.getCurrentInstance().getPartialViewContext();
            pvc.getRenderIds().remove(this.getClientId());
            this.setData(this.getResponseData(value, facesContext));
        } else if (params.containsKey(FORCE_PERCENT_PARAM)) {
            Object reRender;
            Set ajaxRegions;
            PartialViewContext pvc = FacesContext.getCurrentInstance().getPartialViewContext();
            pvc.getRenderIds().add(this.getClientId());
            String forcedState = (String)params.get(FORCE_PERCENT_PARAM);
            if ("completeState".equals(forcedState) && (ajaxRegions = CoreAjaxRendererUtils.asIdsSet(reRender = this.getAttributes().get("reRenderAfterComplete"))) != null) {
                for (String id : ajaxRegions) {
                    pvc.getExecuteIds().add(id);
                    pvc.getRenderIds().add(id);
                }
            }
        }
    }

    private Map<Object, Object> getResponseData(Number value, FacesContext facesContext) {
        ProgressBarBaseRenderer renderer = (ProgressBarBaseRenderer)this.getRenderer(facesContext);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("value", value);
        map.put(INTERVAL, this.getInterval());
        if (this.getAttributes().get("style") != null) {
            map.put("style", this.getAttributes().get("style"));
        }
        map.put(ENABLED, (Boolean)this.getAttributes().get(ENABLED));
        if (!this.isSimple(renderer)) {
            map.put(MARKUP, this.getMarkup(facesContext, renderer));
            map.put(CONTEXT, this.getContext(renderer, value));
        }
        this.addStyles2Responce(map, COMPLETECLASS, this.getAttributes().get(COMPLETECLASS));
        this.addStyles2Responce(map, REMAINCLASS, this.getAttributes().get(REMAINCLASS));
        this.addStyles2Responce(map, STYLECLASS, this.getAttributes().get(STYLECLASS));
        return map;
    }

    private JSLiteral getContext(ProgressBarBaseRenderer renderer, Number percent) {
        StringBuffer buffer = new StringBuffer("{");
        buffer.append("\"value\":");
        buffer.append(ScriptUtils.toScript((Object)percent.toString())).append(",");
        buffer.append("\"minValue\":");
        buffer.append(ScriptUtils.toScript((Object)this.getAttributes().get(MINVALUE).toString())).append(",");
        buffer.append("\"maxValue\":");
        buffer.append(ScriptUtils.toScript((Object)this.getAttributes().get(MAXVALUE).toString()));
        String parameters = this.handleParameters(renderer.getParameters((UIComponent)this));
        if (parameters != null) {
            buffer.append(",");
            buffer.append(parameters);
        }
        buffer.append("}");
        return new JSLiteral(buffer.toString());
    }

    private String handleParameters(String str) {
        if (str != null && str.length() > 0) {
            StringBuilder s = new StringBuilder();
            while (str.indexOf(":") != -1) {
                String a = str.substring(0, str.indexOf(":"));
                str = str.substring(str.indexOf(":"));
                s.append("\"");
                s.append(a);
                s.append("\"");
                if (str.indexOf(",") != -1) {
                    String b = str.substring(0, str.indexOf(",") + 1);
                    str = str.substring(str.indexOf(",") + 1);
                    s.append(b);
                    continue;
                }
                s.append(str);
                return s.toString();
            }
        }
        return null;
    }

    private boolean isSimple(ProgressBarBaseRenderer renderer) {
        return renderer.isSimpleMarkup((UIComponent)this);
    }

    private String getMarkup(FacesContext context, ProgressBarBaseRenderer renderer) {
        return renderer.getMarkup(context, (UIComponent)this).toString();
    }

    private void addStyles2Responce(Map<Object, Object> map, String key, Object className) {
        if (className != null) {
            map.put(key, className);
        }
    }
}

