/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UpdateModelException;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreValidateEvent;
import org.richfaces.application.MessageFactory;
import org.richfaces.application.ServiceTracker;
import org.richfaces.appplication.FacesMessages;
import org.richfaces.component.AbstractDivPanel;
import org.richfaces.component.AbstractTogglePanelItem;
import org.richfaces.component.SwitchType;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.event.ItemChangeEvent;
import org.richfaces.event.ItemChangeListener;
import org.richfaces.event.ItemChangeSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTogglePanel
extends AbstractDivPanel
implements ItemChangeSource {
    public static final String COMPONENT_TYPE = "org.richfaces.TogglePanel";
    public static final String COMPONENT_FAMILY = "org.richfaces.TogglePanel";
    public static final String META_NAME_FIRST = "@first";
    public static final String META_NAME_PREV = "@prev";
    public static final String META_NAME_NEXT = "@next";
    public static final String META_NAME_LAST = "@last";
    public static final String UPDATE_MESSAGE_ID = "javax.faces.component.UIInput.UPDATE";
    private String submittedActiveItem = null;

    protected AbstractTogglePanel() {
        this.setRendererType("org.richfaces.TogglePanel");
    }

    public Object getSubmittedValue() {
        return this.submittedActiveItem;
    }

    public void resetValue() {
        this.setValue(null);
        this.setSubmittedValue(null);
        this.setLocalValueSet(false);
        this.setValid(true);
    }

    public void setSubmittedValue(Object submittedValue) {
        this.submittedActiveItem = String.valueOf(submittedValue);
    }

    public boolean isLocalValueSet() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.localValueSet), (Object)false);
    }

    public void setLocalValueSet(boolean localValueSet) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.localValueSet), (Object)localValueSet);
    }

    public boolean isValid() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.valid), (Object)true);
    }

    public void setValid(boolean valid) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.valid), (Object)valid);
    }

    public boolean isRequired() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.required), (Object)false);
    }

    public void setRequired(boolean required) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.required), (Object)required);
    }

    public boolean isImmediate() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.immediate), (Object)false);
    }

    public void setImmediate(boolean immediate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.immediate), (Object)immediate);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        Iterator kids = this.getFacetsAndChildren();
        String activeItem = this.getActiveItemValue();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!this.isActiveItem(kid, activeItem)) continue;
            kid.processDecodes(context);
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        finally {
            this.popComponentFromEL(context);
        }
        this.executeValidate(context);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        Application app = context.getApplication();
        app.publishEvent(context, PreValidateEvent.class, (Object)this);
        Iterator kids = this.getFacetsAndChildren();
        String activeItem = this.getActiveItemValue();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!this.isActiveItem(kid, activeItem)) continue;
            kid.processValidators(context);
        }
        app.publishEvent(context, PostValidateEvent.class, (Object)this);
        this.popComponentFromEL(context);
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, null);
        Iterator kids = this.getFacetsAndChildren();
        String activeItem = this.getActiveItemValue();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!this.isActiveItem(kid, activeItem)) continue;
            kid.processUpdates(context);
        }
        this.popComponentFromEL(context);
        try {
            this.updateModel(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.setValid(true);
        super.decode(context);
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueExpression ve = this.getValueExpression("activeItem");
        if (ve == null) {
            return;
        }
        Throwable caught = null;
        FacesMessage message = null;
        try {
            ve.setValue(context.getELContext(), this.getLocalValue());
            this.setValue(null);
            this.setLocalValueSet(false);
        }
        catch (ELException e) {
            caught = e;
            String messageStr = e.getMessage();
            for (Throwable result = e.getCause(); null != result && result.getClass().isAssignableFrom(ELException.class); result = result.getCause()) {
                messageStr = result.getMessage();
            }
            message = messageStr == null ? ((MessageFactory)ServiceTracker.getService(MessageFactory.class)).createMessage(context, FacesMessage.SEVERITY_ERROR, (Enum)FacesMessages.UIINPUT_UPDATE, new Object[]{MessageUtil.getLabel(context, (UIComponent)this)}) : new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
            this.setValid(false);
        }
        catch (Exception e) {
            caught = e;
            this.setValid(false);
        }
        if (caught != null) {
            assert (message != null);
            UpdateModelException toQueue = new UpdateModelException(message, caught);
            ExceptionQueuedEventContext eventContext = new ExceptionQueuedEventContext(context, (Throwable)toQueue, (UIComponent)this, PhaseId.UPDATE_MODEL_VALUES);
            context.getApplication().publishEvent(context, ExceptionQueuedEvent.class, (Object)eventContext);
        }
    }

    private void executeValidate(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.validationFailed();
            context.renderResponse();
        }
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        String activeItem = this.getSubmittedActiveItem();
        if (activeItem == null) {
            return;
        }
        String previous = (String)this.getValue();
        this.setValue(activeItem);
        this.setSubmittedActiveItem(null);
        if (previous != null && !previous.equalsIgnoreCase(activeItem)) {
            this.queueEvent((FacesEvent)new ItemChangeEvent((UIComponent)this, previous, activeItem));
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof ItemChangeEvent && event.getComponent() == this) {
            this.setEventPhase(event);
        }
        super.queueEvent(event);
    }

    protected void setEventPhase(FacesEvent event) {
        if (this.isImmediate()) {
            event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        } else if (this.isBypassUpdates()) {
            event.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
        } else {
            event.setPhaseId(PhaseId.INVOKE_APPLICATION);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof ItemChangeEvent && (this.isBypassUpdates() || this.isImmediate())) {
            FacesContext.getCurrentInstance().renderResponse();
        }
    }

    @Override
    public String getFamily() {
        return "org.richfaces.TogglePanel";
    }

    public boolean getRendersChildren() {
        return true;
    }

    private String getActiveItemValue() {
        String value = this.getActiveItem();
        if (value == null) {
            value = this.getSubmittedActiveItem();
        }
        return value;
    }

    protected boolean isActiveItem(UIComponent kid) {
        return this.isActiveItem(kid, this.getActiveItemValue());
    }

    protected boolean isActiveItem(UIComponent kid, String value) {
        if (kid == null || value == null) {
            return false;
        }
        return AbstractTogglePanel.getChildName(kid).equals(value);
    }

    private static String getChildName(UIComponent item) {
        if (item == null) {
            return null;
        }
        if (!(item instanceof AbstractTogglePanelItem)) {
            throw new IllegalArgumentException();
        }
        return ((AbstractTogglePanelItem)item).getName();
    }

    public AbstractTogglePanelItem getItemByIndex(int index) {
        List<AbstractTogglePanelItem> children = this.getRenderedItems();
        if (this.isCycledSwitching()) {
            int size = this.getRenderedItems().size();
            return children.get((size + index) % size);
        }
        if (index < 0 || index >= children.size()) {
            return null;
        }
        return children.get(index);
    }

    public List<AbstractTogglePanelItem> getRenderedItems() {
        ArrayList<AbstractTogglePanelItem> res = new ArrayList<AbstractTogglePanelItem>(this.getChildCount());
        for (UIComponent child : this.getChildren()) {
            if (!child.isRendered() || !(child instanceof AbstractTogglePanelItem)) continue;
            res.add((AbstractTogglePanelItem)child);
        }
        return res;
    }

    public AbstractTogglePanelItem getItem(String name) {
        if (META_NAME_FIRST.equals(name)) {
            return this.getFirstItem();
        }
        if (META_NAME_PREV.equals(name)) {
            return this.getPrevItem();
        }
        if (META_NAME_NEXT.equals(name)) {
            return this.getNextItem();
        }
        if (META_NAME_LAST.equals(name)) {
            return this.getLastItem();
        }
        return this.getItemByIndex(this.getChildIndex(name));
    }

    public AbstractTogglePanelItem getFirstItem() {
        return this.getItemByIndex(0);
    }

    public AbstractTogglePanelItem getPrevItem() {
        return this.getPrevItem(this.getActiveItem());
    }

    public AbstractTogglePanelItem getPrevItem(String name) {
        return this.getItemByIndex(this.getChildIndex(name) - 1);
    }

    public AbstractTogglePanelItem getNextItem() {
        return this.getNextItem(this.getActiveItem());
    }

    public AbstractTogglePanelItem getNextItem(String name) {
        return this.getItemByIndex(this.getChildIndex(name) + 1);
    }

    public AbstractTogglePanelItem getLastItem() {
        return this.getItemByIndex(this.getRenderedItems().size() - 1);
    }

    public int getChildIndex(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name is required parameter.");
        }
        List<AbstractTogglePanelItem> items = this.getRenderedItems();
        for (int ind = 0; ind < items.size(); ++ind) {
            if (!name.equals(items.get(ind).getName())) continue;
            return ind;
        }
        return Integer.MIN_VALUE;
    }

    public String getSubmittedActiveItem() {
        return this.submittedActiveItem;
    }

    public void setSubmittedActiveItem(String submittedActiveItem) {
        this.submittedActiveItem = submittedActiveItem;
    }

    public String getActiveItem() {
        return (String)this.getValue();
    }

    public void setActiveItem(String value) {
        this.setValue(value);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if ("activeItem".equals(name)) {
            super.setValueExpression("value", binding);
        } else {
            super.setValueExpression(name, binding);
        }
    }

    public abstract SwitchType getSwitchType();

    public abstract boolean isBypassUpdates();

    public abstract boolean isLimitToList();

    public abstract boolean isCycledSwitching();

    public abstract Object getData();

    public abstract String getStatus();

    public abstract Object getExecute();

    public abstract Object getRender();

    public abstract MethodExpression getItemChangeListener();

    public void addItemChangeListener(ItemChangeListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public ItemChangeListener[] getItemChangeListeners() {
        return (ItemChangeListener[])this.getFacesListeners(ItemChangeListener.class);
    }

    public void removeItemChangeListener(ItemChangeListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PropertyKeys {
        localValueSet,
        required,
        valid,
        immediate;

    }
}

