/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIForm;
import org.ajax4jsf.component.IterationStateHolder;

final class SavedState
implements Serializable {
    public static final SavedState EMPTY = new SavedState();
    private static final long serialVersionUID = -1563864456074187422L;
    private boolean valid = true;
    private boolean localValueSet;
    private boolean submitted;
    private Object submittedValue;
    private Object value;
    private Object iterationState;

    public SavedState() {
    }

    public SavedState(EditableValueHolder evh) {
        this.value = evh.getLocalValue();
        this.valid = evh.isValid();
        this.submittedValue = evh.getSubmittedValue();
        this.localValueSet = evh.isLocalValueSet();
    }

    public SavedState(IterationStateHolder ish) {
        this.iterationState = ish.getIterationState();
    }

    public SavedState(UIForm form) {
        this.submitted = form.isSubmitted();
    }

    Object getSubmittedValue() {
        return this.submittedValue;
    }

    void setSubmittedValue(Object submittedValue) {
        this.submittedValue = submittedValue;
    }

    boolean isValid() {
        return this.valid;
    }

    void setValid(boolean valid) {
        this.valid = valid;
    }

    Object getValue() {
        return this.value;
    }

    void setValue(Object value) {
        this.value = value;
    }

    boolean isLocalValueSet() {
        return this.localValueSet;
    }

    void setLocalValueSet(boolean localValueSet) {
        this.localValueSet = localValueSet;
    }

    Object getIterationState() {
        return this.iterationState;
    }

    void setIterationState(Object iterationState) {
        this.iterationState = iterationState;
    }

    public String toString() {
        if (this.iterationState != null) {
            return "iterationState: " + this.iterationState;
        }
        return "submittedValue: " + this.submittedValue + " value: " + this.value + " localValueSet: " + this.localValueSet + " submitted: " + this.submitted;
    }

    public void apply(EditableValueHolder evh) {
        evh.setValue(this.value);
        evh.setValid(this.valid);
        evh.setSubmittedValue(this.submittedValue);
        evh.setLocalValueSet(this.localValueSet);
    }

    public void apply(IterationStateHolder ish) {
        ish.setIterationState(this.iterationState);
    }

    public void apply(UIForm form) {
        form.setSubmitted(this.submitted);
    }
}

