/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.servlet.jsp.jstl.sql.Result;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.ScriptUtils;
import org.richfaces.component.AbstractAutocomplete;
import org.richfaces.component.AutocompleteLayout;
import org.richfaces.component.util.InputUtils;
import org.richfaces.renderkit.AutocompleteDivLayoutStrategy;
import org.richfaces.renderkit.AutocompleteEncodeStrategy;
import org.richfaces.renderkit.AutocompleteListLayoutStrategy;
import org.richfaces.renderkit.AutocompleteTableLayoutStrategy;
import org.richfaces.renderkit.InputRendererBase;
import org.richfaces.renderkit.MetaComponentRenderer;
import org.richfaces.renderkit.util.RendererUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="ajax.reslib"), @ResourceDependency(library="org.richfaces", name="base-component.reslib"), @ResourceDependency(name="jquery.position.js"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(name="richfaces-selection.js"), @ResourceDependency(library="org.richfaces", name="AutocompleteBase.js"), @ResourceDependency(library="org.richfaces", name="Autocomplete.js"), @ResourceDependency(library="org.richfaces", name="Autocomplete.ecss")})
public abstract class AutocompleteRendererBase
extends InputRendererBase
implements MetaComponentRenderer {
    public JSFunctionDefinition getClientFilterFunction(UIComponent component) {
        AbstractAutocomplete autocomplete = (AbstractAutocomplete)component;
        String clientFilter = (String)autocomplete.getAttributes().get("clientFilter");
        if (clientFilter != null && clientFilter.length() != 0) {
            JSFunctionDefinition clientFilterFunction = new JSFunctionDefinition(new Object[]{"subString"});
            clientFilterFunction.addParameter((Object)"value");
            clientFilterFunction.addToBody((Object)clientFilter);
            return clientFilterFunction;
        }
        return null;
    }

    public String getScriptOptions(UIComponent component) {
        Map attributes = component.getAttributes();
        HashMap<String, Object> options = new HashMap<String, Object>();
        RendererUtils utils = this.getUtils();
        utils.addToScriptHash(options, "buttonId", component.getClientId() + "Button");
        utils.addToScriptHash(options, "selectedItemClass", attributes.get("selectedItemClass"));
        utils.addToScriptHash(options, "minChars", attributes.get("minChars"), "1");
        utils.addToScriptHash(options, "filterFunction", attributes.get("filterFunction"));
        utils.addToScriptHash(options, "autofill", attributes.get("autofill"), "true");
        utils.addToScriptHash(options, "disabled", attributes.get("disabled"), "false");
        utils.addToScriptHash(options, "selectFirst", attributes.get("selectFirst"), "true");
        utils.addToScriptHash(options, "tokens", attributes.get("tokens"));
        utils.addToScriptHash(options, "onbegin", attributes.get("onbegin"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
        utils.addToScriptHash(options, "oncomplete", attributes.get("oncomplete"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
        utils.addToScriptHash(options, "onerror", attributes.get("onerror"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
        utils.addToScriptHash(options, "onbeforedomupdate", attributes.get("onbeforedomupdate"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
        utils.addToScriptHash(options, "onchange", attributes.get("onchange"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
        utils.addToScriptHash(options, "onselectitem", attributes.get("onselectitem"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
        utils.addToScriptHash(options, "onfocus", attributes.get("onfocus"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
        utils.addToScriptHash(options, "onblur", attributes.get("onblur"), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
        utils.addToScriptHash(options, "filterFunction", this.getClientFilterFunction(component));
        String mode = (String)attributes.get("mode");
        if (mode != null) {
            if (mode.equals("ajax")) {
                utils.addToScriptHash(options, "isCachedAjax", false, "true");
            } else if (mode.equals("client") || mode.equals("lazyClient")) {
                utils.addToScriptHash(options, "ajaxMode", false, "true");
                if (mode.equals("lazyClient")) {
                    utils.addToScriptHash(options, "lazyClientMode", true, "false");
                }
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append(ScriptUtils.toScript(options));
        return builder.toString();
    }

    private DataModel<Object> getItems(FacesContext facesContext, AbstractAutocomplete component) {
        ArrayDataModel result;
        Object itemsObject = null;
        MethodExpression autocompleteMethod = component.getAutocompleteMethod();
        if (autocompleteMethod != null) {
            Map requestParameters = facesContext.getExternalContext().getRequestParameterMap();
            String value = (String)requestParameters.get(component.getClientId(facesContext) + "Value");
            try {
                itemsObject = autocompleteMethod.invoke(facesContext.getELContext(), new Object[]{facesContext, component, value});
            }
            catch (ELException e) {
                try {
                    autocompleteMethod = facesContext.getApplication().getExpressionFactory().createMethodExpression(facesContext.getELContext(), autocompleteMethod.getExpressionString(), Void.class, new Class[]{String.class});
                    itemsObject = autocompleteMethod.invoke(facesContext.getELContext(), new Object[]{value});
                }
                catch (ELException ee) {
                    ee.printStackTrace();
                }
            }
        } else {
            itemsObject = component.getAutocompleteList();
        }
        if (itemsObject instanceof Object[]) {
            result = new ArrayDataModel((Object[])itemsObject);
        } else if (itemsObject instanceof List) {
            result = new ListDataModel((List)itemsObject);
        } else if (itemsObject instanceof Result) {
            result = new ResultDataModel((Result)itemsObject);
        } else if (itemsObject instanceof ResultSet) {
            result = new ResultSetDataModel((ResultSet)itemsObject);
        } else if (itemsObject != null) {
            ArrayList temp = new ArrayList();
            Iterator iterator = ((Iterable)itemsObject).iterator();
            while (iterator.hasNext()) {
                temp.add(iterator.next());
            }
            result = new ListDataModel(temp);
        } else {
            result = new ListDataModel(null);
        }
        return result;
    }

    private Object saveVar(FacesContext context, String var) {
        if (var != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            return requestMap.get(var);
        }
        return null;
    }

    private void setVar(FacesContext context, String var, Object varObject) {
        if (var != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            requestMap.put(var, varObject);
        }
    }

    protected void encodeItems(FacesContext facesContext, UIComponent component, List<Object> fetchValues) throws IOException {
        AbstractAutocomplete comboBox = (AbstractAutocomplete)component;
        AutocompleteEncodeStrategy strategy = this.getStrategy(component);
        strategy.encodeItemsContainerBegin(facesContext, component);
        boolean hasEncodedElements = false;
        Object savedVar = this.saveVar(facesContext, comboBox.getVar());
        DataModel<Object> model = this.getItems(facesContext, comboBox);
        Iterator items = model.iterator();
        while (items.hasNext()) {
            hasEncodedElements = true;
            Object nextItem = items.next();
            this.setVar(facesContext, comboBox.getVar(), nextItem);
            this.encodeItem(facesContext, comboBox, nextItem, strategy);
            if (comboBox.getFetchValue() != null) {
                fetchValues.add(comboBox.getFetchValue());
                continue;
            }
            if (comboBox.getItemConverter() != null) {
                fetchValues.add(comboBox.getItemConverter().getAsString(facesContext, component, nextItem));
                continue;
            }
            fetchValues.add(nextItem);
        }
        this.setVar(facesContext, comboBox.getVar(), savedVar);
        if (!hasEncodedElements) {
            strategy.encodeFakeItem(facesContext, component);
        }
        strategy.encodeItemsContainerEnd(facesContext, component);
    }

    protected void encodeItemsContainer(FacesContext facesContext, UIComponent component) throws IOException {
        AutocompleteEncodeStrategy strategy = this.getStrategy(component);
        Object mode = component.getAttributes().get("mode");
        if (mode != null && mode.equals("client")) {
            ArrayList<Object> fetchValues = new ArrayList<Object>();
            this.encodeItems(facesContext, component, fetchValues);
        } else {
            strategy.encodeItemsContainerBegin(facesContext, component);
            strategy.encodeItemsContainerEnd(facesContext, component);
        }
    }

    public void encodeItem(FacesContext facesContext, AbstractAutocomplete comboBox, Object item, AutocompleteEncodeStrategy strategy) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (comboBox.getChildCount() > 0) {
            strategy.encodeItem(facesContext, (UIComponent)comboBox);
        } else if (item != null) {
            strategy.encodeItemBegin(facesContext, (UIComponent)comboBox);
            writer.writeAttribute("class", (Object)"rf-au-opt rf-au-fnt rf-au-inp", null);
            String value = null;
            if (comboBox.getItemConverter() != null) {
                value = comboBox.getItemConverter().getAsString(facesContext, (UIComponent)comboBox, item);
            }
            if (value != null) {
                writer.writeText(value, null);
            }
            writer.writeText(item, null);
            strategy.encodeItemEnd(facesContext, (UIComponent)comboBox);
        }
    }

    private AutocompleteEncodeStrategy getStrategy(UIComponent component) {
        AbstractAutocomplete comboBox = (AbstractAutocomplete)component;
        if (comboBox.getLayout() != null) {
            if (comboBox.getLayout().equals(AutocompleteLayout.div.toString())) {
                return new AutocompleteDivLayoutStrategy();
            }
            if (comboBox.getLayout().equals(AutocompleteLayout.list.toString())) {
                return new AutocompleteListLayoutStrategy();
            }
            if (comboBox.getLayout().equals(AutocompleteLayout.table.toString())) {
                return new AutocompleteTableLayoutStrategy();
            }
        }
        return new AutocompleteDivLayoutStrategy();
    }

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        AbstractAutocomplete autocomplete = (AbstractAutocomplete)component;
        if (InputUtils.isDisabled((UIComponent)autocomplete)) {
            return;
        }
        Map requestParameters = context.getExternalContext().getRequestParameterMap();
        Object value = requestParameters.get(component.getClientId(context) + "Value");
        if (value != null) {
            if (autocomplete.getConverter() != null) {
                value = autocomplete.getConverter().getAsObject(context, component, value.toString());
            }
            autocomplete.setSubmittedValue(value);
        }
        super.doDecode(context, component);
        if (requestParameters.get(component.getClientId(context) + ".ajax") != null) {
            PartialViewContext pvc = context.getPartialViewContext();
            pvc.getRenderIds().add(component.getClientId(context) + '@' + "items");
        }
    }

    public void encodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) throws IOException {
        if ("items".equals(metaComponentId)) {
            ArrayList<Object> fetchValues = new ArrayList<Object>();
            PartialResponseWriter partialWriter = context.getPartialViewContext().getPartialResponseWriter();
            partialWriter.startUpdate(this.getStrategy(component).getContainerElementId(context, component));
            this.encodeItems(context, component, fetchValues);
            partialWriter.endUpdate();
            if (!fetchValues.isEmpty() && Iterators.find(fetchValues.iterator(), (Predicate)Predicates.notNull()) != null) {
                Map dataMap = AjaxContext.getCurrentInstance((FacesContext)context).getResponseComponentDataMap();
                dataMap.put(component.getClientId(context), fetchValues);
            }
        } else {
            throw new IllegalArgumentException(metaComponentId);
        }
    }
}

