/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.model.DataVisitResult;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceRange;
import org.richfaces.component.AbstractExtendedDataTable;
import org.richfaces.component.UIDataTableBase;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.context.OnOffResponseWriter;
import org.richfaces.model.SelectionMode;
import org.richfaces.renderkit.AjaxEventOptions;
import org.richfaces.renderkit.ComponentAttribute;
import org.richfaces.renderkit.MetaComponentRenderer;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RowHolderBase;
import org.richfaces.renderkit.SelectionRenderer;
import org.richfaces.renderkit.util.AjaxRendererUtils;
import org.richfaces.renderkit.util.RendererUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(name="jquery.position.js"), @ResourceDependency(library="org.richfaces", name="extendedDataTable.ecss"), @ResourceDependency(library="org.richfaces", name="extendedDataTable.js")})
public class ExtendedDataTableRenderer
extends SelectionRenderer
implements MetaComponentRenderer {
    private static final Map<String, ComponentAttribute> EVENT_ATTRIBUTES = Collections.unmodifiableMap(ComponentAttribute.createMap(new ComponentAttribute("onselectionchange").setEventNames("selectionchange"), new ComponentAttribute("onbeforeselectionchange").setEventNames("beforeselectionchange")));

    private void encodeEmptyFooterCell(FacesContext context, ResponseWriter writer, UIComponent column) throws IOException {
        if (column.isRendered()) {
            writer.startElement("td", column);
            writer.startElement("div", column);
            writer.writeAttribute("class", (Object)("rf-edt-ftr-c-emp rf-edt-c-" + column.getId()), null);
            writer.endElement("div");
            writer.endElement("td");
        }
    }

    private void encodeHeaderOrFooterCell(FacesContext context, ResponseWriter writer, UIComponent column, String facetName) throws IOException {
        if (column.isRendered()) {
            String classAttribute = facetName + "Class";
            writer.startElement("td", column);
            if ("header".equals(facetName)) {
                writer.startElement("div", column);
                writer.writeAttribute("class", (Object)("rf-edt-rsz-cntr rf-edt-c-" + column.getId()), null);
                writer.startElement("div", column);
                writer.writeAttribute("class", (Object)"rf-edt-rsz", null);
                writer.endElement("div");
                writer.endElement("div");
            }
            writer.startElement("div", column);
            writer.writeAttribute("class", (Object)HtmlUtil.concatClasses("rf-edt-" + facetName.charAt(0) + facetName.charAt(3) + "r-c", "rf-edt-c-" + column.getId(), (String)column.getAttributes().get(classAttribute)), null);
            writer.startElement("div", column);
            writer.writeAttribute("class", (Object)("rf-edt-" + facetName.charAt(0) + facetName.charAt(3) + "r-c-cnt"), null);
            UIComponent facet = column.getFacet(facetName);
            if (facet != null && facet.isRendered()) {
                facet.encodeAll(context);
            }
            writer.endElement("div");
            writer.endElement("div");
            writer.endElement("td");
        }
    }

    private void encodeHeaderOrFooter(RendererState state, String name) throws IOException {
        FacesContext context = state.getContext();
        ResponseWriter writer = context.getResponseWriter();
        UIDataTableBase table = state.getRow();
        boolean columnFacetPresent = table.isColumnFacetPresent(name);
        if (columnFacetPresent || "footer".equals(name)) {
            writer.startElement("div", (UIComponent)table);
            writer.writeAttribute("class", (Object)HtmlUtil.concatClasses("rf-edt-" + name.charAt(0) + name.charAt(3) + "r", (String)table.getAttributes().get(name + "Class")), null);
            writer.startElement("table", (UIComponent)table);
            writer.writeAttribute("cellpadding", (Object)"0", null);
            writer.writeAttribute("cellspacing", (Object)"0", null);
            writer.startElement("tbody", (UIComponent)table);
            writer.startElement("tr", (UIComponent)table);
            state.startIterate();
            while (state.hasNextPart()) {
                Part part = state.nextPart();
                PartName partName = part.getName();
                Iterator<UIComponent> columns = part.getColumns().iterator();
                if (!columns.hasNext()) continue;
                writer.startElement("td", (UIComponent)table);
                if (PartName.frozen.equals((Object)partName) && "footer".equals(name)) {
                    writer.writeAttribute("class", (Object)"rf-edt-ftr-fzn", null);
                }
                writer.startElement("div", (UIComponent)table);
                if (PartName.frozen.equals((Object)partName)) {
                    if ("header".equals(name)) {
                        writer.writeAttribute("id", (Object)(table.getClientId(context) + ":frozenHeader"), null);
                    }
                } else {
                    writer.writeAttribute("id", (Object)(table.getClientId(context) + ":" + name), null);
                    writer.writeAttribute("class", (Object)("rf-edt-cnt" + ("footer".equals(name) ? " rf-edt-ftr-cnt" : "")), null);
                }
                String tableId = table.getClientId(context) + ":cf" + name.charAt(0) + partName.name().charAt(0);
                EncoderVariance encoderVariance = state.getEncoderVariance();
                encoderVariance.encodeStartUpdate(context, tableId);
                writer.startElement("table", (UIComponent)table);
                writer.writeAttribute("id", (Object)tableId, null);
                writer.writeAttribute("cellpadding", (Object)"0", null);
                writer.writeAttribute("cellspacing", (Object)"0", null);
                writer.startElement("tbody", (UIComponent)table);
                writer.startElement("tr", (UIComponent)table);
                while (columns.hasNext()) {
                    if (columnFacetPresent) {
                        this.encodeHeaderOrFooterCell(context, writer, columns.next(), name);
                        continue;
                    }
                    this.encodeEmptyFooterCell(context, writer, columns.next());
                }
                writer.endElement("tr");
                writer.endElement("tbody");
                writer.endElement("table");
                encoderVariance.encodeEndUpdate(context);
                writer.endElement("div");
                writer.endElement("td");
            }
            writer.endElement("tr");
            writer.endElement("tbody");
            writer.endElement("table");
            writer.endElement("div");
        }
    }

    public void encodeHeader(RendererState state) throws IOException {
        FacesContext context = state.getContext();
        ResponseWriter writer = context.getResponseWriter();
        UIDataTableBase table = state.getRow();
        UIComponent header = table.getFacet("header");
        if (header != null && header.isRendered()) {
            String elementId = table.getClientId(context) + ":tfh";
            EncoderVariance encoderVariance = state.getEncoderVariance();
            encoderVariance.encodeStartUpdate(context, elementId);
            writer.startElement("div", (UIComponent)table);
            writer.writeAttribute("id", (Object)elementId, null);
            writer.writeAttribute("class", (Object)"rf-edt-tbl-hdr", null);
            header.encodeAll(context);
            writer.endElement("div");
            encoderVariance.encodeEndUpdate(context);
        }
        this.encodeHeaderOrFooter(state, "header");
    }

    public void encodeBody(RendererState state) throws IOException {
        FacesContext context = state.getContext();
        ResponseWriter writer = context.getResponseWriter();
        UIDataTableBase table = state.getRow();
        String tableBodyId = table.getClientId(context) + ":b";
        EncoderVariance encoderVariance = state.getEncoderVariance();
        encoderVariance.encodeStartUpdate(context, tableBodyId);
        writer.startElement("div", (UIComponent)table);
        writer.writeAttribute("id", (Object)tableBodyId, null);
        writer.writeAttribute("class", (Object)"rf-edt-b", null);
        if (table.getRowCount() == 0) {
            UIComponent facet = table.getFacet("noData");
            if (facet != null && facet.isRendered()) {
                facet.encodeAll(context);
            } else {
                Object noDataLabel = table.getAttributes().get("noDataLabel");
                if (noDataLabel != null) {
                    writer.writeText(noDataLabel, "noDataLabel");
                }
            }
        } else {
            table.getAttributes().put("clientFirst", 0);
            writer.startElement("div", (UIComponent)table);
            writer.startElement("div", (UIComponent)table);
            writer.writeAttribute("class", (Object)"rf-edt-spcr", null);
            writer.endElement("div");
            writer.startElement("table", (UIComponent)table);
            writer.writeAttribute("cellpadding", (Object)"0", null);
            writer.writeAttribute("cellspacing", (Object)"0", null);
            writer.startElement("tbody", (UIComponent)table);
            writer.startElement("tr", (UIComponent)table);
            state.startIterate();
            while (state.hasNextPart()) {
                writer.startElement("td", (UIComponent)table);
                writer.startElement("div", (UIComponent)table);
                PartName partName = state.nextPart().getName();
                if (PartName.normal.equals((Object)partName)) {
                    writer.writeAttribute("id", (Object)(table.getClientId(context) + ":body"), null);
                    writer.writeAttribute("class", (Object)"rf-edt-cnt", null);
                }
                String targetId = table.getClientId(context) + ":tbt" + partName.name().charAt(0);
                writer.startElement("table", (UIComponent)table);
                writer.writeAttribute("id", (Object)targetId, null);
                writer.writeAttribute("cellpadding", (Object)"0", null);
                writer.writeAttribute("cellspacing", (Object)"0", null);
                writer.startElement("tbody", (UIComponent)table);
                writer.writeAttribute("id", (Object)(table.getClientId(context) + ":tb" + partName.toString().charAt(0)), null);
                this.encodeRows(context, state);
                writer.endElement("tbody");
                writer.endElement("table");
                writer.endElement("div");
                writer.endElement("td");
            }
            writer.endElement("tr");
            writer.endElement("tbody");
            writer.endElement("table");
            writer.endElement("div");
        }
        writer.endElement("div");
        encoderVariance.encodeEndUpdate(context);
    }

    public void encodeFooter(RendererState state) throws IOException {
        FacesContext context = state.getContext();
        ResponseWriter writer = context.getResponseWriter();
        UIDataTableBase table = state.getRow();
        this.encodeHeaderOrFooter(state, "footer");
        UIComponent footer = table.getFacet("footer");
        if (footer != null && footer.isRendered()) {
            String elementId = table.getClientId(context) + ":tff";
            EncoderVariance encoderVariance = state.getEncoderVariance();
            encoderVariance.encodeStartUpdate(context, elementId);
            writer.startElement("div", (UIComponent)table);
            writer.writeAttribute("id", (Object)elementId, null);
            writer.writeAttribute("class", (Object)"rf-edt-tbl-ftr", null);
            footer.encodeAll(context);
            writer.endElement("div");
            encoderVariance.encodeEndUpdate(context);
        }
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractExtendedDataTable.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) throws IOException {
        block18: {
            AbstractExtendedDataTable table = (AbstractExtendedDataTable)component;
            if ("scroll".equals(metaComponentId)) {
                final PartialResponseWriter writer = context.getPartialViewContext().getPartialResponseWriter();
                int clientFirst = table.getClientFirst();
                Integer oldClientFirst = (Integer)table.getAttributes().remove("oldClientFirst");
                if (oldClientFirst == null) {
                    oldClientFirst = clientFirst;
                }
                int clientRows = ((SequenceRange)table.getComponentState().getRange()).getRows();
                int difference = clientFirst - oldClientFirst;
                SequenceRange addRange = null;
                SequenceRange removeRange = null;
                if (Math.abs(difference) >= clientRows) {
                    difference = 0;
                    addRange = new SequenceRange(clientFirst, clientRows);
                    removeRange = new SequenceRange(oldClientFirst.intValue(), clientRows);
                } else if (difference < 0) {
                    addRange = new SequenceRange(clientFirst += table.getFirst(), -difference);
                    removeRange = new SequenceRange(clientFirst + clientRows, -difference);
                } else if (difference > 0) {
                    oldClientFirst = oldClientFirst + table.getFirst();
                    removeRange = new SequenceRange(oldClientFirst.intValue(), difference);
                    int last = oldClientFirst + clientRows;
                    addRange = new SequenceRange(last, difference);
                }
                if (addRange != null) {
                    Object key = table.getRowKey();
                    table.captureOrigValue(context);
                    table.setRowKey(context, null);
                    final RendererState state = this.createRowHolder(context, (UIComponent)table, null);
                    state.startIterate();
                    while (state.hasNextPart()) {
                        char partNameFirstChar = state.nextPart().getName().toString().charAt(0);
                        final LinkedList ids = new LinkedList();
                        table.walk(context, new DataVisitor(){

                            public DataVisitResult process(FacesContext context, Object rowKey, Object argument) {
                                UIDataTableBase dataTable = state.getRow();
                                dataTable.setRowKey(context, rowKey);
                                ids.add(dataTable.getClientId(context) + ":" + state.getPart().getName().toString().charAt(0));
                                return DataVisitResult.CONTINUE;
                            }
                        }, (Range)removeRange, null);
                        table.walk(context, new DataVisitor(){

                            public DataVisitResult process(FacesContext context, Object rowKey, Object argument) {
                                UIDataTableBase dataTable = state.getRow();
                                dataTable.setRowKey(context, rowKey);
                                HashMap<String, String> attributes = new HashMap<String, String>(1);
                                String id = dataTable.getClientId(context) + ":" + state.getPart().getName().toString().charAt(0);
                                attributes.put("id", id);
                                try {
                                    writer.updateAttributes((String)ids.remove(0), attributes);
                                    writer.startUpdate(id);
                                    ExtendedDataTableRenderer.this.encodeRow((ResponseWriter)writer, context, state);
                                    writer.endUpdate();
                                }
                                catch (IOException e) {
                                    throw new FacesException((Throwable)e);
                                }
                                return DataVisitResult.CONTINUE;
                            }
                        }, (Range)addRange, null);
                        writer.startEval();
                        if (difference < 0) {
                            difference += clientRows;
                        }
                        writer.write("var richTBody = document.getElementById('" + component.getClientId(context) + ":tb" + partNameFirstChar + "');");
                        writer.write("var richRows = richTBody.rows;");
                        writer.write("for (var i = 0; i < " + difference + "; i++ ) richTBody.appendChild(richTBody.removeChild(richRows[0]));");
                        writer.endEval();
                    }
                    writer.startUpdate(component.getClientId(context) + ":si");
                    this.encodeSelectionInput((ResponseWriter)writer, context, component);
                    writer.endUpdate();
                    writer.startEval();
                    writer.write("jQuery('#" + component.getClientId(context).replace(":", "\\\\:") + "').triggerHandler('rich:onajaxcomplete', {first: " + table.getClientFirst() + "});");
                    writer.endEval();
                    table.setRowKey(context, key);
                    table.restoreOrigValue(context);
                }
            } else {
                ResponseWriter initialWriter = context.getResponseWriter();
                assert (!(initialWriter instanceof OnOffResponseWriter));
                try {
                    context.setResponseWriter((ResponseWriter)new OnOffResponseWriter(initialWriter));
                    RendererState state = this.createRowHolder(context, component, null);
                    state.setEncoderVariance(EncoderVariance.partial);
                    PartialResponseWriter writer = context.getPartialViewContext().getPartialResponseWriter();
                    if ("header".equals(metaComponentId)) {
                        this.encodeHeader(state);
                        writer.startEval();
                        writer.write("jQuery('#" + component.getClientId(context).replace(":", "\\\\:") + "').triggerHandler('rich:onajaxcomplete', {reinitializeHeader: true});");
                        writer.endEval();
                        break block18;
                    }
                    if ("footer".equals(metaComponentId)) {
                        this.encodeFooter(state);
                        break block18;
                    }
                    if ("body".equals(metaComponentId)) {
                        this.encodeBody(state);
                        writer.startUpdate(component.getClientId(context) + ":si");
                        this.encodeSelectionInput((ResponseWriter)writer, context, component);
                        writer.endUpdate();
                        writer.startEval();
                        writer.write("jQuery('#" + component.getClientId(context).replace(":", "\\\\:") + "').triggerHandler('rich:onajaxcomplete', {first: " + table.getClientFirst() + ", rowCount: " + this.getRowCount(component) + ", reinitializeBody: true});");
                        writer.endEval();
                        break block18;
                    }
                    throw new IllegalArgumentException("Unsupported metaComponentIdentifier: " + metaComponentId);
                }
                finally {
                    context.setResponseWriter(initialWriter);
                }
            }
        }
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        Map attributes = component.getAttributes();
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)component.getClientId(context), null);
        writer.writeAttribute("class", (Object)HtmlUtil.concatClasses("rf-edt", (String)attributes.get("styleClass")), null);
        this.getUtils().writeAttribute(writer, "style", attributes.get("style"));
    }

    @Override
    public RendererState createRowHolder(FacesContext context, UIComponent component, Object[] options) {
        return new RendererState(context, (UIDataTableBase)component);
    }

    @Override
    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIDataTableBase table = (UIDataTableBase)component;
        Object key = table.getRowKey();
        table.captureOrigValue(context);
        table.setRowKey(context, null);
        RendererState state = this.createRowHolder(context, (UIComponent)table, null);
        this.encodeStyle(state);
        this.encodeHeader(state);
        this.encodeBody(state);
        this.encodeFooter(state);
        table.setRowKey(context, key);
        table.restoreOrigValue(context);
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.startElement("table", component);
        writer.writeAttribute("id", (Object)(component.getClientId(context) + ":r"), null);
        writer.writeAttribute("class", (Object)"rf-edt-rord", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.startElement("tr", component);
        writer.startElement("th", component);
        writer.write("&#160;");
        writer.endElement("th");
        writer.endElement("tr");
        for (int i = 0; i < 6; ++i) {
            writer.startElement("tr", component);
            writer.startElement("td", component);
            writer.write("&#160;");
            writer.endElement("td");
            writer.endElement("tr");
        }
        writer.endElement("table");
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)(component.getClientId(context) + ":d"), null);
        writer.writeAttribute("class", (Object)"rf-edt-rsz-mkr", null);
        writer.endElement("div");
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)(component.getClientId(context) + ":rm"), null);
        writer.writeAttribute("class", (Object)"rf-edt-rord-mkr", null);
        writer.endElement("div");
        writer.startElement("input", component);
        writer.writeAttribute("id", (Object)(component.getClientId(context) + ":wi"), null);
        writer.writeAttribute("name", (Object)(component.getClientId(context) + ":wi"), null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.endElement("input");
        this.encodeSelectionInput(writer, context, component);
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction(context, component, "RichFaces.ajax");
        AjaxEventOptions eventOptions = AjaxRendererUtils.buildEventOptions(context, component);
        Map<String, Object> parameters = eventOptions.getParameters();
        eventOptions.set("parameters", new JSReference("parameters"));
        ajaxFunction.addParameter((Object)eventOptions);
        Map attributes = component.getAttributes();
        HashMap<String, Object> options = new HashMap<String, Object>();
        RendererUtils utils = this.getUtils();
        utils.addToScriptHash(options, "parameters", parameters);
        utils.addToScriptHash(options, "selectionMode", attributes.get("selectionMode"), SelectionMode.multiple.toString());
        utils.addToScriptHash(options, "onbeforeselectionchange", RenderKitUtils.getAttributeAndBehaviorsValue(context, component, EVENT_ATTRIBUTES.get("onbeforeselectionchange")), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
        utils.addToScriptHash(options, "onselectionchange", RenderKitUtils.getAttributeAndBehaviorsValue(context, component, EVENT_ATTRIBUTES.get("onselectionchange")), null, RendererUtils.ScriptHashVariableWrapper.EVENT_HANDLER);
        StringBuilder builder = new StringBuilder("new RichFaces.ExtendedDataTable('");
        builder.append(component.getClientId(context)).append("', ").append(this.getRowCount(component)).append(", function(event, parameters) {").append(ajaxFunction.toScript()).append(";}");
        if (!options.isEmpty()) {
            builder.append(",").append(ScriptUtils.toScript(options));
        }
        builder.append(");");
        utils.writeScript(context, component, builder.toString());
        writer.endElement("div");
    }

    private int getRowCount(UIComponent component) {
        UIDataTableBase table = (UIDataTableBase)component;
        int rows = table.getRows();
        int rowCount = table.getRowCount() - table.getFirst();
        rows = rows > 0 ? Math.min(rows, rowCount) : rowCount;
        return rows;
    }

    private void encodeStyle(RendererState state) throws IOException {
        FacesContext context = state.getContext();
        ResponseWriter writer = context.getResponseWriter();
        UIDataTableBase table = state.getRow();
        writer.startElement("style", (UIComponent)table);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.writeText((Object)"div.rf-edt-cnt {", null);
        writer.writeText((Object)"width: 100%;", "width");
        writer.writeText((Object)"}", null);
        Iterator<UIComponent> columns = table.columns();
        while (columns.hasNext()) {
            UIComponent column = columns.next();
            String id = column.getId();
            if (id == null) {
                column.getClientId(context);
                id = column.getId();
            }
            String width = this.getColumnWidth(column);
            writer.writeText((Object)(".rf-edt-c-" + id + " {"), "width");
            writer.writeText((Object)("width: " + width + ";"), "width");
            writer.writeText((Object)"}", "width");
        }
        writer.endElement("style");
    }

    @Override
    public void encodeRow(ResponseWriter writer, FacesContext facesContext, RowHolderBase rowHolder) throws IOException {
        RendererState state = (RendererState)rowHolder;
        UIDataTableBase table = state.getRow();
        writer.startElement("tr", (UIComponent)table);
        StringBuilder builder = new StringBuilder();
        Collection<Object> selection = table.getSelection();
        if (selection != null && selection.contains(table.getRowKey())) {
            builder.append("rf-edt-r-sel");
        }
        if (table.getRowKey().equals(table.getAttributes().get("activeRowKey"))) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append("rf-edt-r-act");
        }
        if (table.getRowKey().equals(table.getAttributes().get("shiftRowKey"))) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append("rf-edt-r-sht");
        }
        if (builder.length() > 0) {
            writer.writeAttribute("class", (Object)builder.toString(), null);
        }
        Iterator<UIComponent> columns = null;
        Part part = state.getPart();
        writer.writeAttribute("id", (Object)(table.getClientId(facesContext) + ":" + part.getName().toString().charAt(0)), null);
        for (UIComponent column : part.getColumns()) {
            if (!column.isRendered()) continue;
            writer.startElement("td", (UIComponent)table);
            writer.startElement("div", (UIComponent)table);
            writer.writeAttribute("class", (Object)("rf-edt-c rf-edt-c-" + column.getId()), null);
            writer.startElement("div", column);
            writer.writeAttribute("class", (Object)"rf-edt-c-cnt", null);
            this.renderChildren(facesContext, column);
            writer.endElement("div");
            writer.endElement("div");
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        Map map = context.getExternalContext().getRequestParameterMap();
        this.updateWidthOfColumns(context, component, (String)map.get(component.getClientId(context) + ":wi"));
        if (map.get(component.getClientId(context)) != null) {
            this.updateColumnsOrder(context, component, (String)map.get("rich:columnsOrder"));
        }
        if (map.get(component.getClientId(context)) != null) {
            this.updateClientFirst(context, component, (String)map.get("rich:clientFirst"));
        }
        this.decodeSortingFiltering(context, component);
    }

    private void updateWidthOfColumns(FacesContext context, UIComponent component, String widthString) {
        if (widthString != null && widthString.length() > 0) {
            String[] widthArray = widthString.split(",");
            for (int i = 0; i < widthArray.length; ++i) {
                String[] widthEntry = widthArray[i].split(":");
                UIComponent column = component.findComponent(widthEntry[0]);
                this.updateAttribute(context, column, "width", widthEntry[1]);
            }
        }
    }

    private void updateColumnsOrder(FacesContext context, UIComponent component, String columnsOrderString) {
        if (columnsOrderString != null && columnsOrderString.length() > 0) {
            String[] columnsOrder = columnsOrderString.split(",");
            this.updateAttribute(context, component, "columnsOrder", columnsOrder);
            context.getPartialViewContext().getRenderIds().add(component.getClientId(context));
        }
    }

    private void updateClientFirst(FacesContext context, UIComponent component, String clientFirst) {
        Map attributes;
        Integer value;
        if (clientFirst != null && clientFirst.length() > 0 && !(value = Integer.valueOf(clientFirst)).equals((attributes = component.getAttributes()).get("clientFirst"))) {
            attributes.put("submittedClientFirst", value);
            context.getPartialViewContext().getRenderIds().add(component.getClientId(context) + "@" + "scroll");
        }
    }

    private String getColumnWidth(UIComponent column) {
        String width = (String)column.getAttributes().get("width");
        if (width == null || width.length() == 0 || width.indexOf("%") != -1) {
            width = "100px";
        }
        return width;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EncoderVariance {
        full{

            public void encodeStartUpdate(FacesContext context, String targetId) throws IOException {
            }

            public void encodeEndUpdate(FacesContext context) throws IOException {
            }
        }
        ,
        partial{

            private void switchResponseWriter(FacesContext context, boolean writerState) {
                ResponseWriter writer = context.getResponseWriter();
                ((OnOffResponseWriter)writer).setSwitchedOn(writerState);
            }

            public void encodeStartUpdate(FacesContext context, String targetId) throws IOException {
                this.switchResponseWriter(context, true);
                context.getPartialViewContext().getPartialResponseWriter().startUpdate(targetId);
            }

            public void encodeEndUpdate(FacesContext context) throws IOException {
                context.getPartialViewContext().getPartialResponseWriter().endUpdate();
                this.switchResponseWriter(context, false);
            }
        };


        public abstract void encodeStartUpdate(FacesContext var1, String var2) throws IOException;

        public abstract void encodeEndUpdate(FacesContext var1) throws IOException;
    }

    private class RendererState
    extends RowHolderBase {
        private UIDataTableBase table;
        private List<Part> parts;
        private Part current;
        private Iterator<Part> partIterator;
        private EncoderVariance encoderVariance;

        public RendererState(FacesContext context, UIDataTableBase table) {
            super(context);
            this.encoderVariance = EncoderVariance.full;
            this.table = table;
            List<UIComponent> columns = new ArrayList<Object>();
            Iterator<Object> iterator = table.columns();
            LinkedHashMap<String, UIComponent> columnsMap = new LinkedHashMap<String, UIComponent>();
            while (iterator.hasNext()) {
                UIComponent component = iterator.next();
                if (!component.isRendered()) continue;
                columnsMap.put(component.getId(), component);
            }
            String[] columnsOrder = (String[])table.getAttributes().get("columnsOrder");
            if (columnsOrder != null && columnsOrder.length > 0) {
                for (int i = 0; i < columnsOrder.length && !columnsMap.isEmpty(); ++i) {
                    columns.add((UIComponent)columnsMap.remove(columnsOrder[i]));
                }
            }
            iterator = columnsMap.values().iterator();
            while (iterator.hasNext()) {
                columns.add((UIComponent)iterator.next());
            }
            int count = Math.min((Integer)table.getAttributes().get("frozenColumns"), columns.size());
            List<UIComponent> frozenColumns = columns.subList(0, count);
            columns = columns.subList(count, columns.size());
            this.parts = new ArrayList<Part>(PartName.values().length);
            if (frozenColumns.size() > 0) {
                this.parts.add(new Part(PartName.frozen, frozenColumns));
            }
            if (columns.size() > 0) {
                this.parts.add(new Part(PartName.normal, columns));
            }
        }

        public UIDataTableBase getRow() {
            return this.table;
        }

        public void startIterate() {
            this.partIterator = this.parts.iterator();
        }

        public Part nextPart() {
            this.current = this.partIterator.next();
            return this.current;
        }

        public Part getPart() {
            return this.current;
        }

        public boolean hasNextPart() {
            return this.partIterator.hasNext();
        }

        public EncoderVariance getEncoderVariance() {
            return this.encoderVariance;
        }

        public void setEncoderVariance(EncoderVariance encoderVariance) {
            this.encoderVariance = encoderVariance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Part {
        private PartName name;
        private List<UIComponent> columns;

        public Part(PartName name, List<UIComponent> columns) {
            this.name = name;
            this.columns = columns;
        }

        public PartName getName() {
            return this.name;
        }

        public List<UIComponent> getColumns() {
            return this.columns;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PartName {
        frozen,
        normal;

    }
}

