/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.richfaces.component.AbstractInplaceInput;
import org.richfaces.component.InplaceState;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.ComponentAttribute;
import org.richfaces.renderkit.InputRendererBase;
import org.richfaces.renderkit.RenderKitUtils;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="base-component.reslib"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="inplaceInput.js"), @ResourceDependency(library="org.richfaces", name="inplaceInput.ecss")})
public class InplaceInputBaseRenderer
extends InputRendererBase {
    public static final String OPTIONS_EDIT_EVENT = "editEvent";
    public static final String OPTIONS_EDIT_CONTAINER = "editContainer";
    public static final String OPTIONS_INPUT = "input";
    public static final String OPTIONS_FOCUS = "focusElement";
    public static final String OPTIONS_BUTTON_OK = "okbtn";
    public static final String OPTIONS_LABEL = "label";
    public static final String OPTIONS_DEFAULT_LABEL = "defaultLabel";
    public static final String OPTIONS_BUTTON_CANCEL = "cancelbtn";
    public static final String OPTIONS_SHOWCONTROLS = "showControls";
    public static final String OPTIONS_NONE_CSS = "noneCss";
    public static final String OPTIONS_CHANGED_CSS = "changedCss";
    public static final String OPTIONS_INITIAL_VALUE = "initialValue";
    private static final String READY_STATE_CSS = "rf-ii-ready-st";
    private static final String EDIT_STATE_CSS = "rf-ii-edt-st";
    private static final String CHANGED_STATE_CSS = "rf-ii-chd-st";
    private static final String NONE_CSS = "rf-ii-none";
    private static final Map<String, ComponentAttribute> INPLACEINPUT_HANDLER_ATTRIBUTES = Collections.unmodifiableMap(ComponentAttribute.createMap(new ComponentAttribute("onclick").setEventNames("inputClick").setComponentAttributeName("onInputClick"), new ComponentAttribute("ondblclick").setEventNames("inputDblclick").setComponentAttributeName("onInputDblclick"), new ComponentAttribute("onmousedown").setEventNames("inputMousedown").setComponentAttributeName("onInputMousedown"), new ComponentAttribute("onmouseup").setEventNames("inputMouseup").setComponentAttributeName("onInputMouseup"), new ComponentAttribute("onmouseover").setEventNames("inputMouseover").setComponentAttributeName("onInputMouseover"), new ComponentAttribute("onmousemove").setEventNames("inputMousemove").setComponentAttributeName("onInputMousemove"), new ComponentAttribute("onmouseout").setEventNames("inputMouseout").setComponentAttributeName("onInputMouseout"), new ComponentAttribute("onkeypress").setEventNames("inputKeypress").setComponentAttributeName("onInputKeypress"), new ComponentAttribute("onkeydown").setEventNames("inputKeydown").setComponentAttributeName("onInputKeydown"), new ComponentAttribute("onkeyup").setEventNames("inputKeyup").setComponentAttributeName("onInputKeyup"), new ComponentAttribute("onblur").setEventNames("inputBlur").setComponentAttributeName("onInputBlur"), new ComponentAttribute("onfocus").setEventNames("inputFocus").setComponentAttributeName("onInputFocus"), new ComponentAttribute("onchange").setEventNames("change").setComponentAttributeName("onchange"), new ComponentAttribute("onselect").setEventNames("select").setComponentAttributeName("onselect")));

    protected void renderInputHandlers(FacesContext facesContext, UIComponent component) throws IOException {
        RenderKitUtils.renderPassThroughAttributesOptimized(facesContext, component, INPLACEINPUT_HANDLER_ATTRIBUTES);
    }

    public InplaceState getInplaceState(UIComponent component) {
        return ((AbstractInplaceInput)component).getState();
    }

    public String getValue(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractInplaceInput inplaceInput = (AbstractInplaceInput)component;
        String value = this.getInputValue(facesContext, (UIComponent)inplaceInput);
        if (value == null || "".equals(value)) {
            value = inplaceInput.getDefaultLabel();
        }
        return value;
    }

    public String getResourcePath(FacesContext context, String resourceName) {
        if (resourceName != null) {
            ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
            Resource resource = resourceHandler.createResource(resourceName);
            return resource.getRequestPath();
        }
        return null;
    }

    public String getReadyStyleClass(UIComponent component, InplaceState inplaceState) {
        return InplaceState.changed != inplaceState ? READY_STATE_CSS : HtmlUtil.concatClasses(READY_STATE_CSS, CHANGED_STATE_CSS);
    }

    public String getEditStyleClass(UIComponent component, InplaceState inplaceState) {
        return InplaceState.edit != inplaceState ? HtmlUtil.concatClasses(EDIT_STATE_CSS, NONE_CSS) : EDIT_STATE_CSS;
    }

    public String getReadyClientId(FacesContext facesContext, UIComponent component, InplaceState inplaceState) {
        String clientId = component.getClientId(facesContext);
        return this.getId(clientId, InplaceState.ready, inplaceState);
    }

    public String getChangedClientId(FacesContext facesContext, UIComponent component, InplaceState inplaceState) {
        String clientId = component.getClientId(facesContext);
        return this.getId(clientId, InplaceState.changed, inplaceState);
    }

    private String getId(String clientId, InplaceState expect, InplaceState current) {
        String result = clientId;
        if (expect != current) {
            result = clientId + ":" + expect;
        }
        return result;
    }

    public void buildScript(ResponseWriter writer, FacesContext facesContext, UIComponent component) throws IOException {
        AbstractInplaceInput inplaceInput = (AbstractInplaceInput)component;
        JSFunction function = new JSFunction("new RichFaces.ui.InplaceInput", new Object[0]);
        function.addParameter((Object)inplaceInput.getClientId(facesContext));
        String clientId = inplaceInput.getClientId(facesContext);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(OPTIONS_EDIT_EVENT, inplaceInput.getEditEvent());
        options.put(OPTIONS_NONE_CSS, NONE_CSS);
        options.put(OPTIONS_CHANGED_CSS, CHANGED_STATE_CSS);
        options.put(OPTIONS_EDIT_CONTAINER, clientId + ":edit");
        options.put(OPTIONS_INPUT, clientId + ":input");
        options.put(OPTIONS_LABEL, clientId + ":label");
        options.put(OPTIONS_FOCUS, clientId + ":focus");
        options.put(OPTIONS_DEFAULT_LABEL, inplaceInput.getDefaultLabel());
        boolean showControls = inplaceInput.isShowControls();
        options.put(OPTIONS_SHOWCONTROLS, showControls);
        if (showControls) {
            options.put(OPTIONS_BUTTON_OK, clientId + ":okbtn");
            options.put(OPTIONS_BUTTON_CANCEL, clientId + ":cancelbtn");
        }
        function.addParameter(options);
        writer.write(function.toString());
    }
}

