/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import org.ajax4jsf.javascript.JSFunction;
import org.richfaces.component.AbstractDataTable;
import org.richfaces.component.AbstractSubTable;
import org.richfaces.component.Row;
import org.richfaces.component.UIDataTableBase;
import org.richfaces.event.ToggleEvent;
import org.richfaces.renderkit.AbstractTableRenderer;
import org.richfaces.renderkit.EncodeStrategy;
import org.richfaces.renderkit.RowHolder;
import org.richfaces.renderkit.RowHolderBase;
import org.richfaces.renderkit.util.AjaxRendererUtils;

@ResourceDependencies(value={@ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="subtable.js")})
public class SubTableRenderer
extends AbstractTableRenderer {
    public static final String TB_ROW = ":c";
    private static final String STATE = ":state";
    private static final String OPTIONS = ":options";
    private static final String DISPLAY_NONE = "display: none;";

    protected void doDecode(FacesContext facesContext, UIComponent component) {
        AbstractSubTable subTable = (AbstractSubTable)component;
        String clientId = subTable.getClientId(facesContext);
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        String optionsId = clientId + OPTIONS;
        String togglerId = (String)requestMap.get(optionsId);
        String stateId = clientId + STATE;
        String state = (String)requestMap.get(stateId);
        boolean isExpand = true;
        if (state != null) {
            int newValue = Integer.parseInt(state);
            if (newValue < 1) {
                isExpand = false;
            }
            if (subTable.isExpanded() != isExpand) {
                new ToggleEvent((UIComponent)subTable, isExpand, togglerId).queue();
            }
        }
    }

    public void encodeFirstRowStart(ResponseWriter writer, FacesContext context, String parentId, int currentRow, UIComponent component) throws IOException {
        writer.startElement("tr", component);
        writer.writeAttribute("id", (Object)(parentId + ":" + currentRow + ":b"), null);
        String styleClass = this.getFirstRowClass(context, parentId);
        this.encodeStyleClass(writer, context, component, "styleClass", styleClass);
    }

    public void encodeRowStart(ResponseWriter writer, FacesContext context, String parentId, int currentRow, UIComponent component) throws IOException {
        writer.startElement("tr", component);
        writer.writeAttribute("id", (Object)(parentId + ":" + currentRow + ":b"), null);
        String styleClass = this.getRowClass(context, parentId);
        this.encodeStyleClass(writer, context, component, "styleClass", styleClass);
    }

    public void encodeTableFacets(ResponseWriter writer, FacesContext context, UIDataTableBase dataTable) throws IOException {
        AbstractSubTable subTable = (AbstractSubTable)dataTable;
        this.encodeHeaderFacet(writer, context, subTable, false);
        String rowClass = this.getRowSkinClass();
        String cellClass = this.getCellSkinClass();
        String firstClass = this.getFirstRowSkinClass();
        rowClass = this.mergeStyleClasses("rowClass", rowClass, (UIComponent)subTable);
        cellClass = this.mergeStyleClasses("cellClass", cellClass, (UIComponent)subTable);
        firstClass = this.mergeStyleClasses("firstRowClass", firstClass, (UIComponent)subTable);
        this.saveRowStyles(context, subTable.getClientId(context), firstClass, rowClass, cellClass);
    }

    public void encodeTableBodyStart(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase) throws IOException {
        AbstractSubTable subTable = (AbstractSubTable)dataTableBase;
        UIDataTableBase component = this.findParent(subTable);
        if (component instanceof AbstractDataTable) {
            writer.startElement("tbody", null);
            writer.writeAttribute("id", (Object)(component.getRelativeClientId(facesContext) + ":" + subTable.getId() + TB_ROW), null);
            writer.writeAttribute("class", (Object)this.getTableSkinClass(), null);
            String predefinedStyles = !subTable.isExpanded() ? DISPLAY_NONE : null;
            this.encodeStyle(writer, facesContext, (UIComponent)subTable, predefinedStyles);
        }
    }

    public void encodeBeforeRows(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase, boolean encodeParentTBody, boolean partialUpdate) throws IOException {
        AbstractSubTable subTable = (AbstractSubTable)dataTableBase;
        this.encodeTableBodyStart(writer, facesContext, subTable);
        this.encodeSubTableDomElement(writer, facesContext, subTable);
        this.setupTableStartElement(facesContext, (UIComponent)subTable);
        this.encodeHeaderFacet(writer, facesContext, subTable, false);
    }

    private void encodeSubTableDomElement(ResponseWriter writer, FacesContext facesContext, AbstractSubTable subTable) throws IOException {
        writer.startElement("tr", (UIComponent)subTable);
        writer.writeAttribute("style", (Object)DISPLAY_NONE, null);
        writer.writeAttribute("id", (Object)subTable.getClientId(facesContext), null);
        writer.startElement("td", (UIComponent)subTable);
        writer.endElement("td");
        writer.endElement("tr");
    }

    public void encodeRow(ResponseWriter writer, FacesContext facesContext, RowHolderBase holder) throws IOException {
        RowHolder rowHolder = (RowHolder)holder;
        Row row = rowHolder.getRow();
        rowHolder.setRowStart(true);
        Iterator components = row.columns();
        if (rowHolder.isUpdatePartial()) {
            this.partialStart(facesContext, ((AbstractSubTable)row).getRelativeClientId(facesContext) + ":b");
        }
        while (components.hasNext()) {
            UIComponent component = (UIComponent)components.next();
            if (!component.isRendered()) continue;
            if (component instanceof UIColumn) {
                this.encodeColumn(facesContext, writer, (UIColumn)component, rowHolder);
                continue;
            }
            if (!(component instanceof AbstractSubTable)) continue;
            if (component.isRendered()) {
                this.encodeRowEnd(writer);
            }
            component.encodeAll(facesContext);
            rowHolder.setRowStart(true);
        }
        this.encodeRowEnd(writer);
        if (rowHolder.isUpdatePartial()) {
            this.partialEnd(facesContext);
        }
    }

    public void encodeAfterRows(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase, boolean encodeParentTBody, boolean partialUpdate) throws IOException {
        AbstractSubTable subTable = (AbstractSubTable)dataTableBase;
        this.encodeFooterFacet(writer, facesContext, subTable, false);
    }

    public boolean encodeParentTBody(UIDataTableBase dataTableBase) {
        UIDataTableBase parent = this.findParent((AbstractSubTable)dataTableBase);
        return parent instanceof AbstractDataTable;
    }

    public void encodeHiddenInput(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase) throws IOException {
        AbstractSubTable subTable = (AbstractSubTable)dataTableBase;
        String stateId = subTable.getClientId(facesContext) + STATE;
        writer.startElement("input", (UIComponent)subTable);
        writer.writeAttribute("id", (Object)stateId, null);
        writer.writeAttribute("name", (Object)stateId, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        int state = subTable.isExpanded() ? 1 : 0;
        writer.writeAttribute("value", (Object)state, null);
        writer.endElement("input");
        String optionsId = subTable.getClientId(facesContext) + OPTIONS;
        writer.startElement("input", (UIComponent)subTable);
        writer.writeAttribute("id", (Object)optionsId, null);
        writer.writeAttribute("name", (Object)optionsId, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.endElement("input");
    }

    public boolean containsThead() {
        return false;
    }

    public EncodeStrategy getHeaderEncodeStrategy(UIComponent column, String tableFacetName) {
        return new AbstractTableRenderer.SimpleHeaderEncodeStrategy(this);
    }

    public void encodeClientScript(ResponseWriter writer, FacesContext facesContext, UIDataTableBase component) throws IOException {
        AbstractSubTable subTable = (AbstractSubTable)component;
        String id = subTable.getClientId(facesContext);
        UIComponent nestingForm = this.getUtils().getNestingForm(facesContext, (UIComponent)subTable);
        String formId = nestingForm != null ? nestingForm.getClientId(facesContext) : "";
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("stateInput", subTable.getClientId(facesContext) + STATE);
        options.put("optionsInput", subTable.getClientId(facesContext) + OPTIONS);
        options.put("expandMode", subTable.getExpandMode());
        options.put("eventOptions", (Object)AjaxRendererUtils.buildEventOptions(facesContext, (UIComponent)subTable));
        JSFunction jsFunction = new JSFunction("new RichFaces.ui.SubTable", new Object[0]);
        jsFunction.addParameter((Object)id);
        jsFunction.addParameter((Object)formId);
        jsFunction.addParameter(options);
        writer.startElement("script", (UIComponent)subTable);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)jsFunction.toScript(), null);
        writer.endElement("script");
    }

    public String getTableSkinClass() {
        return "rf-st";
    }

    public String getRowSkinClass() {
        return "rf-st-r";
    }

    public String getFirstRowSkinClass() {
        return "rf-st-fst-r";
    }

    public String getHeaderRowSkinClass() {
        return "rf-st-hdr-r";
    }

    public String getHeaderFirstRowSkinClass() {
        return "rf-st-hdr-fst-r";
    }

    public String getCellSkinClass() {
        return "rf-st-c";
    }

    public String getHeaderCellSkinClass() {
        return "rf-st-hdr-c";
    }

    public String getColumnHeaderCellSkinClass() {
        return "rf-st-shdr-c";
    }

    public String getColumnHeaderSkinClass() {
        return "rf-st-shdr";
    }

    public String getFooterSkinClass() {
        return "rf-st-ftr";
    }

    public String getFooterCellSkinClass() {
        return "rf-st-ftr-c";
    }

    public String getFooterFirstRowSkinClass() {
        return "rf-st-ftr-fst";
    }

    public String getColumnFooterCellSkinClass() {
        return "rf-st-sftr-c";
    }

    public String getColumnFooterSkinClass() {
        return "rf-st-sftr";
    }

    public String getColumnFooterFirstSkinClass() {
        return "rf-st-sftr-fst";
    }

    public String getColumnHeaderFirstSkinClass() {
        return "rf-st-shdr-fst";
    }

    public String getFooterFirstSkinClass() {
        return "rf-st-ftr-fst";
    }

    public String getHeaderFirstSkinClass() {
        return "rf-st-hdr-fst";
    }

    public String getHeaderSkinClass() {
        return "rf-st-hdr";
    }

    public String getNoDataClass() {
        return "rf-st-nd-c";
    }

    public void encodeMetaComponent(FacesContext facesContext, UIComponent component, String metaComponentId) throws IOException {
        AbstractSubTable subTable = (AbstractSubTable)component;
        this.setupTableStartElement(facesContext, (UIComponent)subTable);
        if ("body".equals(metaComponentId)) {
            ResponseWriter writer = facesContext.getResponseWriter();
            UIDataTableBase dataTableBase = this.findParent(subTable);
            String updateId = dataTableBase.getRelativeClientId(facesContext) + ":" + subTable.getId() + TB_ROW;
            this.partialStart(facesContext, updateId);
            this.encodeTableRows(writer, facesContext, subTable, false);
            this.partialEnd(facesContext);
        }
    }

    public EncodeStrategy getHiddenContainerStrategy(UIDataTableBase dataTableBase) {
        return new SubTableHiddenEncodeStrategy();
    }

    protected void setupTableStartElement(FacesContext context, UIComponent component) {
        this.setupTableStartElement(context, component, "td");
    }

    protected UIDataTableBase findParent(AbstractSubTable subTable) {
        UIComponent parent;
        for (parent = subTable.getParent(); parent != null && !(parent instanceof UIDataTableBase); parent = parent.getParent()) {
        }
        if (parent == null) {
            throw new AbortProcessingException("UISubTable should be a child of UIDataTable or UISubTable");
        }
        return (UIDataTableBase)parent;
    }

    private class SubTableHiddenEncodeStrategy
    implements EncodeStrategy {
        private SubTableHiddenEncodeStrategy() {
        }

        public void begin(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
            AbstractSubTable subTable = (AbstractSubTable)component;
            writer.startElement("tr", (UIComponent)subTable);
            writer.writeAttribute("id", (Object)(subTable.getClientId(context) + ":sc"), null);
            writer.writeAttribute("style", (Object)SubTableRenderer.DISPLAY_NONE, null);
            writer.startElement("td", (UIComponent)subTable);
        }

        public void end(ResponseWriter writer, FacesContext context, UIComponent component, Object[] params) throws IOException {
            boolean endTbody;
            writer.endElement("td");
            writer.endElement("tr");
            if (params != null && params.length == 1 && (endTbody = ((Boolean)params[0]).booleanValue())) {
                SubTableRenderer.this.encodeTableBodyEnd(writer);
            }
        }
    }
}

