/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.HashMap;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.richfaces.component.AbstractSubTable;
import org.richfaces.component.AbstractSubTableToggleControl;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.renderkit.util.RendererUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="subtable-toggler.js")})
public class SubTableToggleControlRendererBase
extends RendererBase {
    private static final RendererUtils RENDERER_UTILS = RendererUtils.getInstance();
    private static final String DISPLAY_NONE = "display: none;";
    private static final String UP_ICON_URL = "org.richfaces/up_icon.gif";
    private static final String DOWN_ICON_URL = "org.richfaces/down_icon.gif";
    private static final String EXPAND_STATE = "expand";
    private static final String COLLAPSE_STATE = "collapse";

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        context.getPartialViewContext().getRenderIds().add(component.getClientId(context));
    }

    protected void encodeControl(FacesContext context, UIComponent component) throws IOException {
        AbstractSubTableToggleControl toggleControl = (AbstractSubTableToggleControl)component;
        AbstractSubTable subTable = this.findComponent(context, toggleControl);
        if (subTable != null) {
            String switchType = subTable.getExpandMode();
            boolean expanded = subTable.isExpanded();
            ResponseWriter writer = context.getResponseWriter();
            this.encodeControl(context, writer, toggleControl, switchType, expanded, false);
            this.encodeControl(context, writer, toggleControl, switchType, !expanded, true);
            JSFunction jsFunction = new JSFunction("new RichFaces.ui.SubTableToggler", new Object[0]);
            String toggleId = toggleControl.getClientId(context);
            jsFunction.addParameter((Object)toggleId);
            HashMap<String, Object> options = this.encodeOptions(context, toggleControl, subTable);
            jsFunction.addParameter(options);
            writer.startElement("script", (UIComponent)subTable);
            writer.writeText((Object)jsFunction.toScript(), null);
            writer.endElement("script");
        }
    }

    protected void encodeControl(FacesContext context, ResponseWriter writer, AbstractSubTableToggleControl control, String switchType, boolean expanded, boolean visible) throws IOException {
        String label;
        String state = this.getState(expanded);
        String styleClass = this.getStyleClass(context, control);
        String style = this.getStyle(context, control);
        writer.startElement("span", (UIComponent)control);
        if (!visible) {
            writer.writeAttribute("style", (Object)DISPLAY_NONE, null);
        }
        writer.writeAttribute("id", (Object)(control.getClientId() + ":" + state), null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("style", (Object)style, null);
        boolean encodeDefault = true;
        UIComponent controlFacet = control.getFacet(state);
        if (controlFacet != null && controlFacet.isRendered()) {
            if (!visible) {
                String facetStyle = (String)controlFacet.getAttributes().get("style");
                facetStyle = facetStyle != null ? facetStyle + ";" + DISPLAY_NONE : DISPLAY_NONE;
                controlFacet.getAttributes().put("style", facetStyle);
            }
            controlFacet.encodeAll(context);
            encodeDefault = false;
        }
        String expandIcon = control.getExpandIcon();
        String collapseIcon = control.getCollapseIcon();
        if (expandIcon != null && collapseIcon != null && expandIcon.trim().length() > 0 && collapseIcon.trim().length() > 0) {
            String image;
            String string = image = expanded ? expandIcon : collapseIcon;
            if (image != null && image.trim().length() > 0) {
                writer.startElement("img", (UIComponent)control);
                writer.writeAttribute("src", (Object)image, null);
                writer.writeAttribute("alt", (Object)"", null);
                writer.endElement("img");
            }
            encodeDefault = false;
        }
        String string = label = expanded ? control.getExpandLabel() : control.getCollapseLabel();
        if (label != null && label.trim().length() > 0) {
            writer.startElement("a", (UIComponent)control);
            writer.writeAttribute("href", (Object)"javascript:void(0);", null);
            writer.writeText((Object)label, null);
            writer.endElement("a");
            encodeDefault = false;
        }
        if (encodeDefault) {
            String image;
            expandIcon = context.getApplication().getResourceHandler().createResource(UP_ICON_URL).getRequestPath();
            collapseIcon = context.getApplication().getResourceHandler().createResource(DOWN_ICON_URL).getRequestPath();
            String string2 = image = expanded ? expandIcon : collapseIcon;
            if (image != null && image.trim().length() > 0) {
                writer.startElement("img", (UIComponent)control);
                writer.writeAttribute("src", (Object)image, null);
                writer.writeAttribute("alt", (Object)"", null);
                writer.endElement("img");
            }
        }
        writer.endElement("span");
    }

    public HashMap<String, Object> encodeOptions(FacesContext context, AbstractSubTableToggleControl toggleControl, AbstractSubTable subTable) {
        String forId = subTable.getClientId(context);
        String toggleControlId = toggleControl.getClientId(context);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("forId", forId);
        options.put("expandControl", toggleControlId + ":expand");
        options.put("collapseControl", toggleControlId + ":collapse");
        String eventName = toggleControl.getEvent();
        eventName = eventName.trim().startsWith("on") ? eventName.substring(2) : eventName;
        options.put("eventName", eventName);
        return options;
    }

    public String getStyleClass(FacesContext context, AbstractSubTableToggleControl control) {
        return null;
    }

    public String getStyle(FacesContext context, AbstractSubTableToggleControl control) {
        return null;
    }

    protected AbstractSubTable findComponent(FacesContext context, AbstractSubTableToggleControl toggleControl) {
        UIComponent subTable;
        String forId = toggleControl.getFor();
        if (forId != null && forId.length() > 0 && (subTable = RENDERER_UTILS.findComponentFor(context, (UIComponent)toggleControl, forId)) instanceof AbstractSubTable) {
            return (AbstractSubTable)subTable;
        }
        return null;
    }

    protected String getState(boolean expand) {
        return expand ? EXPAND_STATE : COLLAPSE_STATE;
    }
}

