/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSObject;
import org.richfaces.component.AbstractTogglePanelTitledItem;
import org.richfaces.component.html.HtmlAccordionItem;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.html.TogglePanelItemRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(name="richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="TogglePanelItem.js"), @ResourceDependency(library="org.richfaces", name="AccordionItem.js")})
public class AccordionItemRenderer
extends TogglePanelItemRenderer {
    private static final RenderKitUtils.Attributes HEADER_ATTRIBUTES = RenderKitUtils.attributes().generic("style", HtmlAccordionItem.PropertyKeys.headerStyle.toString(), new String[0]).generic("onclick", HtmlAccordionItem.PropertyKeys.onheaderclick.toString(), "headerclick").generic("ondblclick", HtmlAccordionItem.PropertyKeys.onheaderdblclick.toString(), "headerdblclick").generic("onmousedown", HtmlAccordionItem.PropertyKeys.onheadermousedown.toString(), "headermousedown").generic("onmousemove", HtmlAccordionItem.PropertyKeys.onheadermousemove.toString(), "headermousemove").generic("onmouseup", HtmlAccordionItem.PropertyKeys.onheadermouseup.toString(), "headermouseup");

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        super.doEncodeBegin(writer, context, component);
        this.encodeHeader(context, component, writer);
        this.encodeContentBegin(component, writer);
    }

    @Override
    protected String getStyleClass(UIComponent component) {
        return HtmlUtil.concatClasses("rf-ac-itm", AccordionItemRenderer.attributeAsString(component, "styleClass"));
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.encodeContentEnd(component, writer);
        super.doEncodeEnd(writer, context, component);
    }

    @Override
    protected void writeJavaScript(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        JSObject script = this.getScriptObject(context, component);
        if (script == null) {
            return;
        }
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", "type");
        writer.writeText((Object)script, null);
        writer.endElement("script");
    }

    private void encodeContentBegin(UIComponent component, ResponseWriter writer) throws IOException {
        writer.startElement("div", component);
        writer.writeAttribute("class", (Object)HtmlUtil.concatClasses("rf-ac-itm-cnt", AccordionItemRenderer.attributeAsString(component, "contentClass")), null);
        writer.writeAttribute("id", (Object)(component.getClientId() + ":content"), null);
        AbstractTogglePanelTitledItem item = (AbstractTogglePanelTitledItem)component;
        if (!item.isActive() || item.isDisabled()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
    }

    private void encodeContentEnd(UIComponent component, ResponseWriter responseWriter) throws IOException {
        responseWriter.endElement("div");
    }

    private void encodeHeader(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        writer.startElement("div", component);
        writer.writeAttribute("class", (Object)HtmlUtil.concatClasses("rf-ac-itm-hdr", AccordionItemRenderer.attributeAsString(component, HtmlAccordionItem.PropertyKeys.headerClass)), null);
        writer.writeAttribute("id", (Object)(component.getClientId() + ":header"), null);
        RenderKitUtils.renderPassThroughAttributes(context, component, HEADER_ATTRIBUTES);
        AbstractTogglePanelTitledItem titledItem = (AbstractTogglePanelTitledItem)component;
        boolean isActive = titledItem.isActive();
        boolean isDisabled = titledItem.isDisabled();
        this.encodeHeader(context, titledItem, writer, AbstractTogglePanelTitledItem.HeaderStates.inactive, !isActive && !isDisabled);
        this.encodeHeader(context, titledItem, writer, AbstractTogglePanelTitledItem.HeaderStates.active, isActive && !isDisabled);
        this.encodeHeader(context, titledItem, writer, AbstractTogglePanelTitledItem.HeaderStates.disabled, isDisabled);
        writer.endElement("div");
    }

    private void encodeHeader(FacesContext facesContext, AbstractTogglePanelTitledItem component, ResponseWriter writer, AbstractTogglePanelTitledItem.HeaderStates state, Boolean isDisplay) throws IOException {
        writer.startElement("div", (UIComponent)component);
        if (!isDisplay.booleanValue()) {
            writer.writeAttribute("style", (Object)"display : none", null);
        }
        String name = "headerClass" + AccordionItemRenderer.capitalize(state.toString());
        writer.writeAttribute("class", (Object)HtmlUtil.concatClasses("rf-ac-itm-hdr-" + state.abbreviation(), AccordionItemRenderer.attributeAsString((UIComponent)component, name)), null);
        UIComponent headerFacet = component.getHeaderFacet(state);
        if (headerFacet != null && headerFacet.isRendered()) {
            headerFacet.encodeAll(facesContext);
        } else {
            Object headerText = component.getAttributes().get("header");
            if (headerText != null && !headerText.equals("")) {
                writer.writeText(headerText, null);
            }
        }
        writer.endElement("div");
    }

    @Override
    protected JSObject getScriptObject(FacesContext context, UIComponent component) {
        return new JSObject("RichFaces.ui.AccordionItem", new Object[]{component.getClientId(), this.getScriptObjectOptions(context, component)});
    }

    @Override
    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        Map<String, Object> res = super.getScriptObjectOptions(context, component);
        res.put("disabled", ((AbstractTogglePanelTitledItem)component).isDisabled());
        return res;
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractTogglePanelTitledItem.class;
    }
}

