/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.richfaces.component.AbstractPoll;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.renderkit.util.HandlersChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependency(library="org.richfaces", name="ajax.reslib")
public class AjaxPollRenderer
extends RendererBase {
    public static final String COMPONENT_FAMILY = "org.richfaces.Poll";
    public static final String RENDERER_TYPE = "org.richfaces.PollRenderer";
    private static final String AJAX_POLL_FUNCTION = "RichFaces.startPoll";

    private void addComponentToAjaxRender(FacesContext context, UIComponent component) {
        PartialViewContext pvc = context.getPartialViewContext();
        pvc.getRenderIds().add(component.getClientId(context));
    }

    @Override
    protected void queueComponentEventForBehaviorEvent(FacesContext context, UIComponent component, String eventName) {
        super.queueComponentEventForBehaviorEvent(context, component, eventName);
        if ("timer".equals(eventName)) {
            new ActionEvent(component).queue();
            this.addComponentToAjaxRender(context, component);
        }
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractPoll poll = (AbstractPoll)component;
        writer.startElement("span", component);
        writer.writeAttribute("style", (Object)"display:none;", null);
        this.getUtils().encodeId(context, component);
        this.getUtils().encodeBeginFormIfNessesary(context, component);
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        StringBuffer script = new StringBuffer("\n");
        if (poll.isEnabled()) {
            JSFunction function = new JSFunction(AJAX_POLL_FUNCTION, new Object[0]);
            HashMap<String, Object> options = new HashMap<String, Object>();
            Integer interval = new Integer(poll.getInterval());
            options.put("pollinterval", interval);
            options.put("pollId", component.getClientId(context));
            HandlersChain handlersChain = new HandlersChain(context, (UIComponent)poll);
            handlersChain.addInlineHandlerFromAttribute("ontimer");
            handlersChain.addBehaviors("timer");
            handlersChain.addInlineHandlerFromAttribute("onbegin");
            handlersChain.addBehaviors("begin");
            handlersChain.addInlineHandlerFromAttribute("oncomplete");
            handlersChain.addBehaviors("complete");
            handlersChain.addInlineHandlerFromAttribute("onbeforedomupdate");
            handlersChain.addBehaviors("beforedomupdate");
            handlersChain.addAjaxSubmitFunction();
            String handler = handlersChain.toScript();
            if (handler != null) {
                JSFunctionDefinition timerHandler = new JSFunctionDefinition(new Object[]{JSReference.EVENT});
                timerHandler.addToBody((Object)handler);
                options.put("ontimer", timerHandler);
            }
            function.addParameter(options);
            function.appendScript(script);
        } else {
            script.append("RichFaces.stopPoll('").append(component.getClientId(context)).append("')");
        }
        script.append(";\n");
        writer.writeText((Object)script.toString(), null);
        writer.endElement("script");
        this.getUtils().encodeEndFormIfNessesary(context, component);
        writer.endElement("span");
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractPoll.class;
    }

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        Map requestParameterMap;
        super.doDecode(context, component);
        AbstractPoll poll = (AbstractPoll)component;
        if (poll.isEnabled() && (requestParameterMap = context.getExternalContext().getRequestParameterMap()).get(poll.getClientId(context)) != null) {
            new ActionEvent((UIComponent)poll).queue();
            this.addComponentToAjaxRender(context, component);
        }
    }
}

