/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.richfaces.component.AbstractPush;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.renderkit.util.HandlersChain;
import org.richfaces.resource.PushResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependency(library="org.richfaces", name="ajax.reslib")
public class AjaxPushRenderer
extends RendererBase {
    public static final String COMPONENT_FAMILY = "org.richfaces.Push";
    public static final String RENDERER_TYPE = "org.richfaces.PushRenderer";
    public static final String PUSH_INTERVAL_PARAMETER = "A4J.AJAX.Push.INTERVAL";
    public static final int DEFAULT_PUSH_INTERVAL = 1000;
    public static final int DEFAULT_PUSH_WAIT = Integer.MIN_VALUE;

    @Override
    protected void queueComponentEventForBehaviorEvent(FacesContext context, UIComponent component, String eventName) {
        super.queueComponentEventForBehaviorEvent(context, component, eventName);
        if ("dataAvailable".equals(eventName)) {
            new ActionEvent(component).queue();
        }
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractPush push = (AbstractPush)component;
        writer.startElement("span", component);
        writer.writeAttribute("style", (Object)"display:none;", null);
        this.getUtils().encodeId(context, component);
        this.getUtils().encodeBeginFormIfNessesary(context, component);
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        StringBuffer script = new StringBuffer("\n");
        if (push.isEnabled()) {
            JSFunction function = new JSFunction("RichFaces.startPush", new Object[0]);
            HashMap<String, Object> options = new HashMap<String, Object>();
            int interval = push.getInterval();
            if (!this.getUtils().shouldRenderAttribute(interval)) {
                String intervalInitParameter = context.getExternalContext().getInitParameter(PUSH_INTERVAL_PARAMETER);
                interval = null != intervalInitParameter ? Integer.parseInt(intervalInitParameter) : 1000;
            }
            options.put("interval", interval);
            options.put("pushResourceUrl", new PushResource().getRequestPath());
            options.put("pushId", push.getListenerId(context));
            options.put("clientId", component.getClientId(context));
            HandlersChain handlersChain = new HandlersChain(context, (UIComponent)push);
            handlersChain.addInlineHandlerFromAttribute("ondataavailable");
            handlersChain.addBehaviors("dataAvailable");
            handlersChain.addAjaxSubmitFunction();
            String handler = handlersChain.toScript();
            if (handler != null) {
                JSFunctionDefinition dataAvailableHandler = new JSFunctionDefinition(new Object[]{JSReference.EVENT});
                dataAvailableHandler.addToBody((Object)handler);
                options.put("ondataavailable", dataAvailableHandler);
            }
            function.addParameter(options);
            script.append(function.toScript());
        } else {
            script.append("RichFaces.stopPush('").append(push.getListenerId(context)).append("')");
        }
        script.append(";\n");
        writer.writeText((Object)script.toString(), null);
        writer.endElement("script");
        this.getUtils().encodeEndFormIfNessesary(context, component);
        writer.endElement("span");
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractPush.class;
    }

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        Map requestParameterMap;
        super.doDecode(context, component);
        AbstractPush push = (AbstractPush)component;
        if (push.isEnabled() && (requestParameterMap = context.getExternalContext().getRequestParameterMap()).get(push.getClientId(context)) != null) {
            new ActionEvent((UIComponent)push).queue();
        }
    }
}

