/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSObject;
import org.richfaces.component.AbstractCollapsiblePanel;
import org.richfaces.component.AbstractTogglePanel;
import org.richfaces.component.AbstractTogglePanelTitledItem;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.html.TogglePanelRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(name="richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="TogglePanel.js"), @ResourceDependency(library="org.richfaces", name="TogglePanelItem.js"), @ResourceDependency(library="org.richfaces", name="CollapsiblePanel.js"), @ResourceDependency(library="org.richfaces", name="CollapsiblePanelItem.js"), @ResourceDependency(library="org.richfaces", name="collapsiblePanel.ecss")})
public class CollapsiblePanelRenderer
extends TogglePanelRenderer {
    public static final String SWITCH = "switch";
    public static final String BEFORE_SWITCH = "beforeswitch";

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        String compClientId;
        String clientId;
        AbstractTogglePanel panel = (AbstractTogglePanel)component;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestMap.get(CollapsiblePanelRenderer.getValueRequestParamName(context, component));
        if (newValue != null) {
            panel.setSubmittedActiveItem(newValue);
        }
        if ((clientId = (String)requestMap.get(compClientId = component.getClientId(context))) != null && clientId.equals(compClientId)) {
            String itemClientId = clientId + (Boolean.parseBoolean(newValue) ? ":content" : ":empty");
            context.getPartialViewContext().getRenderIds().add(itemClientId);
            CollapsiblePanelRenderer.addOnCompleteParam(newValue, panel.getClientId());
        }
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent comp) throws IOException {
        super.doEncodeBegin(writer, context, comp);
        this.encodeHeader(context, comp, writer);
    }

    @Override
    protected String getStyleClass(UIComponent component) {
        return HtmlUtil.concatClasses("rf-cp", super.getStyleClass(component));
    }

    @Override
    protected JSObject getScriptObject(FacesContext context, UIComponent component) {
        return new JSObject("RichFaces.ui.CollapsiblePanel", new Object[]{component.getClientId(), this.getScriptObjectOptions(context, component)});
    }

    @Override
    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        AbstractTogglePanel panel = (AbstractTogglePanel)component;
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("activeItem", panel.getActiveItem());
        options.put("ajax", (Object)CollapsiblePanelRenderer.getAjaxOptions(context, (UIComponent)panel));
        options.put("switchMode", panel.getSwitchType());
        TogglePanelRenderer.addEventOption(context, (UIComponent)panel, options, SWITCH);
        TogglePanelRenderer.addEventOption(context, (UIComponent)panel, options, BEFORE_SWITCH);
        return options;
    }

    private void encodeHeader(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)(component.getClientId(context) + ":header"), null);
        writer.writeAttribute("class", (Object)HtmlUtil.concatClasses("rf-cp-hdr", CollapsiblePanelRenderer.attributeAsString(component, "headerClass")), null);
        AbstractCollapsiblePanel panel = (AbstractCollapsiblePanel)component;
        this.encodeHeader(context, component, writer, AbstractCollapsiblePanel.States.expanded, panel.isExpanded());
        this.encodeHeader(context, component, writer, AbstractCollapsiblePanel.States.collapsed, !panel.isExpanded());
        writer.endElement("div");
    }

    private void encodeHeader(FacesContext context, UIComponent component, ResponseWriter responseWriter, AbstractCollapsiblePanel.States state, boolean isVisible) throws IOException {
        responseWriter.startElement("div", component);
        responseWriter.writeAttribute("class", (Object)("rf-cp-hdr-" + state.abbreviation()), null);
        responseWriter.writeAttribute("style", (Object)HtmlUtil.concatStyles(CollapsiblePanelRenderer.styleElement("display", isVisible ? "" : "none"), CollapsiblePanelRenderer.attributeAsString(component, "headerClass")), null);
        UIComponent header = AbstractTogglePanelTitledItem.getHeaderFacet(component, state);
        if (header != null && header.isRendered()) {
            header.encodeAll(context);
        } else {
            String headerText = (String)component.getAttributes().get("header");
            if (headerText != null && !headerText.isEmpty()) {
                responseWriter.writeText((Object)headerText, null);
            }
        }
        responseWriter.endElement("div");
    }

    @Override
    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractCollapsiblePanel panel = (AbstractCollapsiblePanel)component;
        this.encodeContentChild(writer, context, component, panel);
        this.encodeEmptyChild(writer, context, component, panel);
    }

    private void encodeContentChild(ResponseWriter writer, FacesContext context, UIComponent component, AbstractCollapsiblePanel panel) throws IOException {
        if (panel.isExpanded()) {
            this.encodeContent(writer, context, component, true);
        } else {
            switch (panel.getSwitchType()) {
                case client: {
                    this.encodeContent(writer, context, component, false);
                    break;
                }
                case ajax: {
                    context.getResponseWriter().write(this.getPlaceHolder(panel.getClientId() + ":content"));
                    break;
                }
                case server: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown switch type : " + panel.getSwitchType());
                }
            }
        }
    }

    private void encodeEmptyChild(ResponseWriter writer, FacesContext context, UIComponent component, AbstractCollapsiblePanel panel) throws IOException {
        if (!panel.isExpanded()) {
            this.encodeEmptyDiv(writer, context, component, true);
        } else {
            switch (panel.getSwitchType()) {
                case client: {
                    this.encodeEmptyDiv(writer, context, component, false);
                    break;
                }
                case ajax: {
                    context.getResponseWriter().write(this.getPlaceHolder(panel.getClientId() + ":empty"));
                    break;
                }
                case server: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown switch type : " + panel.getSwitchType());
                }
            }
        }
    }

    private String getPlaceHolder(String id) {
        return "<div id=\"" + id + "\" style=\"display: none\" ></div>";
    }

    private void encodeContent(ResponseWriter writer, FacesContext context, UIComponent component, boolean visible) throws IOException {
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)(component.getClientId() + ":content"), null);
        writer.writeAttribute("class", (Object)HtmlUtil.concatClasses("rf-cp-b", CollapsiblePanelRenderer.attributeAsString(component, "bodyClass")), null);
        writer.writeAttribute("style", (Object)HtmlUtil.concatStyles(visible ? "" : "none", CollapsiblePanelRenderer.attributeAsString(component, "style")), null);
        this.renderChildren(context, component);
        writer.endElement("div");
    }

    private void encodeEmptyDiv(ResponseWriter writer, FacesContext context, UIComponent component, boolean visible) throws IOException {
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)(component.getClientId() + ":empty"), null);
        writer.writeAttribute("class", (Object)"rf-cp-empty", null);
        writer.writeAttribute("style", (Object)CollapsiblePanelRenderer.styleElement("display", visible ? "" : "none"), null);
        writer.endElement("div");
    }

    @Override
    protected List<JSObject> getChildrenScriptObjects(FacesContext context, UIComponent component) {
        return null;
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractCollapsiblePanel.class;
    }
}

