/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.javascript.ScriptUtils;
import org.richfaces.component.AbstractPopupPanel;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONMap;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.renderkit.util.RendererUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="base-component.reslib"), @ResourceDependency(library="org.richfaces", name="popupPanel.js"), @ResourceDependency(library="org.richfaces", name="popupPanelBorders.js"), @ResourceDependency(library="org.richfaces", name="popupPanelSizer.js"), @ResourceDependency(library="org.richfaces", name="popupPanel.ecss")})
public class PopupPanelBaseRenderer
extends RendererBase {
    private static final String CONTROLS_FACET = "controls";
    private static final String HEADER_FACET = "header";
    private static final int SIZE = 10;
    private static final String STATE_OPTION_SUFFIX = "StateOption_";
    private static final Set<String> ALLOWED_ATTACHMENT_OPTIONS = new HashSet<String>();

    public void renderHeaderFacet(FacesContext context, UIComponent component) throws IOException {
        this.renderFacet(context, component, HEADER_FACET);
    }

    public void renderControlsFacet(FacesContext context, UIComponent component) throws IOException {
        this.renderFacet(context, component, CONTROLS_FACET);
    }

    private void renderFacet(FacesContext context, UIComponent component, String facet) throws IOException {
        UIComponent headerFacet = component.getFacet(facet);
        headerFacet.encodeAll(context);
    }

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        AbstractPopupPanel panel = (AbstractPopupPanel)component;
        ExternalContext exCtx = context.getExternalContext();
        Map rqMap = exCtx.getRequestParameterMap();
        Object panelOpenState = rqMap.get(panel.getClientId(context) + "OpenedState");
        if (panel.isKeepVisualState() && null != panelOpenState) {
            boolean show = panel.isShow() || Boolean.parseBoolean((String)panelOpenState);
            panel.setShow(show);
            Map<String, Object> visualOptions = this.getHandledVisualOptions(panel);
            for (Map.Entry entry : rqMap.entrySet()) {
                int suffixPos = ((String)entry.getKey()).toString().indexOf(STATE_OPTION_SUFFIX);
                if (-1 == suffixPos) continue;
                String key = ((String)entry.getKey()).toString().substring(suffixPos + STATE_OPTION_SUFFIX.length());
                visualOptions.put(key, entry.getValue());
            }
        }
    }

    protected Class getComponentClass() {
        return AbstractPopupPanel.class;
    }

    public void checkOptions(FacesContext context, UIComponent component) {
        AbstractPopupPanel panel = (AbstractPopupPanel)component;
        if (panel.isAutosized() && panel.isResizeable()) {
            throw new IllegalArgumentException("Autosized modal panel can't be resizeable.");
        }
        String domElementAttachment = panel.getDomElementAttachment();
        if (domElementAttachment != null && domElementAttachment.trim().length() != 0 && !ALLOWED_ATTACHMENT_OPTIONS.contains(domElementAttachment)) {
            throw new IllegalArgumentException("Value '" + domElementAttachment + "' of domElementAttachment attribute is illegal. " + "Allowed values are: " + ALLOWED_ATTACHMENT_OPTIONS);
        }
        if (panel.getMinHeight() != -1 && panel.getMinHeight() < 10) {
            throw new FacesException("Attribbute minWidth should be greater then 10px");
        }
        if (panel.getMinWidth() != -1 && panel.getMinWidth() < 10) {
            throw new FacesException("Attribbute minHeight should be greater then 10px");
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public String buildShowScript(FacesContext context, UIComponent component) {
        AbstractPopupPanel panel = (AbstractPopupPanel)component;
        StringBuilder result = new StringBuilder();
        if (panel.isShow()) {
            result.append("RichFaces.ui.PopupPanel.showPopupPanel('" + panel.getClientId(context) + "', {");
            Iterator<Map.Entry<String, Object>> it = this.getHandledVisualOptions(panel).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                result.append(entry.getKey() + ": '" + entry.getValue() + "'");
                if (!it.hasNext()) continue;
                result.append(", ");
            }
            result.append("});");
        }
        if (result.length() > 0) {
            return result.toString();
        }
        return null;
    }

    public String getStyleIfTrimmed(UIComponent panel) {
        if (panel.getAttributes().get("trimOverlayedElements").equals(Boolean.TRUE)) {
            return "position: relative, z-index : 0";
        }
        return "";
    }

    public String buildScript(FacesContext context, UIComponent component) throws IOException {
        AbstractPopupPanel panel = (AbstractPopupPanel)component;
        StringBuilder result = new StringBuilder();
        result.append("new RichFaces.ui.PopupPanel('");
        result.append(panel.getClientId());
        result.append("',");
        Map attributes = component.getAttributes();
        HashMap<String, Object> options = new HashMap<String, Object>();
        RendererUtils utils = this.getUtils();
        utils.addToScriptHash(options, "width", panel.getWidth(), "-1");
        utils.addToScriptHash(options, "height", panel.getHeight(), "-1");
        utils.addToScriptHash(options, "minWidth", panel.getMinWidth(), "-1");
        utils.addToScriptHash(options, "minHeight", panel.getMinHeight(), "-1");
        utils.addToScriptHash(options, "maxWidth", panel.getMaxWidth(), "2147483647");
        utils.addToScriptHash(options, "maxHeight", panel.getMaxHeight(), "2147483647");
        utils.addToScriptHash(options, "moveable", panel.isMoveable(), "true");
        utils.addToScriptHash(options, "followByScroll", panel.isFollowByScroll(), "true");
        utils.addToScriptHash(options, "left", panel.getLeft(), "auto");
        utils.addToScriptHash(options, "top", panel.getTop(), "auto");
        utils.addToScriptHash(options, "zindex", panel.getZIndex(), "100");
        utils.addToScriptHash(options, "shadowDepth", panel.getShadowDepth(), "2");
        utils.addToScriptHash(options, "shadowOpacity", panel.getShadowOpacity(), "0.1");
        utils.addToScriptHash(options, "domElementAttachment", panel.getDomElementAttachment());
        utils.addToScriptHash(options, "keepVisualState", panel.isKeepVisualState(), "false");
        utils.addToScriptHash(options, "show", panel.isShow(), "false");
        utils.addToScriptHash(options, "modal", panel.isModal(), "true");
        utils.addToScriptHash(options, "autosized", panel.isAutosized(), "false");
        utils.addToScriptHash(options, "resizeable", panel.isResizeable(), "false");
        utils.addToScriptHash(options, "overlapEmbedObjects", panel.isOverlapEmbedObjects(), "false");
        utils.addToScriptHash(options, "visualOptions", this.writeVisualOptions(context, panel));
        utils.addToScriptHash(options, "onresize", this.buildEventFunction(attributes.get("onresize")));
        utils.addToScriptHash(options, "onmove", this.buildEventFunction(attributes.get("onmove")));
        utils.addToScriptHash(options, "onshow", this.buildEventFunction(attributes.get("onshow")));
        utils.addToScriptHash(options, "onhide", this.buildEventFunction(attributes.get("onhide")));
        utils.addToScriptHash(options, "onbeforeshow", this.buildEventFunction(attributes.get("onbeforeshow")));
        utils.addToScriptHash(options, "onbeforehide", this.buildEventFunction(attributes.get("onbeforehide")));
        result.append(ScriptUtils.toScript(options));
        result.append(");");
        return result.toString();
    }

    private Object buildEventFunction(Object eventFunction) {
        if (eventFunction != null && eventFunction.toString().length() > 0) {
            return "new Function(\"" + eventFunction.toString() + "\");";
        }
        return null;
    }

    public Map<String, Object> getHandledVisualOptions(AbstractPopupPanel panel) {
        String options = panel.getVisualOptions();
        Map<String, Object> result = this.prepareVisualOptions(options, panel);
        if (null == result) {
            result = new HashMap<String, Object>();
        }
        return result;
    }

    private String writeVisualOptions(FacesContext context, AbstractPopupPanel panel) throws IOException {
        StringBuffer result = new StringBuffer();
        Iterator<Map.Entry<String, Object>> it = this.getHandledVisualOptions(panel).entrySet().iterator();
        if (it.hasNext()) {
            result.append(",\n");
        }
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            result.append(entry.getKey() + ": '" + entry.getValue() + "'");
            if (!it.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    private Map<String, Object> prepareVisualOptions(Object value, AbstractPopupPanel panel) {
        if (null == value) {
            return new HashMap<String, Object>();
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        if (value instanceof String) {
            String s = (String)value;
            if (!s.startsWith("{")) {
                s = "{" + s + "}";
            }
            try {
                return new HashMap<String, Object>(new JSONMap(s));
            }
            catch (JSONException e) {
                throw new FacesException((Throwable)e);
            }
        }
        throw new FacesException("Attribute visualOptions of component [" + panel.getClientId(FacesContext.getCurrentInstance()) + "] must be instance of Map or String, but its type is " + value.getClass().getSimpleName());
    }

    static {
        ALLOWED_ATTACHMENT_OPTIONS.add("body");
        ALLOWED_ATTACHMENT_OPTIONS.add("parent");
        ALLOWED_ATTACHMENT_OPTIONS.add("form");
    }
}

