/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.javascript.JSLiteral;
import org.ajax4jsf.javascript.ScriptUtils;
import org.richfaces.component.AbstractProgressBar;
import org.richfaces.component.NumberUtils;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.renderkit.util.RendererUtils;

@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="ajax.reslib"), @ResourceDependency(library="org.richfaces", name="base-component.reslib"), @ResourceDependency(library="org.richfaces", name="progressBar.js"), @ResourceDependency(library="org.richfaces", name="progressBar.ecss")})
public class ProgressBarBaseRenderer
extends RendererBase {
    private static final String INITIAL_FACET = "initial";
    private static final String COMPLETE_FACET = "complete";
    private static final Logger LOG = RichfacesLogger.APPLICATION.getLogger();

    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        if (component.isRendered()) {
            new ActionEvent(component).queue();
            PartialViewContext pvc = context.getPartialViewContext();
            pvc.getRenderIds().add(component.getClientId(context));
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    public final boolean getRendersChildren() {
        return true;
    }

    public String getForcedState(FacesContext context, UIComponent component) {
        String forcedState = null;
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey("forcePercent")) {
            forcedState = (String)params.get("forcePercent");
        }
        return forcedState;
    }

    public StringBuffer getMarkup(FacesContext context, UIComponent component) {
        StringBuffer result = new StringBuffer();
        try {
            result = new StringBuffer(this.getMarkupBody(context, component, this.hasChildren(component)));
        }
        catch (Exception e) {
            LOG.error((CharSequence)"Error occurred during rendering of progress bar label. It switched to empty string", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMarkupBody(FacesContext context, UIComponent component, boolean children) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        StringWriter dumpingWriter = new StringWriter();
        ResponseWriter clonedWriter = writer.cloneWithWriter((Writer)dumpingWriter);
        context.setResponseWriter(clonedWriter);
        try {
            if (children) {
                this.renderChildren(context, component);
            } else if (component.getAttributes().get("label") != null) {
                clonedWriter.write(component.getAttributes().get("label").toString());
            }
        }
        finally {
            clonedWriter.flush();
            context.setResponseWriter(writer);
        }
        return dumpingWriter.toString();
    }

    public String getRenderStateScript(FacesContext context, UIComponent component, String state) throws IOException {
        StringBuffer script = new StringBuffer("\n");
        script.append("RichFaces.$('" + component.getClientId(context) + "').renderState('").append(state).append("');");
        return script.toString();
    }

    public String getInitialScript(FacesContext context, UIComponent component, String state) throws IOException {
        AbstractProgressBar progressBar = (AbstractProgressBar)component;
        StringBuffer script = new StringBuffer();
        HashMap<String, Object> options = new HashMap<String, Object>();
        RendererUtils utils = this.getUtils();
        String clientId = component.getClientId(context);
        utils.addToScriptHash(options, "mode", component.getAttributes().get("mode"), "ajax");
        utils.addToScriptHash(options, "minValue", component.getAttributes().get("minValue"), "0");
        utils.addToScriptHash(options, "maxValue", component.getAttributes().get("maxValue"), "100");
        utils.addToScriptHash(options, "context", this.getContext(component));
        Integer interval = new Integer(progressBar.getInterval());
        utils.addToScriptHash(options, "pollinterval", interval);
        utils.addToScriptHash(options, "enabled", progressBar.isEnabled());
        utils.addToScriptHash(options, "pollId", progressBar.getClientId(context));
        utils.addToScriptHash(options, "state", state, "initialState");
        utils.addToScriptHash(options, "value", NumberUtils.getNumber(component.getAttributes().get("value")));
        utils.addToScriptHash(options, "onsubmit", this.buildEventFunction(component.getAttributes().get("onsubmit")));
        script.append("new RichFaces.ui.ProgressBar('").append(clientId).append("'");
        if (!options.isEmpty()) {
            script.append(",").append(ScriptUtils.toScript(options));
        }
        script.append(")\n;");
        return script.toString();
    }

    private Object buildEventFunction(Object eventFunction) {
        if (eventFunction != null && eventFunction.toString().length() > 0) {
            return "new Function(\"" + eventFunction.toString() + "\");";
        }
        return null;
    }

    public String getPollScript(FacesContext context, UIComponent component) {
        return "RichFaces.$('" + component.getClientId() + "').poll()";
    }

    public String getStopPollScript(FacesContext context, UIComponent component) {
        return "RichFaces.$('" + component.getClientId() + "').disable()";
    }

    public boolean isAjaxMode(UIComponent component) {
        String mode = (String)component.getAttributes().get("mode");
        return "ajax".equalsIgnoreCase(mode);
    }

    public String getCurrentOrForcedState(FacesContext context, UIComponent component) {
        String forcedState = this.getForcedState(context, component);
        if (forcedState != null) {
            return forcedState;
        }
        return this.getCurrentState(context, component);
    }

    public String getCurrentState(FacesContext context, UIComponent component) {
        Number minValue = NumberUtils.getNumber(component.getAttributes().get("minValue"));
        Number maxValue = NumberUtils.getNumber(component.getAttributes().get("maxValue"));
        Number value = NumberUtils.getNumber(component.getAttributes().get("value"));
        if (value.doubleValue() <= minValue.doubleValue()) {
            return "initialState";
        }
        if (value.doubleValue() > maxValue.doubleValue()) {
            return "completeState";
        }
        return "progressState";
    }

    public String getShellStyle(FacesContext context, UIComponent component) {
        return !this.isSimpleMarkup(component) ? "rf-pb-shl-dig " : "rf-pb-shl ";
    }

    public String getWidth(UIComponent component) {
        Number value = NumberUtils.getNumber(component.getAttributes().get("value"));
        Number minValue = NumberUtils.getNumber(component.getAttributes().get("minValue"));
        Number maxValue = NumberUtils.getNumber(component.getAttributes().get("maxValue"));
        Number percent = this.calculatePercent(value, minValue, maxValue);
        return String.valueOf(percent.intValue());
    }

    public void renderInitialFacet(FacesContext context, UIComponent component) throws IOException {
        this.renderFacet(context, component, INITIAL_FACET);
    }

    public void renderCompleteFacet(FacesContext context, UIComponent component) throws IOException {
        this.renderFacet(context, component, COMPLETE_FACET);
    }

    private void renderFacet(FacesContext context, UIComponent component, String facet) throws IOException {
        UIComponent headerFacet = component.getFacet(facet);
        if (headerFacet != null) {
            headerFacet.encodeAll(context);
        }
    }

    public String getParameters(UIComponent component) {
        String parameters = (String)component.getAttributes().get("parameters");
        return parameters;
    }

    private JSLiteral getContext(UIComponent component) {
        StringBuffer buffer = new StringBuffer();
        String parameters = this.getParameters(component);
        JSLiteral literal = null;
        if (parameters != null) {
            buffer.append("{").append(parameters).append("}");
            literal = new JSLiteral(buffer.toString());
        }
        return literal;
    }

    private boolean hasChildren(UIComponent component) {
        return component.getChildCount() != 0;
    }

    public boolean isSimpleMarkup(UIComponent component) {
        if (this.hasChildren(component)) {
            return false;
        }
        return component.getAttributes().get("label") == null;
    }

    public Number calculatePercent(Number value, Number minValue, Number maxValue) {
        if (minValue.doubleValue() < value.doubleValue() && value.doubleValue() < maxValue.doubleValue()) {
            return (value.doubleValue() - minValue.doubleValue()) * 100.0 / (maxValue.doubleValue() - minValue.doubleValue());
        }
        if (value.doubleValue() <= minValue.doubleValue()) {
            return 0;
        }
        if (value.doubleValue() >= maxValue.doubleValue()) {
            return 100;
        }
        return 0;
    }
}

