/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSObject;
import org.richfaces.component.AbstractTabPanel;
import org.richfaces.component.AbstractTogglePanel;
import org.richfaces.component.AbstractTogglePanelItem;
import org.richfaces.component.AbstractTogglePanelTitledItem;
import org.richfaces.component.html.HtmlAccordion;
import org.richfaces.component.html.HtmlTab;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.html.TogglePanelRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(name="richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="tabPanel.ecss"), @ResourceDependency(library="org.richfaces", name="TogglePanel.js"), @ResourceDependency(library="org.richfaces", name="TabPanel.js")})
public class TabPanelRenderer
extends TogglePanelRenderer {
    private static final RenderKitUtils.Attributes HEADER_ATTRIBUTES = RenderKitUtils.attributes().generic("onclick", HtmlTab.PropertyKeys.onheaderclick.toString(), "headerclick").generic("ondblclick", HtmlTab.PropertyKeys.onheaderdblclick.toString(), "headerdblclick").generic("onmousedown", HtmlTab.PropertyKeys.onheadermousedown.toString(), "headermousedown").generic("onmousemove", HtmlTab.PropertyKeys.onheadermousemove.toString(), "headermousemove").generic("onmouseup", HtmlTab.PropertyKeys.onheadermouseup.toString(), "headermouseup");
    private static final String DIV = "div";
    private static final String STYLE = "style";
    private static final String CLASS = "class";

    @Override
    protected void doEncodeBegin(ResponseWriter w, FacesContext context, UIComponent comp) throws IOException {
        super.doEncodeBegin(w, context, comp);
        this.writeJavaScript(w, context, comp);
        this.writeTabsLine(w, context, comp);
        this.writeTabsLineSeparator(w);
    }

    private void writeTabsLineSeparator(ResponseWriter writer) throws IOException {
        writer.write("<div class='rf-tb-hdr_brd'></div>");
    }

    private void writeTabsLine(ResponseWriter w, FacesContext context, UIComponent comp) throws IOException {
        w.startElement(DIV, comp);
        w.writeAttribute(CLASS, (Object)"rf-tb-hdr-tabline-vis", null);
        w.startElement("table", comp);
        w.writeAttribute(CLASS, (Object)"rf-tb-hdr-tabs", null);
        w.writeAttribute("cellspacing", (Object)"0", null);
        w.startElement("tbody", comp);
        w.startElement("tr", comp);
        this.writeTopTabFirstSpacer(w, comp);
        for (AbstractTogglePanelItem item : ((AbstractTogglePanel)comp).getRenderedItems()) {
            AbstractTogglePanelTitledItem tab = (AbstractTogglePanelTitledItem)item;
            this.writeTopTabHeader(context, w, tab);
            this.writeTopTabSpacer(w, comp);
        }
        this.writeTopTabLastSpacer(w, comp);
        w.endElement("tr");
        w.endElement("tbody");
        w.endElement("table");
        this.writeTopTabsControl(w, comp, "rf-tb-hdr-scrl_l rf-tb-hdn", "\u00ab");
        this.writeTopTabsControl(w, comp, "rf-tb-hdr-tablst rf-tb-hdn", "\u2193");
        this.writeTopTabsControl(w, comp, "rf-tb-hdr-scrl_r rf-tb-hdn", "\u00bb");
        w.endElement(DIV);
    }

    @Override
    protected String getStyle(UIComponent component) {
        return HtmlUtil.concatStyles(TabPanelRenderer.attributeAsString(component, STYLE), "width: 100%;");
    }

    @Override
    protected String getStyleClass(UIComponent component) {
        return HtmlUtil.concatClasses("rf-tbp", TabPanelRenderer.attributeAsString(component, "styleClass"));
    }

    private void writeTopTabHeader(FacesContext context, ResponseWriter writer, AbstractTogglePanelTitledItem tab) throws IOException {
        boolean isActive = tab.isActive();
        boolean isDisabled = tab.isDisabled();
        this.encodeTabHeader(context, tab, writer, AbstractTogglePanelTitledItem.HeaderStates.inactive, !isActive && !isDisabled);
        this.encodeTabHeader(context, tab, writer, AbstractTogglePanelTitledItem.HeaderStates.active, isActive && !isDisabled);
        this.encodeTabHeader(context, tab, writer, AbstractTogglePanelTitledItem.HeaderStates.disabled, isDisabled);
    }

    private void encodeTabHeader(FacesContext context, AbstractTogglePanelTitledItem tab, ResponseWriter writer, AbstractTogglePanelTitledItem.HeaderStates state, Boolean isDisplay) throws IOException {
        writer.startElement("td", (UIComponent)tab);
        writer.writeAttribute("id", (Object)(tab.getClientId() + ":header:" + state.toString()), null);
        RenderKitUtils.renderPassThroughAttributes(context, (UIComponent)tab, HEADER_ATTRIBUTES);
        String name = "headerClass" + TabPanelRenderer.capitalize(state.toString());
        writer.writeAttribute(CLASS, (Object)HtmlUtil.concatClasses("rf-tb-hdr rf-tb-hdr-" + state.abbreviation(), TabPanelRenderer.attributeAsString((UIComponent)tab, HtmlTab.PropertyKeys.headerClass), TabPanelRenderer.attributeAsString((UIComponent)tab, name)), null);
        writer.writeAttribute(STYLE, (Object)HtmlUtil.concatStyles(isDisplay != false ? "" : "display : none", TabPanelRenderer.attributeAsString((UIComponent)tab, HtmlTab.PropertyKeys.headerStyle.toString())), null);
        writer.startElement("span", (UIComponent)tab);
        writer.writeAttribute(CLASS, (Object)"rf-tb-lbl", null);
        UIComponent headerFacet = tab.getHeaderFacet(state);
        if (headerFacet != null && headerFacet.isRendered()) {
            headerFacet.encodeAll(context);
        } else {
            Object headerText = tab.getAttributes().get("header");
            if (headerText != null && !headerText.equals("")) {
                writer.writeText(headerText, null);
            }
        }
        writer.endElement("span");
        writer.endElement("td");
    }

    private void writeTopTabsControl(ResponseWriter w, UIComponent comp, String styles, String text) throws IOException {
        w.startElement(DIV, comp);
        w.writeAttribute(CLASS, (Object)styles, null);
        w.writeText((Object)text, null);
        w.endElement(DIV);
    }

    private void writeTopTabFirstSpacer(ResponseWriter w, UIComponent comp) throws IOException {
        this.writeTopTabSpacer(w, comp, "padding-left: 5px;", "rf-tb-hdr-spcr");
    }

    private void writeTopTabSpacer(ResponseWriter w, UIComponent comp) throws IOException {
        this.writeTopTabSpacer(w, comp, "", "rf-tb-hdr-spcr rf-tb-hortab-tabspcr_wdh");
    }

    private void writeTopTabLastSpacer(ResponseWriter w, UIComponent comp) throws IOException {
        this.writeTopTabSpacer(w, comp, "padding-right: 5px; width: 100%;", "rf-tb-hdr-spcr");
    }

    private void writeTopTabSpacer(ResponseWriter w, UIComponent comp, String style, String classStyle) throws IOException {
        w.startElement("td", comp);
        w.writeAttribute(STYLE, (Object)style, null);
        w.writeAttribute(CLASS, (Object)classStyle, null);
        w.write("<br />");
        w.endElement("td");
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.endElement(DIV);
    }

    @Override
    protected JSObject getScriptObject(FacesContext context, UIComponent component) {
        return new JSObject("RichFaces.ui.TabPanel", new Object[]{component.getClientId(), this.getScriptObjectOptions(context, component)});
    }

    @Override
    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        Map<String, Object> options = super.getScriptObjectOptions(context, component);
        options.put("isKeepHeight", !TabPanelRenderer.attributeAsString(component, HtmlAccordion.PropertyKeys.height).isEmpty());
        options.remove("items");
        return options;
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractTabPanel.class;
    }
}

