/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSObject;
import org.ajax4jsf.javascript.JSReference;
import org.richfaces.component.AbstractTogglePanel;
import org.richfaces.component.AbstractTogglePanelItem;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.AjaxEventOptions;
import org.richfaces.renderkit.html.DivPanelRenderer;
import org.richfaces.renderkit.html.TogglePanelItemRenderer;
import org.richfaces.renderkit.util.AjaxRendererUtils;
import org.richfaces.renderkit.util.FormUtil;
import org.richfaces.renderkit.util.HandlersChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(name="richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="TogglePanel.js")})
public class TogglePanelRenderer
extends DivPanelRenderer {
    public static final String VALUE_POSTFIX = "-value";
    private static final String ON = "on";
    private static final String ITEM_CHANGE = "itemchange";
    private static final String BEFORE_ITEM_CHANGE = "beforeitemchange";

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        AbstractTogglePanelItem panelItem;
        String compClientId;
        String clientId;
        AbstractTogglePanel panel = (AbstractTogglePanel)component;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestMap.get(TogglePanelRenderer.getValueRequestParamName(context, component));
        if (newValue != null) {
            panel.setSubmittedActiveItem(newValue);
        }
        if ((clientId = (String)requestMap.get(compClientId = component.getClientId(context))) != null && clientId.equals(compClientId) && (panelItem = panel.getItem(newValue)) != null) {
            context.getPartialViewContext().getRenderIds().add(panelItem.getClientId(context));
            TogglePanelRenderer.addOnCompleteParam(newValue, panel.getClientId());
        }
    }

    protected static void addOnCompleteParam(String newValue, String panelId) {
        StringBuilder onComplete = new StringBuilder();
        onComplete.append("RichFaces.$('").append(panelId).append("').onCompleteHandler('").append(newValue).append("');");
        AjaxContext.getCurrentInstance().appendOncomplete((Object)onComplete.toString());
    }

    public static String getValueRequestParamName(FacesContext context, UIComponent component) {
        return component.getClientId(context) + VALUE_POSTFIX;
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent comp) throws IOException {
        FormUtil.throwEnclFormReqExceptionIfNeed(context, comp);
        super.doEncodeBegin(writer, context, comp);
        AbstractTogglePanel panel = (AbstractTogglePanel)comp;
        writer.startElement("input", comp);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)panel.getActiveItem(), "activeItem");
        writer.writeAttribute("id", (Object)TogglePanelRenderer.getValueRequestParamName(context, comp), null);
        writer.writeAttribute("name", (Object)TogglePanelRenderer.getValueRequestParamName(context, comp), null);
        writer.endElement("input");
    }

    @Override
    protected String getStyleClass(UIComponent component) {
        return HtmlUtil.concatClasses("rf-tgp", TogglePanelRenderer.attributeAsString(component, "styleClass"));
    }

    @Override
    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.renderChildren(context, component);
    }

    protected JSObject getScriptObject(FacesContext context, UIComponent component) {
        return new JSObject("RichFaces.ui.TogglePanel", new Object[]{component.getClientId(), this.getScriptObjectOptions(context, component)});
    }

    @Override
    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        AbstractTogglePanel panel = (AbstractTogglePanel)component;
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("activeItem", panel.getActiveItem());
        options.put("cycledSwitching", panel.isCycledSwitching());
        options.put("items", this.getChildrenScriptObjects(context, (UIComponent)panel));
        options.put("ajax", (Object)TogglePanelRenderer.getAjaxOptions(context, (UIComponent)panel));
        TogglePanelRenderer.addEventOption(context, (UIComponent)panel, options, ITEM_CHANGE);
        TogglePanelRenderer.addEventOption(context, (UIComponent)panel, options, BEFORE_ITEM_CHANGE);
        return options;
    }

    public static void addEventOption(FacesContext context, UIComponent component, Map<String, Object> options, String eventName) {
        HandlersChain handlersChain = new HandlersChain(context, component);
        handlersChain.addInlineHandlerFromAttribute(ON + eventName);
        handlersChain.addBehaviors(eventName);
        String handler = handlersChain.toScript();
        if (handler != null) {
            options.put(ON + eventName, new JSFunctionDefinition(new Object[]{JSReference.EVENT}).addToBody((Object)handler));
        }
    }

    public static AjaxEventOptions getAjaxOptions(FacesContext context, UIComponent panel) {
        return AjaxRendererUtils.buildEventOptions(context, panel);
    }

    protected List<JSObject> getChildrenScriptObjects(FacesContext context, UIComponent component) {
        ArrayList<JSObject> res = new ArrayList<JSObject>(component.getChildCount());
        for (UIComponent child : component.getChildren()) {
            res.add(this.getChildScriptObject(context, (AbstractTogglePanelItem)child));
        }
        return res;
    }

    private JSObject getChildScriptObject(FacesContext context, AbstractTogglePanelItem child) {
        return ((TogglePanelItemRenderer)child.getRenderer(context)).getScriptObject(context, (UIComponent)child);
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractTogglePanel.class;
    }
}

