/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.richfaces.resource.CacheableResource;
import org.richfaces.resource.DynamicResource;
import org.richfaces.resource.ImageType;
import org.richfaces.resource.Java2DUserResource;
import org.richfaces.resource.StateHolderResource;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamicResource
public abstract class AutocompleteBaseGradient
implements Java2DUserResource,
CacheableResource,
StateHolderResource {
    private static final Dimension DIMENSION = new Dimension(18, 8);
    private String topColorSkinParameter;
    private String bottomColorSkinParameter;
    private Color topColor;
    private Color bottomColor;

    public Map<String, String> getResponseHeaders() {
        return null;
    }

    public Date getLastModified() {
        return null;
    }

    public ImageType getImageType() {
        return ImageType.PNG;
    }

    public Dimension getDimension() {
        return DIMENSION;
    }

    public void paint(Graphics2D graphics2d, Dimension dimension) {
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, this.topColor, 0.0f, dimension.height, this.bottomColor);
        graphics2d.setPaint(paint);
        graphics2d.fill(new Rectangle(dimension));
    }

    public boolean isCacheable(FacesContext context) {
        return true;
    }

    public Date getExpires(FacesContext context) {
        return null;
    }

    public int getTimeToLive(FacesContext context) {
        return 0;
    }

    public String getEntityTag(FacesContext context) {
        return null;
    }

    public void writeState(FacesContext context, DataOutput dataOutput) throws IOException {
        Skin skin = SkinFactory.getInstance().getSkin(context);
        Integer topColor = skin.getColorParameter(context, this.topColorSkinParameter);
        Integer bottomColor = skin.getColorParameter(context, this.bottomColorSkinParameter);
        dataOutput.writeInt(topColor);
        dataOutput.writeInt(bottomColor);
    }

    public void readState(FacesContext context, DataInput dataInput) throws IOException {
        this.topColor = new Color(dataInput.readInt());
        this.bottomColor = new Color(dataInput.readInt());
    }

    public boolean isTransient() {
        return false;
    }

    protected void setTopColorSkinParameter(String topColorSkinParameter) {
        this.topColorSkinParameter = topColorSkinParameter;
    }

    protected void setBottomColorSkinParameter(String bottomColorSkinParameter) {
        this.bottomColorSkinParameter = bottomColorSkinParameter;
    }
}

