/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.util;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.AjaxClientBehavior;
import org.ajax4jsf.component.AjaxComponent;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.richfaces.renderkit.AjaxEventOptions;
import org.richfaces.renderkit.util.HandlersChain;
import org.richfaces.renderkit.util.RendererUtils;

public final class AjaxRendererUtils {
    public static final String AJAX_ABORT_ATTR = "ignoreDupResponses";
    public static final String AJAX_AREAS_RENDERED = "org.ajax4jsf.areas.rendered";
    public static final String AJAX_DELAY_ATTR = "requestDelay";
    public static final String AJAX_FUNCTION_NAME = "RichFaces.ajax";
    public static final String AJAX_QUEUE_ATTR = "eventsQueue";
    public static final String AJAX_SINGLE_ATTR = "ajaxSingle";
    public static final String AJAX_SINGLE_PARAMETER_NAME = "ajaxSingle";
    public static final String ONBEGIN_ATTR_NAME = "onbegin";
    public static final String ONCOMPLETE_CONTENT_ID = "org.ajax4jsf.oncomplete";
    public static final String SIMILARITY_GROUPING_ID_ATTR = "similarityGroupingId";
    public static final String STATUS_ATTR_NAME = "status";
    public static final String VALUE_ATTR = "value";
    public static final String QUEUE_ID_ATTRIBUTE = "queueId";
    private static final RendererUtils RENDERER_UTILS = RendererUtils.getInstance();

    private AjaxRendererUtils() {
    }

    public static StringBuffer buildOnClick(UIComponent uiComponent, FacesContext facesContext) {
        return AjaxRendererUtils.buildOnClick(uiComponent, facesContext, false);
    }

    public static StringBuffer buildOnClick(UIComponent uiComponent, FacesContext facesContext, boolean omitDefaultActionUrl) {
        return AjaxRendererUtils.buildOnEvent(uiComponent, facesContext, "onclick", omitDefaultActionUrl);
    }

    public static StringBuffer buildOnEvent(UIComponent uiComponent, FacesContext facesContext, String eventName) {
        return AjaxRendererUtils.buildOnEvent(uiComponent, facesContext, eventName, false);
    }

    public static StringBuffer buildOnEvent(UIComponent uiComponent, FacesContext facesContext, String eventName, boolean omitDefaultActionUrl) {
        StringBuffer onEvent = new StringBuffer();
        return onEvent;
    }

    public static AjaxEventOptions buildEventOptions(FacesContext facesContext, UIComponent component) {
        return AjaxRendererUtils.buildEventOptions(facesContext, component, null);
    }

    public static AjaxEventOptions buildEventOptions(FacesContext facesContext, UIComponent component, AjaxClientBehavior ajaxBehavior) {
        AjaxEventOptions ajaxEventOptions = new AjaxEventOptions();
        Map<String, Object> parametersMap = RENDERER_UTILS.createParametersMap(facesContext, component);
        String ajaxStatusName = AjaxRendererUtils.getAjaxStatus(component);
        if (ajaxBehavior != null) {
            ajaxStatusName = ajaxBehavior.getStatus() != null ? ajaxBehavior.getStatus() : ajaxStatusName;
            AjaxRendererUtils.appenAjaxBehaviorOptions(ajaxBehavior, ajaxEventOptions);
        } else {
            AjaxRendererUtils.appendComponentOptions(facesContext, component, ajaxEventOptions);
        }
        if (ajaxStatusName != null && ajaxStatusName.length() != 0) {
            ajaxEventOptions.set(STATUS_ATTR_NAME, ajaxStatusName);
        }
        if (!parametersMap.isEmpty()) {
            ajaxEventOptions.getParameters().putAll(parametersMap);
        }
        return ajaxEventOptions;
    }

    private static boolean isNotEmpty(String value) {
        return value != null && value.length() != 0;
    }

    private static void appenAjaxBehaviorOptions(AjaxClientBehavior behavior, AjaxEventOptions ajaxEventOptions) {
        for (BehaviorEventOptionsData optionsData : BehaviorEventOptionsData.values()) {
            String eventHandlerValue = optionsData.getAttributeValue(behavior);
            if (!AjaxRendererUtils.isNotEmpty(eventHandlerValue)) continue;
            ajaxEventOptions.set(optionsData.toString(), eventHandlerValue);
        }
    }

    private static void appendComponentOptions(FacesContext facesContext, UIComponent component, AjaxEventOptions ajaxEventOptions) {
        String queueId;
        String behaviorName = "begin";
        HandlersChain handlersChain = new HandlersChain(facesContext, component);
        String inlineHandler = AjaxRendererUtils.getAjaxOnBegin(component);
        handlersChain.addInlineHandlerAsValue(inlineHandler);
        handlersChain.addBehaviors(behaviorName);
        String handlerScript = handlersChain.toScript();
        if (AjaxRendererUtils.isNotEmpty(handlerScript)) {
            ajaxEventOptions.set(behaviorName, handlerScript);
        }
        if (AjaxRendererUtils.isNotEmpty(queueId = AjaxRendererUtils.getQueueId(component))) {
            ajaxEventOptions.set(QUEUE_ID_ATTRIBUTE, queueId);
        }
        ajaxEventOptions.set("incId", "1");
    }

    public static JSFunction buildAjaxFunction(FacesContext facesContext, UIComponent uiComponent, String functionName) {
        JSFunction ajaxFunction = new JSFunction(functionName, new Object[0]);
        ajaxFunction.addParameter((Object)uiComponent.getClientId(facesContext));
        ajaxFunction.addParameter((Object)JSReference.EVENT);
        return ajaxFunction;
    }

    public static String getAjaxStatus(UIComponent component) {
        String statusId = component instanceof AjaxComponent ? ((AjaxComponent)component).getStatus() : (String)component.getAttributes().get(STATUS_ATTR_NAME);
        return statusId;
    }

    public static String getQueueId(UIComponent component) {
        return (String)component.getAttributes().get(QUEUE_ID_ATTRIBUTE);
    }

    public static JSFunctionDefinition buildAjaxOncomplete(String body) {
        JSFunctionDefinition function = new JSFunctionDefinition(new Object[]{"request", "event", "data"});
        function.addToBody((Object)body);
        return function;
    }

    public static JSFunctionDefinition buildAjaxOnBeforeDomUpdate(String body) {
        JSFunctionDefinition function = new JSFunctionDefinition(new Object[]{"request", "event", "data"});
        function.addToBody((Object)body);
        return function;
    }

    public static String getAjaxOnBegin(UIComponent component) {
        if (component instanceof AjaxComponent) {
            return ((AjaxComponent)component).getOnbegin();
        }
        return (String)component.getAttributes().get(ONBEGIN_ATTR_NAME);
    }

    protected static String getAjaxActionUrl(FacesContext facesContext) {
        return AjaxContext.getCurrentInstance((FacesContext)facesContext).getAjaxActionURL(facesContext);
    }

    public static boolean isAjaxRequest(FacesContext facesContext) {
        return AjaxContext.getCurrentInstance((FacesContext)facesContext).isAjaxRequest();
    }

    public static void addRegionsFromComponent(UIComponent component, FacesContext facesContext) {
        AjaxContext.getCurrentInstance((FacesContext)facesContext).addRegionsFromComponent(component);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BehaviorEventOptionsData {
        begin{

            public String getAttributeValue(AjaxClientBehavior behavior) {
                return behavior.getOnbegin();
            }
        }
        ,
        error{

            public String getAttributeValue(AjaxClientBehavior behavior) {
                return behavior.getOnerror();
            }
        }
        ,
        queueId{

            public String getAttributeValue(AjaxClientBehavior behavior) {
                return behavior.getQueueId();
            }
        }
        ,
        event{

            public String getAttributeValue(AjaxClientBehavior behavior) {
                return behavior.getOnevent();
            }
        };


        public abstract String getAttributeValue(AjaxClientBehavior var1);
    }
}

