/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.view.facelets.html;

import java.util.Locale;
import javax.faces.application.Application;
import javax.faces.view.facelets.BehaviorHandler;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.ConverterHandler;
import javax.faces.view.facelets.TagHandlerDelegate;
import javax.faces.view.facelets.TagHandlerDelegateFactory;
import javax.faces.view.facelets.ValidatorHandler;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.view.facelets.html.BehaviorsAddingComponentHandlerWrapper;

public class BehaviorsTagHandlerDelegateFactoryImpl
extends TagHandlerDelegateFactory {
    private static final Logger LOGGER = RichfacesLogger.WEBAPP.getLogger();
    private TagHandlerDelegateFactory factory;
    private boolean isMyFaces = false;

    public BehaviorsTagHandlerDelegateFactoryImpl(TagHandlerDelegateFactory factory) {
        this.factory = factory;
        this.detectMyFaces();
    }

    private void detectMyFaces() {
        String implementationTitle = Application.class.getPackage().getImplementationTitle();
        if (implementationTitle != null) {
            this.isMyFaces = implementationTitle.toLowerCase(Locale.US).contains("myfaces");
            if (this.isMyFaces) {
                LOGGER.warn((CharSequence)"MyFaces implementation of JavaServer Faces detected. Wrapping of components using RichFaces behaviors (a4j:ajax etc.) won't work!");
            }
        } else {
            LOGGER.warn((CharSequence)"Cannot detect Mojarra vs MyFaces implementation of JavaServer Faces");
        }
    }

    public TagHandlerDelegate createBehaviorHandlerDelegate(BehaviorHandler owner) {
        return this.factory.createBehaviorHandlerDelegate(owner);
    }

    public TagHandlerDelegate createComponentHandlerDelegate(ComponentHandler owner) {
        ComponentHandler handler = owner;
        if (!this.isMyFaces) {
            handler = new BehaviorsAddingComponentHandlerWrapper(owner);
        }
        return this.factory.createComponentHandlerDelegate(handler);
    }

    public TagHandlerDelegate createConverterHandlerDelegate(ConverterHandler owner) {
        return this.factory.createConverterHandlerDelegate(owner);
    }

    public TagHandlerDelegate createValidatorHandlerDelegate(ValidatorHandler owner) {
        return this.factory.createValidatorHandlerDelegate(owner);
    }
}

