/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractAutocomplete;
import javax.el.MethodExpression;
import javax.faces.convert.Converter;

/**
 *  @author Nick Belaevski
 

 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class UIAutocomplete extends AbstractAutocomplete
    implements ClientBehaviorHolder
    {

    public static final String COMPONENT_TYPE="org.richfaces.Autocomplete";

    public static final String COMPONENT_FAMILY="javax.faces.Input";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIAutocomplete() {
        super();
        setRendererType("org.richfaces.AutocompleteRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "mousedown",
        "listdblclick",
        "mouseover",
        "begin",
        "error",
        "mousemove",
        "keydown",
        "mouseout",
        "keypress",
        "selectitem",
        "dblclick",
        "listmousemove",
        "listmouseout",
        "listclick",
        "mouseup",
        "keyup",
        "listkeyup",
        "click",
        "listmouseover",
        "blur",
        "listkeypress",
        "beforedomupdate",
        "complete",
        "listkeydown",
        "listmousedown",
        "focus",
        "change",
        "listmouseup"

        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return null;
    }

    protected static enum Properties {
        autocompleteList,
        autocompleteMethod,
        autofill,
        clientFilter,
        disabled,
        fetchValue,
        filterFunction,
        itemConverter,
        layout,
        minChars,
        mode,
        onbeforedomupdate,
        onbegin,
        onblur,
        onchange,
        onclick,
        oncomplete,
        ondblclick,
        onerror,
        onfocus,
        onkeydown,
        onkeypress,
        onkeyup,
        onlistclick,
        onlistdblclick,
        onlistkeydown,
        onlistkeypress,
        onlistkeyup,
        onlistmousedown,
        onlistmousemove,
        onlistmouseout,
        onlistmouseover,
        onlistmouseup,
        onmousedown,
        onmousemove,
        onmouseout,
        onmouseover,
        onmouseup,
        onselectitem,
        selectFirst,
        selectedItemClass,
        showButton,
        tokens,
        var

    }


 
    public Object getAutocompleteList() {
        return (Object) getStateHelper().eval(Properties.autocompleteList);
    }
    
    public void setAutocompleteList(Object autocompleteList) {
        getStateHelper().put(Properties.autocompleteList, autocompleteList);
    }

 
    public javax.el.MethodExpression getAutocompleteMethod() {
        return (MethodExpression) getStateHelper().get(Properties.autocompleteMethod);
    }
    
    public void setAutocompleteMethod(javax.el.MethodExpression autocompleteMethod) {
        getStateHelper().put(Properties.autocompleteMethod, autocompleteMethod);
    }

 
    public boolean isAutofill() {
        return Boolean.valueOf(getStateHelper().eval(Properties.autofill, true).toString());
    }
    
    public void setAutofill(boolean autofill) {
        getStateHelper().put(Properties.autofill, autofill);
    }

 
    public String getClientFilter() {
        return (String) getStateHelper().eval(Properties.clientFilter);
    }
    
    public void setClientFilter(String clientFilter) {
        getStateHelper().put(Properties.clientFilter, clientFilter);
    }

 
    public boolean isDisabled() {
        return Boolean.valueOf(getStateHelper().eval(Properties.disabled, false).toString());
    }
    
    public void setDisabled(boolean disabled) {
        getStateHelper().put(Properties.disabled, disabled);
    }

 
    public Object getFetchValue() {
        return (Object) getStateHelper().eval(Properties.fetchValue);
    }
    
    public void setFetchValue(Object fetchValue) {
        getStateHelper().put(Properties.fetchValue, fetchValue);
    }

 
    public String getFilterFunction() {
        return (String) getStateHelper().eval(Properties.filterFunction);
    }
    
    public void setFilterFunction(String filterFunction) {
        getStateHelper().put(Properties.filterFunction, filterFunction);
    }

 
    public javax.faces.convert.Converter getItemConverter() {
        return (Converter) getStateHelper().eval(Properties.itemConverter);
    }
    
    public void setItemConverter(javax.faces.convert.Converter itemConverter) {
        getStateHelper().put(Properties.itemConverter, itemConverter);
    }

 
    public String getLayout() {
        return (String) getStateHelper().eval(Properties.layout);
    }
    
    public void setLayout(String layout) {
        getStateHelper().put(Properties.layout, layout);
    }

 
    public int getMinChars() {
        return (Integer) getStateHelper().eval(Properties.minChars, 1);
    }
    
    public void setMinChars(int minChars) {
        getStateHelper().put(Properties.minChars, minChars);
    }

 
    public String getMode() {
        return (String) getStateHelper().eval(Properties.mode);
    }
    
    public void setMode(String mode) {
        getStateHelper().put(Properties.mode, mode);
    }

 
    public String getOnbeforedomupdate() {
        return (String) getStateHelper().eval(Properties.onbeforedomupdate);
    }
    
    public void setOnbeforedomupdate(String onbeforedomupdate) {
        getStateHelper().put(Properties.onbeforedomupdate, onbeforedomupdate);
    }

 
    public String getOnbegin() {
        return (String) getStateHelper().eval(Properties.onbegin);
    }
    
    public void setOnbegin(String onbegin) {
        getStateHelper().put(Properties.onbegin, onbegin);
    }

 
    public String getOnblur() {
        return (String) getStateHelper().eval(Properties.onblur);
    }
    
    public void setOnblur(String onblur) {
        getStateHelper().put(Properties.onblur, onblur);
    }

 
    public String getOnchange() {
        return (String) getStateHelper().eval(Properties.onchange);
    }
    
    public void setOnchange(String onchange) {
        getStateHelper().put(Properties.onchange, onchange);
    }

 
    public String getOnclick() {
        return (String) getStateHelper().eval(Properties.onclick);
    }
    
    public void setOnclick(String onclick) {
        getStateHelper().put(Properties.onclick, onclick);
    }

 
    public String getOncomplete() {
        return (String) getStateHelper().eval(Properties.oncomplete);
    }
    
    public void setOncomplete(String oncomplete) {
        getStateHelper().put(Properties.oncomplete, oncomplete);
    }

 
    public String getOndblclick() {
        return (String) getStateHelper().eval(Properties.ondblclick);
    }
    
    public void setOndblclick(String ondblclick) {
        getStateHelper().put(Properties.ondblclick, ondblclick);
    }

 
    public String getOnerror() {
        return (String) getStateHelper().eval(Properties.onerror);
    }
    
    public void setOnerror(String onerror) {
        getStateHelper().put(Properties.onerror, onerror);
    }

 
    public String getOnfocus() {
        return (String) getStateHelper().eval(Properties.onfocus);
    }
    
    public void setOnfocus(String onfocus) {
        getStateHelper().put(Properties.onfocus, onfocus);
    }

 
    public String getOnkeydown() {
        return (String) getStateHelper().eval(Properties.onkeydown);
    }
    
    public void setOnkeydown(String onkeydown) {
        getStateHelper().put(Properties.onkeydown, onkeydown);
    }

 
    public String getOnkeypress() {
        return (String) getStateHelper().eval(Properties.onkeypress);
    }
    
    public void setOnkeypress(String onkeypress) {
        getStateHelper().put(Properties.onkeypress, onkeypress);
    }

 
    public String getOnkeyup() {
        return (String) getStateHelper().eval(Properties.onkeyup);
    }
    
    public void setOnkeyup(String onkeyup) {
        getStateHelper().put(Properties.onkeyup, onkeyup);
    }

 
    public String getOnlistclick() {
        return (String) getStateHelper().eval(Properties.onlistclick);
    }
    
    public void setOnlistclick(String onlistclick) {
        getStateHelper().put(Properties.onlistclick, onlistclick);
    }

 
    public String getOnlistdblclick() {
        return (String) getStateHelper().eval(Properties.onlistdblclick);
    }
    
    public void setOnlistdblclick(String onlistdblclick) {
        getStateHelper().put(Properties.onlistdblclick, onlistdblclick);
    }

 
    public String getOnlistkeydown() {
        return (String) getStateHelper().eval(Properties.onlistkeydown);
    }
    
    public void setOnlistkeydown(String onlistkeydown) {
        getStateHelper().put(Properties.onlistkeydown, onlistkeydown);
    }

 
    public String getOnlistkeypress() {
        return (String) getStateHelper().eval(Properties.onlistkeypress);
    }
    
    public void setOnlistkeypress(String onlistkeypress) {
        getStateHelper().put(Properties.onlistkeypress, onlistkeypress);
    }

 
    public String getOnlistkeyup() {
        return (String) getStateHelper().eval(Properties.onlistkeyup);
    }
    
    public void setOnlistkeyup(String onlistkeyup) {
        getStateHelper().put(Properties.onlistkeyup, onlistkeyup);
    }

 
    public String getOnlistmousedown() {
        return (String) getStateHelper().eval(Properties.onlistmousedown);
    }
    
    public void setOnlistmousedown(String onlistmousedown) {
        getStateHelper().put(Properties.onlistmousedown, onlistmousedown);
    }

 
    public String getOnlistmousemove() {
        return (String) getStateHelper().eval(Properties.onlistmousemove);
    }
    
    public void setOnlistmousemove(String onlistmousemove) {
        getStateHelper().put(Properties.onlistmousemove, onlistmousemove);
    }

 
    public String getOnlistmouseout() {
        return (String) getStateHelper().eval(Properties.onlistmouseout);
    }
    
    public void setOnlistmouseout(String onlistmouseout) {
        getStateHelper().put(Properties.onlistmouseout, onlistmouseout);
    }

 
    public String getOnlistmouseover() {
        return (String) getStateHelper().eval(Properties.onlistmouseover);
    }
    
    public void setOnlistmouseover(String onlistmouseover) {
        getStateHelper().put(Properties.onlistmouseover, onlistmouseover);
    }

 
    public String getOnlistmouseup() {
        return (String) getStateHelper().eval(Properties.onlistmouseup);
    }
    
    public void setOnlistmouseup(String onlistmouseup) {
        getStateHelper().put(Properties.onlistmouseup, onlistmouseup);
    }

 
    public String getOnmousedown() {
        return (String) getStateHelper().eval(Properties.onmousedown);
    }
    
    public void setOnmousedown(String onmousedown) {
        getStateHelper().put(Properties.onmousedown, onmousedown);
    }

 
    public String getOnmousemove() {
        return (String) getStateHelper().eval(Properties.onmousemove);
    }
    
    public void setOnmousemove(String onmousemove) {
        getStateHelper().put(Properties.onmousemove, onmousemove);
    }

 
    public String getOnmouseout() {
        return (String) getStateHelper().eval(Properties.onmouseout);
    }
    
    public void setOnmouseout(String onmouseout) {
        getStateHelper().put(Properties.onmouseout, onmouseout);
    }

 
    public String getOnmouseover() {
        return (String) getStateHelper().eval(Properties.onmouseover);
    }
    
    public void setOnmouseover(String onmouseover) {
        getStateHelper().put(Properties.onmouseover, onmouseover);
    }

 
    public String getOnmouseup() {
        return (String) getStateHelper().eval(Properties.onmouseup);
    }
    
    public void setOnmouseup(String onmouseup) {
        getStateHelper().put(Properties.onmouseup, onmouseup);
    }

 
    public String getOnselectitem() {
        return (String) getStateHelper().eval(Properties.onselectitem);
    }
    
    public void setOnselectitem(String onselectitem) {
        getStateHelper().put(Properties.onselectitem, onselectitem);
    }

 
    public boolean isSelectFirst() {
        return Boolean.valueOf(getStateHelper().eval(Properties.selectFirst, true).toString());
    }
    
    public void setSelectFirst(boolean selectFirst) {
        getStateHelper().put(Properties.selectFirst, selectFirst);
    }

 
    public String getSelectedItemClass() {
        return (String) getStateHelper().eval(Properties.selectedItemClass, "rf-au-sel");
    }
    
    public void setSelectedItemClass(String selectedItemClass) {
        getStateHelper().put(Properties.selectedItemClass, selectedItemClass);
    }

 
    public boolean isShowButton() {
        return Boolean.valueOf(getStateHelper().eval(Properties.showButton, false).toString());
    }
    
    public void setShowButton(boolean showButton) {
        getStateHelper().put(Properties.showButton, showButton);
    }

 
    public String getTokens() {
        return (String) getStateHelper().eval(Properties.tokens);
    }
    
    public void setTokens(String tokens) {
        getStateHelper().put(Properties.tokens, tokens);
    }

 
    public String getVar() {
        return (String) getStateHelper().get(Properties.var);
    }
    
    public void setVar(String var) {
        getStateHelper().put(Properties.var, var);
    }

}