/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractColumn;
import java.util.Comparator;
import org.richfaces.component.SortOrder;
import org.richfaces.model.Filter;

/**
 *  @author Anton Belevich


 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class UIColumn extends AbstractColumn
        {

    public static final String COMPONENT_TYPE="org.richfaces.Column";

    public static final String COMPONENT_FAMILY="org.richfaces.Column";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }





    protected static enum Properties {
        breakRowBefore,
        colspan,
        comparator,
        filter,
        filterValue,
        rowspan,
        sortOrder

    }


 
    public boolean isBreakRowBefore() {
        return Boolean.valueOf(getStateHelper().eval(Properties.breakRowBefore, false).toString());
    }
    
    public void setBreakRowBefore(boolean breakRowBefore) {
        getStateHelper().put(Properties.breakRowBefore, breakRowBefore);
    }

 
    public int getColspan() {
        return (Integer) getStateHelper().eval(Properties.colspan, Integer.MIN_VALUE);
    }
    
    public void setColspan(int colspan) {
        getStateHelper().put(Properties.colspan, colspan);
    }

 
    public java.util.Comparator getComparator() {
        return (Comparator) getStateHelper().eval(Properties.comparator);
    }
    
    public void setComparator(java.util.Comparator comparator) {
        getStateHelper().put(Properties.comparator, comparator);
    }

 
    public org.richfaces.model.Filter getFilter() {
        return (Filter) getStateHelper().eval(Properties.filter);
    }
    
    public void setFilter(org.richfaces.model.Filter filter) {
        getStateHelper().put(Properties.filter, filter);
    }

 
    public Object getFilterValue() {
        return (Object) getStateHelper().eval(Properties.filterValue);
    }
    
    public void setFilterValue(Object filterValue) {
        getStateHelper().put(Properties.filterValue, filterValue);
    }

 
    public int getRowspan() {
        return (Integer) getStateHelper().eval(Properties.rowspan, Integer.MIN_VALUE);
    }
    
    public void setRowspan(int rowspan) {
        getStateHelper().put(Properties.rowspan, rowspan);
    }

 
    public org.richfaces.component.SortOrder getSortOrder() {
        return (SortOrder) getStateHelper().eval(Properties.sortOrder, SortOrder.unsorted);
    }
    
    public void setSortOrder(org.richfaces.component.SortOrder sortOrder) {
        getStateHelper().put(Properties.sortOrder, sortOrder);
    }

}