/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractDataScroller;

/**
 * 
 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class UIDataScroller extends AbstractDataScroller
        {

    public static final String COMPONENT_TYPE="org.richfaces.DataScroller";

    public static final String COMPONENT_FAMILY="org.richfaces.DataScroller";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIDataScroller() {
        super();
        setRendererType("org.richfaces.DataScrollerRenderer");
    }



    protected static enum Properties {
        boundaryControls,
        fastControls,
        fastStep,
        forComponent,
        lastPageMode,
        maxPages,
        stepControls

    }


 
    public String getBoundaryControls() {
        return (String) getStateHelper().eval(Properties.boundaryControls, "show");
    }
    
    public void setBoundaryControls(String boundaryControls) {
        getStateHelper().put(Properties.boundaryControls, boundaryControls);
    }

 
    public String getFastControls() {
        return (String) getStateHelper().eval(Properties.fastControls, "show");
    }
    
    public void setFastControls(String fastControls) {
        getStateHelper().put(Properties.fastControls, fastControls);
    }

 
    public int getFastStep() {
        return (Integer) getStateHelper().eval(Properties.fastStep, 1);
    }
    
    public void setFastStep(int fastStep) {
        getStateHelper().put(Properties.fastStep, fastStep);
    }

 
    public String getForComponent() {
        return (String) getStateHelper().eval(Properties.forComponent);
    }
    
    public void setForComponent(String forComponent) {
        getStateHelper().put(Properties.forComponent, forComponent);
    }

 
    public String getLastPageMode() {
        return (String) getStateHelper().eval(Properties.lastPageMode);
    }
    
    public void setLastPageMode(String lastPageMode) {
        getStateHelper().put(Properties.lastPageMode, lastPageMode);
    }

 
    public int getMaxPages() {
        return (Integer) getStateHelper().eval(Properties.maxPages, 10);
    }
    
    public void setMaxPages(int maxPages) {
        getStateHelper().put(Properties.maxPages, maxPages);
    }

 
    public String getStepControls() {
        return (String) getStateHelper().eval(Properties.stepControls, "show");
    }
    
    public void setStepControls(String stepControls) {
        getStateHelper().put(Properties.stepControls, stepControls);
    }

}