/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractExtendedDataTable;
import java.util.Collection;
import org.richfaces.model.SortMode;

/**
 *  @author Konstantin Mishin
 

 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class UIExtendedDataTable extends AbstractExtendedDataTable
    implements ClientBehaviorHolder
    {

    public static final String COMPONENT_TYPE="org.richfaces.ExtendedDataTable";

    public static final String COMPONENT_FAMILY="org.richfaces.Data";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIExtendedDataTable() {
        super();
        setRendererType("org.richfaces.ExtendedDataTableRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "selectionchange",
        "beforeselectionchange"

        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return "selectionchange";
    }

    protected static enum Properties {
        beforeselectionchange,
        filterVar,
        frozenColumns,
        noDataLabel,
        selection,
        selectionchange,
        sortMode,
        sortPriority

    }


 
    public String getBeforeselectionchange() {
        return (String) getStateHelper().eval(Properties.beforeselectionchange);
    }
    
    public void setBeforeselectionchange(String beforeselectionchange) {
        getStateHelper().put(Properties.beforeselectionchange, beforeselectionchange);
    }

 
    public String getFilterVar() {
        return (String) getStateHelper().eval(Properties.filterVar);
    }
    
    public void setFilterVar(String filterVar) {
        getStateHelper().put(Properties.filterVar, filterVar);
    }

 
    public int getFrozenColumns() {
        return (Integer) getStateHelper().eval(Properties.frozenColumns, 0);
    }
    
    public void setFrozenColumns(int frozenColumns) {
        getStateHelper().put(Properties.frozenColumns, frozenColumns);
    }

 
    public String getNoDataLabel() {
        return (String) getStateHelper().eval(Properties.noDataLabel);
    }
    
    public void setNoDataLabel(String noDataLabel) {
        getStateHelper().put(Properties.noDataLabel, noDataLabel);
    }

 
    public java.util.Collection getSelection() {
        return (Collection) getStateHelper().eval(Properties.selection);
    }
    
    public void setSelection(java.util.Collection selection) {
        getStateHelper().put(Properties.selection, selection);
    }

 
    public String getSelectionchange() {
        return (String) getStateHelper().eval(Properties.selectionchange);
    }
    
    public void setSelectionchange(String selectionchange) {
        getStateHelper().put(Properties.selectionchange, selectionchange);
    }

 
    public org.richfaces.model.SortMode getSortMode() {
        return (SortMode) getStateHelper().eval(Properties.sortMode);
    }
    
    public void setSortMode(org.richfaces.model.SortMode sortMode) {
        getStateHelper().put(Properties.sortMode, sortMode);
    }

 
    public java.util.Collection getSortPriority() {
        return (Collection) getStateHelper().eval(Properties.sortPriority);
    }
    
    public void setSortPriority(java.util.Collection sortPriority) {
        getStateHelper().put(Properties.sortPriority, sortPriority);
    }

}