/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractInplaceInput;
import org.richfaces.component.InplaceState;

/**
 *  @author Anton Belevich 


 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class UIInplaceInput extends AbstractInplaceInput
    implements ClientBehaviorHolder
    {

    public static final String COMPONENT_TYPE="org.richfaces.InplaceInput";

    public static final String COMPONENT_FAMILY="org.richfaces.InplaceInput";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIInplaceInput() {
        super();
        setRendererType("org.richfaces.InplaceInputRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "inputMouseout",
        "mousedown",
        "inputMousedown",
        "mouseover",
        "mousemove",
        "ondblclick",
        "keydown",
        "mouseout",
        "keypress",
        "inputKeydown",
        "inputMousemove",
        "inputDblclick",
        "inputBlur",
        "select",
        "mouseup",
        "keyup",
        "inputMouseup",
        "click",
        "blur",
        "inputKeypress",
        "inputClick",
        "inputFocus",
        "oninputKeyup",
        "inputMouseover",
        "focus",
        "change"

        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return null;
    }

    protected static enum Properties {
        defaultLabel,
        editEvent,
        inputWidth,
        onInputBlur,
        onInputClick,
        onInputDblclick,
        onInputFocus,
        onInputKeydown,
        onInputKeypress,
        onInputKeypup,
        onInputMousedown,
        onInputMousemove,
        onInputMouseout,
        onInputMouseover,
        onInputMouseup,
        onblur,
        onchange,
        onclick,
        ondblclick,
        onfocus,
        onkeydown,
        onkeypress,
        onkeypup,
        onmousedown,
        onmousemove,
        onmouseout,
        onmouseover,
        onmouseup,
        onselect,
        showControls,
        state,
        tabIndex

    }


 
    public String getDefaultLabel() {
        return (String) getStateHelper().eval(Properties.defaultLabel);
    }
    
    public void setDefaultLabel(String defaultLabel) {
        getStateHelper().put(Properties.defaultLabel, defaultLabel);
    }

 
    public String getEditEvent() {
        return (String) getStateHelper().eval(Properties.editEvent, "click");
    }
    
    public void setEditEvent(String editEvent) {
        getStateHelper().put(Properties.editEvent, editEvent);
    }

 
    public String getInputWidth() {
        return (String) getStateHelper().eval(Properties.inputWidth, "100%");
    }
    
    public void setInputWidth(String inputWidth) {
        getStateHelper().put(Properties.inputWidth, inputWidth);
    }

 
    public String getOnInputBlur() {
        return (String) getStateHelper().eval(Properties.onInputBlur);
    }
    
    public void setOnInputBlur(String onInputBlur) {
        getStateHelper().put(Properties.onInputBlur, onInputBlur);
    }

 
    public String getOnInputClick() {
        return (String) getStateHelper().eval(Properties.onInputClick);
    }
    
    public void setOnInputClick(String onInputClick) {
        getStateHelper().put(Properties.onInputClick, onInputClick);
    }

 
    public String getOnInputDblclick() {
        return (String) getStateHelper().eval(Properties.onInputDblclick);
    }
    
    public void setOnInputDblclick(String onInputDblclick) {
        getStateHelper().put(Properties.onInputDblclick, onInputDblclick);
    }

 
    public String getOnInputFocus() {
        return (String) getStateHelper().eval(Properties.onInputFocus);
    }
    
    public void setOnInputFocus(String onInputFocus) {
        getStateHelper().put(Properties.onInputFocus, onInputFocus);
    }

 
    public String getOnInputKeydown() {
        return (String) getStateHelper().eval(Properties.onInputKeydown);
    }
    
    public void setOnInputKeydown(String onInputKeydown) {
        getStateHelper().put(Properties.onInputKeydown, onInputKeydown);
    }

 
    public String getOnInputKeypress() {
        return (String) getStateHelper().eval(Properties.onInputKeypress);
    }
    
    public void setOnInputKeypress(String onInputKeypress) {
        getStateHelper().put(Properties.onInputKeypress, onInputKeypress);
    }

 
    public String getOnInputKeypup() {
        return (String) getStateHelper().eval(Properties.onInputKeypup);
    }
    
    public void setOnInputKeypup(String onInputKeypup) {
        getStateHelper().put(Properties.onInputKeypup, onInputKeypup);
    }

 
    public String getOnInputMousedown() {
        return (String) getStateHelper().eval(Properties.onInputMousedown);
    }
    
    public void setOnInputMousedown(String onInputMousedown) {
        getStateHelper().put(Properties.onInputMousedown, onInputMousedown);
    }

 
    public String getOnInputMousemove() {
        return (String) getStateHelper().eval(Properties.onInputMousemove);
    }
    
    public void setOnInputMousemove(String onInputMousemove) {
        getStateHelper().put(Properties.onInputMousemove, onInputMousemove);
    }

 
    public String getOnInputMouseout() {
        return (String) getStateHelper().eval(Properties.onInputMouseout);
    }
    
    public void setOnInputMouseout(String onInputMouseout) {
        getStateHelper().put(Properties.onInputMouseout, onInputMouseout);
    }

 
    public String getOnInputMouseover() {
        return (String) getStateHelper().eval(Properties.onInputMouseover);
    }
    
    public void setOnInputMouseover(String onInputMouseover) {
        getStateHelper().put(Properties.onInputMouseover, onInputMouseover);
    }

 
    public String getOnInputMouseup() {
        return (String) getStateHelper().eval(Properties.onInputMouseup);
    }
    
    public void setOnInputMouseup(String onInputMouseup) {
        getStateHelper().put(Properties.onInputMouseup, onInputMouseup);
    }

 
    public String getOnblur() {
        return (String) getStateHelper().eval(Properties.onblur);
    }
    
    public void setOnblur(String onblur) {
        getStateHelper().put(Properties.onblur, onblur);
    }

 
    public String getOnchange() {
        return (String) getStateHelper().eval(Properties.onchange);
    }
    
    public void setOnchange(String onchange) {
        getStateHelper().put(Properties.onchange, onchange);
    }

 
    public String getOnclick() {
        return (String) getStateHelper().eval(Properties.onclick);
    }
    
    public void setOnclick(String onclick) {
        getStateHelper().put(Properties.onclick, onclick);
    }

 
    public String getOndblclick() {
        return (String) getStateHelper().eval(Properties.ondblclick);
    }
    
    public void setOndblclick(String ondblclick) {
        getStateHelper().put(Properties.ondblclick, ondblclick);
    }

 
    public String getOnfocus() {
        return (String) getStateHelper().eval(Properties.onfocus);
    }
    
    public void setOnfocus(String onfocus) {
        getStateHelper().put(Properties.onfocus, onfocus);
    }

 
    public String getOnkeydown() {
        return (String) getStateHelper().eval(Properties.onkeydown);
    }
    
    public void setOnkeydown(String onkeydown) {
        getStateHelper().put(Properties.onkeydown, onkeydown);
    }

 
    public String getOnkeypress() {
        return (String) getStateHelper().eval(Properties.onkeypress);
    }
    
    public void setOnkeypress(String onkeypress) {
        getStateHelper().put(Properties.onkeypress, onkeypress);
    }

 
    public String getOnkeypup() {
        return (String) getStateHelper().eval(Properties.onkeypup);
    }
    
    public void setOnkeypup(String onkeypup) {
        getStateHelper().put(Properties.onkeypup, onkeypup);
    }

 
    public String getOnmousedown() {
        return (String) getStateHelper().eval(Properties.onmousedown);
    }
    
    public void setOnmousedown(String onmousedown) {
        getStateHelper().put(Properties.onmousedown, onmousedown);
    }

 
    public String getOnmousemove() {
        return (String) getStateHelper().eval(Properties.onmousemove);
    }
    
    public void setOnmousemove(String onmousemove) {
        getStateHelper().put(Properties.onmousemove, onmousemove);
    }

 
    public String getOnmouseout() {
        return (String) getStateHelper().eval(Properties.onmouseout);
    }
    
    public void setOnmouseout(String onmouseout) {
        getStateHelper().put(Properties.onmouseout, onmouseout);
    }

 
    public String getOnmouseover() {
        return (String) getStateHelper().eval(Properties.onmouseover);
    }
    
    public void setOnmouseover(String onmouseover) {
        getStateHelper().put(Properties.onmouseover, onmouseover);
    }

 
    public String getOnmouseup() {
        return (String) getStateHelper().eval(Properties.onmouseup);
    }
    
    public void setOnmouseup(String onmouseup) {
        getStateHelper().put(Properties.onmouseup, onmouseup);
    }

 
    public String getOnselect() {
        return (String) getStateHelper().eval(Properties.onselect);
    }
    
    public void setOnselect(String onselect) {
        getStateHelper().put(Properties.onselect, onselect);
    }

 
    public boolean isShowControls() {
        return Boolean.valueOf(getStateHelper().eval(Properties.showControls, false).toString());
    }
    
    public void setShowControls(boolean showControls) {
        getStateHelper().put(Properties.showControls, showControls);
    }

 
    public org.richfaces.component.InplaceState getState() {
        return (InplaceState) getStateHelper().eval(Properties.state, InplaceState.ready);
    }
    
    public void setState(org.richfaces.component.InplaceState state) {
        getStateHelper().put(Properties.state, state);
    }

 
    public String getTabIndex() {
        return (String) getStateHelper().eval(Properties.tabIndex);
    }
    
    public void setTabIndex(String tabIndex) {
        getStateHelper().put(Properties.tabIndex, tabIndex);
    }

}