/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractList;
import org.richfaces.component.ListType;

/**
 *  JSF component class
 

 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class UIList extends AbstractList
    implements ClientBehaviorHolder
    {

    public static final String COMPONENT_TYPE="org.richfaces.List";

    public static final String COMPONENT_FAMILY="org.richfaces.List";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIList() {
        super();
        setRendererType("org.richfaces.ListRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "keyup",
        "mousedown",
        "rowmouseup",
        "rowclick",
        "rowmouseover",
        "click",
        "mouseover",
        "mousemove",
        "keydown",
        "mouseout",
        "rowmouseout",
        "rowmousemove",
        "rowdblclick",
        "rowkeyup",
        "keypress",
        "dblclick",
        "rowkeypress",
        "rowmousedown",
        "rowkeydown",
        "mouseup"

        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return null;
    }

    protected static enum Properties {
        dir,
        lang,
        onclick,
        ondblclick,
        onkeydown,
        onkeypress,
        onkeyup,
        onmousedown,
        onmousemove,
        onmouseout,
        onmouseover,
        onmouseup,
        onrowclick,
        onrowdblclick,
        onrowkeydown,
        onrowkeypress,
        onrowkeyup,
        onrowmousedown,
        onrowmousemove,
        onrowmouseout,
        onrowmouseover,
        onrowmouseup,
        rowClass,
        rowClasses,
        style,
        styleClass,
        title,
        type

    }


 
    public String getDir() {
        return (String) getStateHelper().eval(Properties.dir);
    }
    
    public void setDir(String dir) {
        getStateHelper().put(Properties.dir, dir);
    }

 
    public String getLang() {
        return (String) getStateHelper().eval(Properties.lang);
    }
    
    public void setLang(String lang) {
        getStateHelper().put(Properties.lang, lang);
    }

 
    public String getOnclick() {
        return (String) getStateHelper().eval(Properties.onclick);
    }
    
    public void setOnclick(String onclick) {
        getStateHelper().put(Properties.onclick, onclick);
    }

 
    public String getOndblclick() {
        return (String) getStateHelper().eval(Properties.ondblclick);
    }
    
    public void setOndblclick(String ondblclick) {
        getStateHelper().put(Properties.ondblclick, ondblclick);
    }

 
    public String getOnkeydown() {
        return (String) getStateHelper().eval(Properties.onkeydown);
    }
    
    public void setOnkeydown(String onkeydown) {
        getStateHelper().put(Properties.onkeydown, onkeydown);
    }

 
    public String getOnkeypress() {
        return (String) getStateHelper().eval(Properties.onkeypress);
    }
    
    public void setOnkeypress(String onkeypress) {
        getStateHelper().put(Properties.onkeypress, onkeypress);
    }

 
    public String getOnkeyup() {
        return (String) getStateHelper().eval(Properties.onkeyup);
    }
    
    public void setOnkeyup(String onkeyup) {
        getStateHelper().put(Properties.onkeyup, onkeyup);
    }

 
    public String getOnmousedown() {
        return (String) getStateHelper().eval(Properties.onmousedown);
    }
    
    public void setOnmousedown(String onmousedown) {
        getStateHelper().put(Properties.onmousedown, onmousedown);
    }

 
    public String getOnmousemove() {
        return (String) getStateHelper().eval(Properties.onmousemove);
    }
    
    public void setOnmousemove(String onmousemove) {
        getStateHelper().put(Properties.onmousemove, onmousemove);
    }

 
    public String getOnmouseout() {
        return (String) getStateHelper().eval(Properties.onmouseout);
    }
    
    public void setOnmouseout(String onmouseout) {
        getStateHelper().put(Properties.onmouseout, onmouseout);
    }

 
    public String getOnmouseover() {
        return (String) getStateHelper().eval(Properties.onmouseover);
    }
    
    public void setOnmouseover(String onmouseover) {
        getStateHelper().put(Properties.onmouseover, onmouseover);
    }

 
    public String getOnmouseup() {
        return (String) getStateHelper().eval(Properties.onmouseup);
    }
    
    public void setOnmouseup(String onmouseup) {
        getStateHelper().put(Properties.onmouseup, onmouseup);
    }

 
    public String getOnrowclick() {
        return (String) getStateHelper().eval(Properties.onrowclick);
    }
    
    public void setOnrowclick(String onrowclick) {
        getStateHelper().put(Properties.onrowclick, onrowclick);
    }

 
    public String getOnrowdblclick() {
        return (String) getStateHelper().eval(Properties.onrowdblclick);
    }
    
    public void setOnrowdblclick(String onrowdblclick) {
        getStateHelper().put(Properties.onrowdblclick, onrowdblclick);
    }

 
    public String getOnrowkeydown() {
        return (String) getStateHelper().eval(Properties.onrowkeydown);
    }
    
    public void setOnrowkeydown(String onrowkeydown) {
        getStateHelper().put(Properties.onrowkeydown, onrowkeydown);
    }

 
    public String getOnrowkeypress() {
        return (String) getStateHelper().eval(Properties.onrowkeypress);
    }
    
    public void setOnrowkeypress(String onrowkeypress) {
        getStateHelper().put(Properties.onrowkeypress, onrowkeypress);
    }

 
    public String getOnrowkeyup() {
        return (String) getStateHelper().eval(Properties.onrowkeyup);
    }
    
    public void setOnrowkeyup(String onrowkeyup) {
        getStateHelper().put(Properties.onrowkeyup, onrowkeyup);
    }

 
    public String getOnrowmousedown() {
        return (String) getStateHelper().eval(Properties.onrowmousedown);
    }
    
    public void setOnrowmousedown(String onrowmousedown) {
        getStateHelper().put(Properties.onrowmousedown, onrowmousedown);
    }

 
    public String getOnrowmousemove() {
        return (String) getStateHelper().eval(Properties.onrowmousemove);
    }
    
    public void setOnrowmousemove(String onrowmousemove) {
        getStateHelper().put(Properties.onrowmousemove, onrowmousemove);
    }

 
    public String getOnrowmouseout() {
        return (String) getStateHelper().eval(Properties.onrowmouseout);
    }
    
    public void setOnrowmouseout(String onrowmouseout) {
        getStateHelper().put(Properties.onrowmouseout, onrowmouseout);
    }

 
    public String getOnrowmouseover() {
        return (String) getStateHelper().eval(Properties.onrowmouseover);
    }
    
    public void setOnrowmouseover(String onrowmouseover) {
        getStateHelper().put(Properties.onrowmouseover, onrowmouseover);
    }

 
    public String getOnrowmouseup() {
        return (String) getStateHelper().eval(Properties.onrowmouseup);
    }
    
    public void setOnrowmouseup(String onrowmouseup) {
        getStateHelper().put(Properties.onrowmouseup, onrowmouseup);
    }

 
    public String getRowClass() {
        return (String) getStateHelper().eval(Properties.rowClass);
    }
    
    public void setRowClass(String rowClass) {
        getStateHelper().put(Properties.rowClass, rowClass);
    }

 
    public String getRowClasses() {
        return (String) getStateHelper().eval(Properties.rowClasses);
    }
    
    public void setRowClasses(String rowClasses) {
        getStateHelper().put(Properties.rowClasses, rowClasses);
    }

 
    public String getStyle() {
        return (String) getStateHelper().eval(Properties.style);
    }
    
    public void setStyle(String style) {
        getStateHelper().put(Properties.style, style);
    }

 
    public String getStyleClass() {
        return (String) getStateHelper().eval(Properties.styleClass);
    }
    
    public void setStyleClass(String styleClass) {
        getStateHelper().put(Properties.styleClass, styleClass);
    }

 
    public String getTitle() {
        return (String) getStateHelper().eval(Properties.title);
    }
    
    public void setTitle(String title) {
        getStateHelper().put(Properties.title, title);
    }

 
    public org.richfaces.component.ListType getType() {
        return (ListType) getStateHelper().eval(Properties.type);
    }
    
    public void setType(org.richfaces.component.ListType type) {
        getStateHelper().put(Properties.type, type);
    }

}